/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.settings;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.rest.RestRequest;

public class SettingsFilter
extends AbstractComponent {
    public static String SETTINGS_FILTER_PARAM = "settings_filter";
    private final CopyOnWriteArrayList<String> patterns = new CopyOnWriteArrayList();

    @Inject
    public SettingsFilter(Settings settings) {
        super(settings);
    }

    public void addFilter(String pattern) {
        this.patterns.add(pattern);
    }

    public void removeFilter(String pattern) {
        this.patterns.remove(pattern);
    }

    public String getPatterns() {
        return Strings.collectionToDelimitedString(this.patterns, ",");
    }

    public void addFilterSettingParams(RestRequest request) {
        if (!this.patterns.isEmpty()) {
            request.params().put(SETTINGS_FILTER_PARAM, this.getPatterns());
        }
    }

    public static Settings filterSettings(ToXContent.Params params, Settings settings) {
        String patterns = params.param(SETTINGS_FILTER_PARAM);
        Settings filteredSettings = settings;
        if (patterns != null && !patterns.isEmpty()) {
            filteredSettings = SettingsFilter.filterSettings(patterns, filteredSettings);
        }
        return filteredSettings;
    }

    public static Settings filterSettings(String patterns, Settings settings) {
        String[] patternArray = Strings.delimitedListToStringArray(patterns, ",");
        Settings.Builder builder = Settings.settingsBuilder().put(settings);
        ArrayList<String> simpleMatchPatternList = new ArrayList<String>();
        for (String pattern : patternArray) {
            if (Regex.isSimpleMatchPattern(pattern)) {
                simpleMatchPatternList.add(pattern);
                continue;
            }
            builder.remove(pattern);
        }
        if (!simpleMatchPatternList.isEmpty()) {
            String[] simpleMatchPatterns = simpleMatchPatternList.toArray(new String[simpleMatchPatternList.size()]);
            Iterator<Map.Entry<String, String>> iterator = builder.internalMap().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> current = iterator.next();
                if (!Regex.simpleMatch(simpleMatchPatterns, current.getKey())) continue;
                iterator.remove();
            }
        }
        return builder.build();
    }
}

