/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.DelimiterFactory;
import org.scilab.forge.jlatexmath.EmptyAtom;
import org.scilab.forge.jlatexmath.HorizontalBox;
import org.scilab.forge.jlatexmath.OverBar;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.StrutBox;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.TeXFont;

public class NthRoot
extends Atom {
    private static final String sqrtSymbol = "sqrt";
    private static final float FACTOR = 0.55f;
    private final Atom base;
    private final Atom root;

    public NthRoot(Atom atom, Atom atom2) {
        this.base = atom == null ? new EmptyAtom() : atom;
        this.root = atom2 == null ? new EmptyAtom() : atom2;
    }

    public Box createBox(TeXEnvironment teXEnvironment) {
        TeXFont teXFont = teXEnvironment.getTeXFont();
        int n = teXEnvironment.getStyle();
        float f = teXFont.getDefaultRuleThickness(n);
        float f2 = n < 2 ? teXFont.getXHeight(n, teXFont.getChar(sqrtSymbol, n).getFontCode()) : f;
        f2 = f + Math.abs(f2) / 4.0f;
        Box box = this.base.createBox(teXEnvironment.crampStyle());
        HorizontalBox horizontalBox = new HorizontalBox(box);
        horizontalBox.add(new SpaceAtom(5, 1.0f, 0.0f, 0.0f).createBox(teXEnvironment.crampStyle()));
        float f3 = horizontalBox.getHeight() + horizontalBox.getDepth();
        Box box2 = DelimiterFactory.create(sqrtSymbol, teXEnvironment, f3 + f2 + f);
        float f4 = box2.getDepth() - (f3 + f2);
        box2.setShift(-(horizontalBox.getHeight() + (f2 += f4 / 2.0f)));
        OverBar overBar = new OverBar((Box)horizontalBox, f2, box2.getHeight());
        overBar.setShift(-(horizontalBox.getHeight() + f2 + f));
        HorizontalBox horizontalBox2 = new HorizontalBox(box2);
        horizontalBox2.add(overBar);
        if (this.root == null) {
            return horizontalBox2;
        }
        Box box3 = this.root.createBox(teXEnvironment.rootStyle());
        float f5 = 0.55f * (horizontalBox2.getHeight() + horizontalBox2.getDepth());
        box3.setShift(horizontalBox2.getDepth() - box3.getDepth() - f5);
        Box box4 = new SpaceAtom(5, -10.0f, 0.0f, 0.0f).createBox(teXEnvironment);
        HorizontalBox horizontalBox3 = new HorizontalBox();
        float f6 = box3.getWidth() + box4.getWidth();
        if (f6 < 0.0f) {
            ((Box)horizontalBox3).add(new StrutBox(-f6, 0.0f, 0.0f, 0.0f));
        }
        ((Box)horizontalBox3).add(box3);
        ((Box)horizontalBox3).add(box4);
        ((Box)horizontalBox3).add(horizontalBox2);
        return horizontalBox3;
    }
}

