/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.model;

import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.internal.tasks.options.Option;
import org.gradle.api.reporting.model.internal.ModelNodeRenderer;
import org.gradle.api.reporting.model.internal.TextModelReportRenderer;
import org.gradle.api.tasks.TaskAction;
import org.gradle.logging.StyledTextOutput;
import org.gradle.logging.StyledTextOutputFactory;
import org.gradle.model.internal.core.ModelNode;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.registry.ModelRegistry;

@Incubating
public class ModelReport
extends DefaultTask {
    private boolean showHidden;
    private Format format = Format.FULL;

    @Option(option="showHidden", description="Show hidden model elements.")
    public void setShowHidden(boolean showHidden) {
        this.showHidden = showHidden;
    }

    public boolean isShowHidden() {
        return this.showHidden;
    }

    @Option(option="format", description="Output format (full, short)")
    public void setFormat(String format) {
        this.format = Format.valueOf(format.toUpperCase());
    }

    public Format getFormat() {
        return this.format;
    }

    @Inject
    protected StyledTextOutputFactory getTextOutputFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ModelRegistry getModelRegistry() {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    public void report() {
        Project project = this.getProject();
        StyledTextOutput textOutput = this.getTextOutputFactory().create(ModelReport.class);
        ModelNodeRenderer renderer = new ModelNodeRenderer(this.isShowHidden(), this.getFormat());
        TextModelReportRenderer textModelReportRenderer = new TextModelReportRenderer(renderer);
        textModelReportRenderer.setOutput(textOutput);
        textModelReportRenderer.startProject(project);
        ModelRegistry modelRegistry = this.getModelRegistry();
        ModelNode rootNode = modelRegistry.realizeNode(ModelPath.ROOT);
        modelRegistry.bindAllReferences();
        textModelReportRenderer.render(rootNode);
        textModelReportRenderer.completeProject(project);
        textModelReportRenderer.complete();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Format {
        FULL,
        SHORT;

    }
}

