/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import java.io.Closeable;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.gradle.api.UncheckedIOException;
import org.gradle.internal.resource.transport.http.AlwaysRedirectRedirectStrategy;
import org.gradle.internal.resource.transport.http.HttpClientConfigurer;
import org.gradle.internal.resource.transport.http.HttpRequestException;
import org.gradle.internal.resource.transport.http.HttpSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientHelper
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientHelper.class);
    private CloseableHttpClient client;
    private final BasicHttpContext httpContext = new BasicHttpContext();
    private final HttpSettings settings;

    public HttpClientHelper(HttpSettings settings) {
        this.settings = settings;
    }

    public HttpResponse performRawHead(String source) {
        return this.performRequest((HttpRequestBase)new HttpHead(source));
    }

    public HttpResponse performHead(String source) {
        return this.processResponse(source, "HEAD", this.performRawHead(source));
    }

    public HttpResponse performRawGet(String source) {
        return this.performRequest((HttpRequestBase)new HttpGet(source));
    }

    public HttpResponse performGet(String source) {
        return this.processResponse(source, "GET", this.performRawGet(source));
    }

    public HttpResponse performRequest(HttpRequestBase request) {
        HttpResponse response;
        String method = request.getMethod();
        try {
            response = this.executeGetOrHead(request);
        }
        catch (IOException e) {
            throw new HttpRequestException(String.format("Could not %s '%s'.", method, request.getURI()), e);
        }
        return response;
    }

    protected HttpResponse executeGetOrHead(HttpRequestBase method) throws IOException {
        HttpResponse httpResponse = this.performHttpRequest(method);
        if (!this.wasSuccessful(httpResponse)) {
            EntityUtils.consume((HttpEntity)httpResponse.getEntity());
            return httpResponse;
        }
        return httpResponse;
    }

    public boolean wasMissing(HttpResponse response) {
        int statusCode = response.getStatusLine().getStatusCode();
        return statusCode == 404;
    }

    public boolean wasSuccessful(HttpResponse response) {
        int statusCode = response.getStatusLine().getStatusCode();
        return statusCode >= 200 && statusCode < 400;
    }

    public HttpResponse performHttpRequest(HttpRequestBase request) throws IOException {
        this.httpContext.removeAttribute("http.protocol.redirect-locations");
        LOGGER.debug("Performing HTTP {}: {}", (Object)request.getMethod(), (Object)request.getURI());
        return this.getClient().execute((HttpUriRequest)request, (HttpContext)this.httpContext);
    }

    private HttpResponse processResponse(String source, String method, HttpResponse response) {
        if (this.wasMissing(response)) {
            LOGGER.info("Resource missing. [HTTP {}: {}]", (Object)method, (Object)source);
            return null;
        }
        if (!this.wasSuccessful(response)) {
            LOGGER.info("Failed to get resource: {}. [HTTP {}: {}]", new Object[]{method, response.getStatusLine(), source});
            throw new UncheckedIOException(String.format("Could not %s '%s'. Received status code %s from server: %s", method, source, response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()));
        }
        return response;
    }

    private synchronized CloseableHttpClient getClient() {
        if (this.client == null) {
            HttpClientBuilder builder = HttpClientBuilder.create();
            builder.setRedirectStrategy((RedirectStrategy)new AlwaysRedirectRedirectStrategy());
            new HttpClientConfigurer(this.settings).configure(builder);
            this.client = builder.build();
        }
        return this.client;
    }

    public synchronized void close() throws IOException {
        if (this.client != null) {
            this.client.close();
        }
    }
}

