/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.publish.ArchivePublishArtifact;
import org.gradle.api.internal.component.BuildableJavaComponent;
import org.gradle.api.internal.component.ComponentRegistry;
import org.gradle.api.internal.java.JavaLibrary;
import org.gradle.api.internal.plugins.DefaultArtifactPublicationSet;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.api.tasks.testing.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaPlugin
implements Plugin<ProjectInternal> {
    public static final String PROCESS_RESOURCES_TASK_NAME = "processResources";
    public static final String CLASSES_TASK_NAME = "classes";
    public static final String COMPILE_JAVA_TASK_NAME = "compileJava";
    public static final String PROCESS_TEST_RESOURCES_TASK_NAME = "processTestResources";
    public static final String TEST_CLASSES_TASK_NAME = "testClasses";
    public static final String COMPILE_TEST_JAVA_TASK_NAME = "compileTestJava";
    public static final String TEST_TASK_NAME = "test";
    public static final String JAR_TASK_NAME = "jar";
    public static final String JAVADOC_TASK_NAME = "javadoc";
    public static final String COMPILE_CONFIGURATION_NAME = "compile";
    public static final String COMPILE_ONLY_CONFIGURATION_NAME = "compileOnly";
    public static final String RUNTIME_CONFIGURATION_NAME = "runtime";
    public static final String COMPILE_CLASSPATH_CONFIGURATION_NAME = "compileClasspath";
    public static final String TEST_COMPILE_CONFIGURATION_NAME = "testCompile";
    public static final String TEST_COMPILE_ONLY_CONFIGURATION_NAME = "testCompileOnly";
    public static final String TEST_RUNTIME_CONFIGURATION_NAME = "testRuntime";
    public static final String TEST_COMPILE_CLASSPATH_CONFIGURATION_NAME = "testCompileClasspath";

    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(JavaBasePlugin.class);
        JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
        ((ComponentRegistry)project.getServices().get(ComponentRegistry.class)).setMainComponent((BuildableJavaComponent)new BuildableJavaComponentImpl(javaConvention));
        this.configureSourceSets(javaConvention);
        this.configureConfigurations((Project)project);
        this.configureJavaDoc(javaConvention);
        this.configureTest((Project)project, javaConvention);
        this.configureArchivesAndComponent((Project)project, javaConvention);
        this.configureBuild((Project)project);
    }

    private void configureSourceSets(JavaPluginConvention pluginConvention) {
        ProjectInternal project = pluginConvention.getProject();
        SourceSet main = (SourceSet)pluginConvention.getSourceSets().create("main");
        SourceSet test = (SourceSet)pluginConvention.getSourceSets().create(TEST_TASK_NAME);
        test.setCompileClasspath((FileCollection)project.files(new Object[]{main.getOutput(), project.getConfigurations().getByName(TEST_COMPILE_CLASSPATH_CONFIGURATION_NAME)}));
        test.setRuntimeClasspath((FileCollection)project.files(new Object[]{test.getOutput(), main.getOutput(), project.getConfigurations().getByName(TEST_RUNTIME_CONFIGURATION_NAME)}));
    }

    private void configureJavaDoc(JavaPluginConvention pluginConvention) {
        ProjectInternal project = pluginConvention.getProject();
        SourceSet mainSourceSet = (SourceSet)pluginConvention.getSourceSets().getByName("main");
        Javadoc javadoc = (Javadoc)project.getTasks().create(JAVADOC_TASK_NAME, Javadoc.class);
        javadoc.setDescription("Generates Javadoc API documentation for the main source code.");
        javadoc.setGroup("documentation");
        javadoc.setClasspath(mainSourceSet.getOutput().plus(mainSourceSet.getCompileClasspath()));
        javadoc.setSource((Object)mainSourceSet.getAllJava());
        this.addDependsOnTaskInOtherProjects((Task)javadoc, true, JAVADOC_TASK_NAME, COMPILE_CONFIGURATION_NAME);
    }

    private void configureArchivesAndComponent(Project project, JavaPluginConvention pluginConvention) {
        Jar jar = (Jar)project.getTasks().create(JAR_TASK_NAME, Jar.class);
        jar.setDescription("Assembles a jar archive containing the main classes.");
        jar.setGroup("build");
        jar.from(new Object[]{((SourceSet)pluginConvention.getSourceSets().getByName("main")).getOutput()});
        ArchivePublishArtifact jarArtifact = new ArchivePublishArtifact((AbstractArchiveTask)jar);
        Configuration runtimeConfiguration = project.getConfigurations().getByName(RUNTIME_CONFIGURATION_NAME);
        runtimeConfiguration.getArtifacts().add((Object)jarArtifact);
        ((DefaultArtifactPublicationSet)project.getExtensions().getByType(DefaultArtifactPublicationSet.class)).addCandidate((PublishArtifact)jarArtifact);
        project.getComponents().add((Object)new JavaLibrary((PublishArtifact)jarArtifact, runtimeConfiguration.getAllDependencies()));
    }

    private void configureBuild(Project project) {
        this.addDependsOnTaskInOtherProjects(project.getTasks().getByName("buildNeeded"), true, "buildNeeded", TEST_RUNTIME_CONFIGURATION_NAME);
        this.addDependsOnTaskInOtherProjects(project.getTasks().getByName("buildDependents"), false, "buildDependents", TEST_RUNTIME_CONFIGURATION_NAME);
    }

    private void configureTest(Project project, final JavaPluginConvention pluginConvention) {
        project.getTasks().withType(Test.class, (Action)new Action<Test>(){

            public void execute(Test test) {
                test.getConventionMapping().map("testClassesDir", (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return ((SourceSet)pluginConvention.getSourceSets().getByName(JavaPlugin.TEST_TASK_NAME)).getOutput().getClassesDir();
                    }
                });
                test.getConventionMapping().map("classpath", (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return ((SourceSet)pluginConvention.getSourceSets().getByName(JavaPlugin.TEST_TASK_NAME)).getRuntimeClasspath();
                    }
                });
                test.getConventionMapping().map("testSrcDirs", (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return new ArrayList(((SourceSet)pluginConvention.getSourceSets().getByName(JavaPlugin.TEST_TASK_NAME)).getJava().getSrcDirs());
                    }
                });
            }
        });
        Test test = (Test)project.getTasks().create(TEST_TASK_NAME, Test.class);
        project.getTasks().getByName("check").dependsOn(new Object[]{test});
        test.setDescription("Runs the unit tests.");
        test.setGroup("verification");
    }

    void configureConfigurations(Project project) {
        ConfigurationContainer configurations = project.getConfigurations();
        Configuration compileConfiguration = configurations.getByName(COMPILE_CONFIGURATION_NAME);
        Configuration runtimeConfiguration = configurations.getByName(RUNTIME_CONFIGURATION_NAME);
        Configuration compileTestsConfiguration = configurations.getByName(TEST_COMPILE_CONFIGURATION_NAME);
        compileTestsConfiguration.extendsFrom(new Configuration[]{compileConfiguration});
        configurations.getByName(TEST_RUNTIME_CONFIGURATION_NAME).extendsFrom(new Configuration[]{runtimeConfiguration, compileTestsConfiguration});
        configurations.getByName("default").extendsFrom(new Configuration[]{runtimeConfiguration});
    }

    private void addDependsOnTaskInOtherProjects(Task task, boolean useDependedOn, String otherProjectTaskName, String configurationName) {
        Project project = task.getProject();
        Configuration configuration = project.getConfigurations().getByName(configurationName);
        task.dependsOn(new Object[]{configuration.getTaskDependencyFromProjectDependency(useDependedOn, otherProjectTaskName)});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BuildableJavaComponentImpl
    implements BuildableJavaComponent {
        private final JavaPluginConvention convention;

        public BuildableJavaComponentImpl(JavaPluginConvention convention) {
            this.convention = convention;
        }

        public Collection<String> getRebuildTasks() {
            return Arrays.asList("clean", "build");
        }

        public Collection<String> getBuildTasks() {
            return Arrays.asList("build");
        }

        public FileCollection getRuntimeClasspath() {
            FileCollection runtimeClasspath = ((SourceSet)this.convention.getSourceSets().getByName("main")).getRuntimeClasspath();
            ProjectInternal project = this.convention.getProject();
            Configuration gradleApi = project.getConfigurations().detachedConfiguration(new Dependency[]{project.getDependencies().gradleApi(), project.getDependencies().localGroovy()});
            return runtimeClasspath.minus((FileCollection)gradleApi);
        }

        public Configuration getCompileDependencies() {
            return this.convention.getProject().getConfigurations().getByName(JavaPlugin.COMPILE_CONFIGURATION_NAME);
        }
    }
}

