/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testkit.jarjar.org.gradle.internal.concurrent;

import java.util.concurrent.atomic.AtomicReference;
import org.gradle.testkit.jarjar.org.gradle.internal.UncheckedException;
import org.gradle.testkit.jarjar.org.gradle.internal.concurrent.DefaultExecutorFactory;
import org.gradle.testkit.jarjar.org.slf4j.Logger;
import org.gradle.testkit.jarjar.org.slf4j.LoggerFactory;

interface ExecutorPolicy {
    public void onExecute(Runnable var1);

    public void onStop();

    public static class PropagateFailures
    implements ExecutorPolicy {
        public void onExecute(Runnable command) {
            command.run();
        }

        public void onStop() {
        }
    }

    public static class CatchAndRecordFailures
    implements ExecutorPolicy {
        private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExecutorFactory.class);
        private final AtomicReference<Throwable> failure = new AtomicReference();

        public void onExecute(Runnable command) {
            block2: {
                try {
                    command.run();
                }
                catch (Throwable throwable) {
                    if (this.failure.compareAndSet(null, throwable)) break block2;
                    LOGGER.error(String.format("Failed to execute %s.", command), throwable);
                }
            }
        }

        public void onStop() {
            if (this.failure.get() != null) {
                throw UncheckedException.throwAsUncheckedException(this.failure.get());
            }
        }
    }
}

