/*
 * Decompiled with CFR 0.152.
 */
package org.grails.cli.profile.git;

import grails.build.logging.GrailsConsole;
import grails.util.BuildSettings;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ResetCommand;
import org.grails.cli.profile.Profile;
import org.grails.cli.profile.ProfileRepository;
import org.grails.cli.profile.ResourceProfile;
import org.grails.io.support.FileSystemResource;
import org.grails.io.support.Resource;

@Deprecated
public class GitProfileRepository
implements ProfileRepository,
GroovyObject {
    private File profilesDirectory;
    private String originUri;
    private String gitBranch;
    private String gitRevision;
    private ResetCommand.ResetType gitRevisionResetMode;
    private boolean initialized;
    private long updateInterval;
    private Map<String, Profile> profileCache;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final /* synthetic */ long $const$0;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public GitProfileRepository() {
        MetaClass metaClass;
        Map map;
        boolean bl;
        ResetCommand.ResetType resetType;
        String string;
        String string2;
        File file;
        this.profilesDirectory = file = new File(new File(System.getProperty("user.home")), ".grails/repository");
        this.originUri = string2 = "https://github.com/grails/grails-profile-repository";
        this.gitBranch = string = "master";
        this.gitRevisionResetMode = resetType = ResetCommand.ResetType.HARD;
        this.initialized = bl = false;
        long l = (long)10 * $const$0;
        this.updateInterval = l;
        this.profileCache = map = DefaultGroovyMethods.asSynchronized((Map)ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Override
    public Resource getProfileDirectory(String profile) {
        File profileDirectory = new File(new File(this.profilesDirectory, "profiles"), ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{profile}, new String[]{"", ""})));
        String path = profileDirectory.getCanonicalPath();
        return new FileSystemResource(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{path}, new String[]{"", "/"})));
    }

    @Override
    public Profile getProfile(String profileName) {
        Profile profileInstance = (Profile)ScriptBytecodeAdapter.castToType((Object)this.profileCache.get(profileName), Profile.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)profileInstance)) {
            return profileInstance;
        }
        if (!this.initialized) {
            boolean bl;
            this.createOrUpdateRepository();
            this.initialized = bl = true;
        }
        Resource profileDirectory = this.getProfileDirectory(profileName);
        if (profileDirectory.exists()) {
            Profile profile;
            profileInstance = profile = ResourceProfile.create(this, profileName, profileDirectory);
            this.profileCache.put(profileName, profileInstance);
            return profileInstance;
        }
        return (Profile)ScriptBytecodeAdapter.castToType(null, Profile.class);
    }

    @Override
    public List<Profile> getAllProfiles() {
        File[] fileArray = new File(this.profilesDirectory, "profiles").listFiles();
        public class _getAllProfiles_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getAllProfiles_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(File f) {
                return f.isDirectory() && !f.isHidden() && !f.getName().startsWith(".");
            }

            public Object call(File f) {
                return this.doCall(f);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getAllProfiles_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Collection allDirectories = fileArray != null ? DefaultGroovyMethods.findAll((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)fileArray, Object[].class)), (Closure)new _getAllProfiles_closure1(this, this)) : null;
        public class _getAllProfiles_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getAllProfiles_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(File f) {
                return ((GitProfileRepository)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), GitProfileRepository.class)).getProfile(f.getName());
            }

            public Object call(File f) {
                return this.doCall(f);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getAllProfiles_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultGroovyMethods.collect((Collection)allDirectories, (Closure)new _getAllProfiles_closure2(this, this));
    }

    @Override
    public List<Profile> getProfileAndDependencies(Profile profile) {
        List sortedProfiles = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        Set visitedProfiles = (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class);
        this.visitTopologicalSort(profile, sortedProfiles, visitedProfiles);
        return sortedProfiles;
    }

    /*
     * WARNING - void declaration
     */
    private void visitTopologicalSort(Profile profile, List<Profile> sortedProfiles, Set<Profile> visitedProfiles) {
        void var3_3;
        Reference sortedProfiles2 = new Reference(sortedProfiles);
        Reference visitedProfiles2 = new Reference((Object)var3_3);
        if (profile != null && !((Set)visitedProfiles2.get()).contains(profile)) {
            ((Set)visitedProfiles2.get()).add(profile);
            public class _visitTopologicalSort_closure3
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference sortedProfiles;
                private /* synthetic */ Reference visitedProfiles;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _visitTopologicalSort_closure3(Object _outerInstance, Object _thisObject, Reference sortedProfiles, Reference visitedProfiles) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    this.sortedProfiles = reference2 = sortedProfiles;
                    this.visitedProfiles = reference = visitedProfiles;
                }

                public Object doCall(Profile dependentProfile) {
                    ((GitProfileRepository)this.getThisObject()).visitTopologicalSort(dependentProfile, (List)ScriptBytecodeAdapter.castToType((Object)this.sortedProfiles.get(), List.class), (Set)ScriptBytecodeAdapter.castToType((Object)this.visitedProfiles.get(), Set.class));
                    return null;
                }

                public Object call(Profile dependentProfile) {
                    return this.doCall(dependentProfile);
                }

                public List getSortedProfiles() {
                    return (List)ScriptBytecodeAdapter.castToType((Object)this.sortedProfiles.get(), List.class);
                }

                public Set getVisitedProfiles() {
                    return (Set)ScriptBytecodeAdapter.castToType((Object)this.visitedProfiles.get(), Set.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _visitTopologicalSort_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            DefaultGroovyMethods.each(profile.getExtends(), (Closure)new _visitTopologicalSort_closure3(this, this, sortedProfiles2, visitedProfiles2));
            ((List)sortedProfiles2.get()).add(profile);
        }
    }

    public File createOrUpdateRepository() {
        if (!this.profilesDirectory.exists()) {
            File parentDir = this.profilesDirectory.getParentFile();
            if (!parentDir.exists()) {
                parentDir.mkdir();
            }
            Git.cloneRepository().setURI(this.originUri).setDirectory(this.profilesDirectory).setBranch(this.gitBranch).call();
        } else {
            boolean hasGitRevision = DefaultTypeTransformation.booleanUnbox((Object)this.gitRevision);
            this.fetchAndRebaseIfExpired(hasGitRevision);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.gitRevision)) {
            Git git = Git.open((File)this.profilesDirectory);
            git.reset().setRef(this.gitRevision).setMode(this.gitRevisionResetMode).call();
        } else {
            this.checkoutTagForRelease();
        }
        return this.profilesDirectory;
    }

    public void checkoutTagForRelease() {
        String grailsVersion = BuildSettings.class.getPackage().getImplementationVersion();
        if (grailsVersion != null && !grailsVersion.endsWith("-SNAPSHOT")) {
            try {
                Git git = Git.open((File)this.profilesDirectory);
                git.checkout().setName(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{grailsVersion}, new String[]{"v", ""}))).call();
            }
            catch (Throwable e) {
                GrailsConsole.getInstance().error(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{grailsVersion}, new String[]{"Could not checkout tag for Grails release [", "]: "}).plus(e.getMessage())), e);
            }
        }
    }

    public void fetchAndRebaseIfExpired(boolean forceUpdate) {
        File fetchHead = new File(this.profilesDirectory, ".git/FETCH_HEAD");
        if (forceUpdate || !fetchHead.exists() || fetchHead.lastModified() < System.currentTimeMillis() - this.updateInterval) {
            try {
                Git git = Git.open((File)this.profilesDirectory);
                git.fetch().call();
            }
            catch (Exception e) {
                GrailsConsole.getInstance().error("Problem updating profiles from origin git repository", (Throwable)e);
            }
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != GitProfileRepository.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public void fetchAndRebaseIfExpired() {
        this.fetchAndRebaseIfExpired(false);
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public static /* synthetic */ void __$swapInit() {
        long l;
        $const$0 = l = 60000L;
    }

    static {
        GitProfileRepository.__$swapInit();
    }

    public File getProfilesDirectory() {
        return this.profilesDirectory;
    }

    public void setProfilesDirectory(File file) {
        this.profilesDirectory = file;
    }

    public String getOriginUri() {
        return this.originUri;
    }

    public void setOriginUri(String string) {
        this.originUri = string;
    }

    public String getGitBranch() {
        return this.gitBranch;
    }

    public void setGitBranch(String string) {
        this.gitBranch = string;
    }

    public String getGitRevision() {
        return this.gitRevision;
    }

    public void setGitRevision(String string) {
        this.gitRevision = string;
    }

    public ResetCommand.ResetType getGitRevisionResetMode() {
        return this.gitRevisionResetMode;
    }

    public void setGitRevisionResetMode(ResetCommand.ResetType resetType) {
        this.gitRevisionResetMode = resetType;
    }

    public boolean getInitialized() {
        return this.initialized;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean bl) {
        this.initialized = bl;
    }

    public long getUpdateInterval() {
        return this.updateInterval;
    }

    public void setUpdateInterval(long l) {
        this.updateInterval = l;
    }

    public Map<String, Profile> getProfileCache() {
        return this.profileCache;
    }

    public void setProfileCache(Map<String, Profile> map) {
        this.profileCache = map;
    }
}

