/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.servlet.mvc;

import grails.core.GrailsApplication;
import grails.core.GrailsControllerClass;
import grails.util.Holders;
import grails.validation.DeferredBindingActions;
import grails.web.mvc.FlashScope;
import grails.web.servlet.mvc.GrailsHttpSession;
import grails.web.servlet.mvc.GrailsParameterMap;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.grails.core.io.support.GrailsFactoriesLoader;
import org.grails.encoder.CodecLookupHelper;
import org.grails.encoder.DefaultEncodingStateRegistry;
import org.grails.encoder.Encoder;
import org.grails.encoder.EncodingStateRegistry;
import org.grails.encoder.EncodingStateRegistryLookup;
import org.grails.encoder.EncodingStateRegistryLookupHolder;
import org.grails.web.beans.PropertyEditorRegistryUtils;
import org.grails.web.pages.FilteringCodecsByContentTypeSettings;
import org.grails.web.servlet.mvc.ParameterCreationListener;
import org.grails.web.servlet.mvc.exceptions.ControllerExecutionException;
import org.grails.web.util.GrailsApplicationAttributes;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.PropertyEditorRegistrySupport;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.servlet.handler.DispatcherServletWebRequest;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.util.UrlPathHelper;

public class GrailsWebRequest
extends DispatcherServletWebRequest {
    private static final String REDIRECT_CALLED = "org.grails.REDIRECT_ISSUED";
    private static final Class<? extends GrailsApplicationAttributes> grailsApplicationAttributesClass = (Class)GrailsFactoriesLoader.loadFactoryClasses(GrailsApplicationAttributes.class, (ClassLoader)GrailsWebRequest.class.getClassLoader()).get(0);
    private static final Constructor<? extends GrailsApplicationAttributes> grailsApplicationAttributesConstructor = ClassUtils.getConstructorIfAvailable(grailsApplicationAttributesClass, (Class[])new Class[]{ServletContext.class});
    private GrailsApplicationAttributes attributes;
    private GrailsParameterMap params;
    private GrailsParameterMap originalParams;
    private GrailsHttpSession session;
    private boolean renderView = true;
    private boolean skipFilteringCodec = false;
    private Encoder filteringEncoder;
    public static final String ID_PARAMETER = "id";
    private final List<ParameterCreationListener> parameterCreationListeners = new ArrayList<ParameterCreationListener>();
    private final UrlPathHelper urlHelper = new UrlPathHelper();
    private ApplicationContext applicationContext;
    private String baseUrl;
    private HttpServletResponse wrappedResponse;
    private EncodingStateRegistry encodingStateRegistry;
    private HttpServletRequest multipartRequest;

    public GrailsWebRequest(HttpServletRequest request, HttpServletResponse response, GrailsApplicationAttributes attributes) {
        super(request, response);
        this.attributes = attributes;
        this.applicationContext = attributes.getApplicationContext();
        this.inheritEncodingStateRegistry();
    }

    public GrailsWebRequest(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        super(request, response);
        try {
            this.attributes = grailsApplicationAttributesConstructor.newInstance(servletContext);
            this.applicationContext = this.attributes.getApplicationContext();
        }
        catch (Exception e) {
            ReflectionUtils.rethrowRuntimeException((Throwable)e);
        }
        this.inheritEncodingStateRegistry();
    }

    public GrailsWebRequest(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, ApplicationContext applicationContext) {
        this(request, response, servletContext);
        this.applicationContext = applicationContext;
    }

    public void setMultipartRequest(HttpServletRequest multipartRequest) {
        this.multipartRequest = multipartRequest;
    }

    private void inheritEncodingStateRegistry() {
        GrailsWebRequest parentRequest = GrailsWebRequest.lookup(this.getRequest());
        if (parentRequest != null) {
            this.encodingStateRegistry = parentRequest.getEncodingStateRegistry();
        }
    }

    public Map getParameterMap() {
        if (this.params == null) {
            this.resetParams();
        }
        return this.params;
    }

    public void requestCompleted() {
        super.requestCompleted();
        DeferredBindingActions.clear();
    }

    public Writer getOut() {
        Writer out = this.attributes.getOut(this.getCurrentRequest());
        if (out == null) {
            try {
                return this.getCurrentResponse().getWriter();
            }
            catch (IOException e) {
                throw new ControllerExecutionException("Error retrieving response writer: " + e.getMessage(), e);
            }
        }
        return out;
    }

    public boolean isActive() {
        return super.isRequestActive();
    }

    public void setOut(Writer out) {
        this.attributes.setOut(this.getCurrentRequest(), out);
    }

    public ServletContext getServletContext() {
        return this.attributes.getServletContext();
    }

    public String getContextPath() {
        HttpServletRequest request = this.getCurrentRequest();
        String appUri = (String)request.getAttribute("org.grails.APP_URI_ATTRIBUTE");
        if (appUri == null) {
            appUri = this.urlHelper.getContextPath(request);
        }
        return appUri;
    }

    public FlashScope getFlashScope() {
        return this.attributes.getFlashScope((ServletRequest)this.getRequest());
    }

    public HttpServletRequest getCurrentRequest() {
        if (this.multipartRequest != null) {
            return this.multipartRequest;
        }
        return this.getRequest();
    }

    public HttpServletResponse getCurrentResponse() {
        if (this.wrappedResponse != null) {
            return this.wrappedResponse;
        }
        return this.getResponse();
    }

    public HttpServletResponse getWrappedResponse() {
        return this.wrappedResponse;
    }

    public void setWrappedResponse(HttpServletResponse wrappedResponse) {
        this.wrappedResponse = wrappedResponse;
    }

    public GrailsParameterMap getParams() {
        if (this.params == null) {
            this.resetParams();
        }
        return this.params;
    }

    public void resetParams() {
        if (this.originalParams == null) {
            this.originalParams = new GrailsParameterMap(this.getCurrentRequest());
        }
        this.params = (GrailsParameterMap)this.originalParams.clone();
    }

    public void addParametersFrom(Map previousParams) {
        if (previousParams instanceof GrailsParameterMap) {
            this.getParams().addParametersFrom((GrailsParameterMap)((Object)previousParams));
        } else {
            for (Object key : previousParams.keySet()) {
                String name = String.valueOf(key);
                this.getParams().put(name, previousParams.get(key));
            }
        }
    }

    public void informParameterCreationListeners() {
        for (ParameterCreationListener parameterCreationListener : this.parameterCreationListeners) {
            parameterCreationListener.paramsCreated(this.getParams());
        }
    }

    public GrailsHttpSession getSession() {
        if (this.session == null) {
            this.session = new GrailsHttpSession(this.getCurrentRequest());
        }
        return this.session;
    }

    public GrailsApplicationAttributes getAttributes() {
        return this.attributes;
    }

    public void setActionName(String actionName) {
        this.getCurrentRequest().setAttribute("org.grails.ACTION_NAME_ATTRIBUTE", (Object)actionName);
    }

    public void setControllerName(String controllerName) {
        this.getCurrentRequest().setAttribute("org.grails.CONTROLLER_NAME_ATTRIBUTE", (Object)controllerName);
    }

    public void setControllerNamespace(String controllerNamespace) {
        this.getCurrentRequest().setAttribute("org.grails.CONTROLLER_NAMESPACE_ATTRIBUTE", (Object)controllerNamespace);
    }

    public String getActionName() {
        return (String)this.getCurrentRequest().getAttribute("org.grails.ACTION_NAME_ATTRIBUTE");
    }

    public String getControllerName() {
        return (String)this.getCurrentRequest().getAttribute("org.grails.CONTROLLER_NAME_ATTRIBUTE");
    }

    public GrailsControllerClass getControllerClass() {
        Object controllerNameObject;
        HttpServletRequest currentRequest = this.getCurrentRequest();
        GrailsControllerClass controllerClass = (GrailsControllerClass)currentRequest.getAttribute("org.grails.GRAILS_CONTROLLER_CLASS");
        if (controllerClass == null && (controllerNameObject = currentRequest.getAttribute("org.grails.CONTROLLER_NAME_ATTRIBUTE")) != null && (controllerClass = (GrailsControllerClass)this.getAttributes().getGrailsApplication().getArtefactByLogicalPropertyName("Controller", controllerNameObject.toString())) != null) {
            currentRequest.setAttribute("org.grails.GRAILS_CONTROLLER_CLASS", (Object)controllerClass);
        }
        return controllerClass;
    }

    public String getControllerNamespace() {
        return (String)this.getCurrentRequest().getAttribute("org.grails.CONTROLLER_NAMESPACE_ATTRIBUTE");
    }

    public void setRenderView(boolean renderView) {
        this.renderView = renderView;
    }

    public boolean isRenderView() {
        HttpServletRequest currentRequest = this.getCurrentRequest();
        return this.renderView && !this.getCurrentResponse().isCommitted() && currentRequest.getAttribute(REDIRECT_CALLED) == null;
    }

    public String getId() {
        Object id = this.getParams().get(ID_PARAMETER);
        return id == null ? null : id.toString();
    }

    public boolean isFlowRequest() {
        GrailsApplication application = this.getAttributes().getGrailsApplication();
        GrailsControllerClass controllerClassObject = this.getControllerClass();
        GrailsControllerClass controllerClass = null;
        if (controllerClassObject instanceof GrailsControllerClass) {
            controllerClass = controllerClassObject;
        }
        if (controllerClass == null) {
            return false;
        }
        String actionName = this.getActionName();
        if (actionName == null) {
            actionName = controllerClass.getDefaultAction();
        }
        if (actionName == null) {
            return false;
        }
        return false;
    }

    public void addParameterListener(ParameterCreationListener creationListener) {
        this.parameterCreationListeners.add(creationListener);
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext == null ? this.getAttributes().getApplicationContext() : this.applicationContext;
    }

    public PropertyEditorRegistry getPropertyEditorRegistry() {
        HttpServletRequest servletRequest = this.getCurrentRequest();
        PropertyEditorRegistry registry = (PropertyEditorRegistry)servletRequest.getAttribute("org.grails.PROPERTY_REGISTRY");
        if (registry == null) {
            registry = new PropertyEditorRegistrySupport();
            PropertyEditorRegistryUtils.registerCustomEditors(this, registry, RequestContextUtils.getLocale((HttpServletRequest)servletRequest));
            servletRequest.setAttribute("org.grails.PROPERTY_REGISTRY", (Object)registry);
        }
        return registry;
    }

    public static GrailsWebRequest lookup(HttpServletRequest request) {
        GrailsWebRequest webRequest = (GrailsWebRequest)((Object)request.getAttribute("org.grails.WEB_REQUEST"));
        return webRequest == null ? GrailsWebRequest.lookup() : webRequest;
    }

    public static GrailsWebRequest lookup() {
        GrailsWebRequest webRequest = null;
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes instanceof GrailsWebRequest) {
            webRequest = (GrailsWebRequest)requestAttributes;
        }
        return webRequest;
    }

    @Deprecated
    public static GrailsApplication lookupApplication() {
        return Holders.findApplication();
    }

    public void setId(Object id) {
        this.getParams().put(ID_PARAMETER, id);
    }

    public String getBaseUrl() {
        if (this.baseUrl == null) {
            String contextPath;
            HttpServletRequest request = this.getCurrentRequest();
            String scheme = request.getScheme();
            StringBuilder sb = new StringBuilder();
            sb.append(scheme).append("://").append(request.getServerName());
            int port = request.getServerPort();
            if ("http".equals(scheme) && port != 80 || "https".equals(scheme) && port != 443) {
                sb.append(":").append(port);
            }
            if ((contextPath = request.getContextPath()) != null) {
                sb.append(contextPath);
            }
            this.baseUrl = sb.toString();
        }
        return this.baseUrl;
    }

    public EncodingStateRegistry getEncodingStateRegistry() {
        if (this.encodingStateRegistry == null) {
            this.encodingStateRegistry = new DefaultEncodingStateRegistry();
        }
        return this.encodingStateRegistry;
    }

    public boolean isSkipFilteringCodec() {
        return this.skipFilteringCodec;
    }

    public void setSkipFilteringCodec(boolean skipCodec) {
        this.skipFilteringCodec = skipCodec;
    }

    public String getFilteringCodec() {
        return this.filteringEncoder != null ? this.filteringEncoder.getCodecIdentifier().getCodecName() : null;
    }

    public void setFilteringCodec(String codecName) {
        this.filteringEncoder = codecName != null ? CodecLookupHelper.lookupEncoder((GrailsApplication)this.attributes.getGrailsApplication(), (String)codecName) : null;
    }

    public Encoder lookupFilteringEncoder() {
        if (this.filteringEncoder == null && this.applicationContext != null && this.applicationContext.containsBean("filteringCodecsByContentTypeSettings")) {
            this.filteringEncoder = ((FilteringCodecsByContentTypeSettings)this.applicationContext.getBean("filteringCodecsByContentTypeSettings", FilteringCodecsByContentTypeSettings.class)).getEncoderForContentType(this.getResponse().getContentType());
        }
        return this.filteringEncoder;
    }

    public Encoder getFilteringEncoder() {
        return this.filteringEncoder;
    }

    public void setFilteringEncoder(Encoder filteringEncoder) {
        this.filteringEncoder = filteringEncoder;
    }

    static {
        EncodingStateRegistryLookupHolder.setEncodingStateRegistryLookup((EncodingStateRegistryLookup)new DefaultEncodingStateRegistryLookup());
    }

    private static final class DefaultEncodingStateRegistryLookup
    implements EncodingStateRegistryLookup {
        private DefaultEncodingStateRegistryLookup() {
        }

        public EncodingStateRegistry lookup() {
            GrailsWebRequest webRequest = GrailsWebRequest.lookup();
            return webRequest == null ? null : webRequest.getEncodingStateRegistry();
        }
    }
}

