#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: esqueleto
version: 2.4.3
id: esqueleto-2.4.3-d3f7fac89495c2a2de6f99ff3c145caa
key: esque_J4UKviL5vns2XKFt7M40ps
license: BSD3
copyright: (c) 2012-2015 Felipe Almeida Lessa
maintainer: felipe.lessa@gmail.com
homepage: https://github.com/prowdsponsor/esqueleto
synopsis: Type-safe EDSL for SQL queries on persistent backends.
description:
    @esqueleto@ is a bare bones, type-safe EDSL for SQL queries
    that works with unmodified @persistent@ SQL backends.  Its
    language closely resembles SQL, so you don'\''t have to learn
    new concepts, just new syntax, and it'\''s fairly easy to
    predict the generated SQL and optimize it for your backend.
    Most kinds of errors committed when writing SQL are caught as
    compile-time errors---although it is possible to write
    type-checked @esqueleto@ queries that fail at runtime.
    .
    @persistent@ is a library for type-safe data serialization.  It
    has many kinds of backends, such as SQL backends
    (@persistent-mysql@, @persistent-postgresql@,
    @persistent-sqlite@) and NoSQL backends (@persistent-mongoDB@).
    While @persistent@ is a nice library for storing and retrieving
    records, including with filters, it does not try to support
    some of the features that are specific to SQL backends.  In
    particular, @esqueleto@ is the recommended library for
    type-safe @JOIN@s on @persistent@ SQL backends.  (The
    alternative is using raw SQL, but that'\''s error prone and does
    not offer any composability.)
    .
    Currently, @SELECT@s, @UPDATE@s, @INSERT@s and @DELETE@s are supported.
    Not all SQL features are available, but most of them can be easily added
    (especially functions), so please open an issue or send a pull request if
    you need anything that is not covered by @esqueleto@ on
    <https://github.com/prowdsponsor/esqueleto/>.
    .
    The name of this library means \"skeleton\" in Portuguese and
    contains all three SQL letters in the correct order =).  It was
    inspired by Scala'\''s Squeryl but created from scratch.
category: Database
author: Felipe Lessa
exposed: True
exposed-modules:
    Database.Esqueleto Database.Esqueleto.PostgreSQL
    Database.Esqueleto.Internal.Language
    Database.Esqueleto.Internal.Sql
hidden-modules: Database.Esqueleto.Internal.PersistentImport
trusted: False
import-dirs: /usr/lib/ghc-7.10.3/site-local/esqueleto-2.4.3
library-dirs: /usr/lib/ghc-7.10.3/site-local/esqueleto-2.4.3
data-dir: /usr/share/arm-linux-ghc-7.10.3/esqueleto-2.4.3
hs-libraries: HSesqueleto-2.4.3-J4UKviL5vns2XKFt7M40ps
depends:
    base-4.8.2.0-2f1f71a7fcf013cd47fd21f489064f9a
    blaze-html-0.8.1.1-1d54daeba5477a1aa0462b832a558865
    bytestring-0.10.6.0-3b51e35daa3fe2a56ecd3687fb389cdc
    conduit-1.2.6.4-0dfd87f475e845002478c37d3a30df1e
    monad-logger-0.3.18-e41795701bd26d2e948311dc59f0bce2
    persistent-2.2.4.1-515160ea71a89b76b70a56c63b058aa3
    resourcet-1.1.7.3-3e7ca03abacc332d28328c69bbd74cd4
    tagged-0.8.3-aa128de4449752177a05765fb0ce3959
    text-1.2.2.1-18afbfeccf88d72c4b6e468c86d2b77d
    transformers-0.4.2.0-252429dba576bc247c1932da496e0a3f
    unordered-containers-0.2.7.0-d91279dcd5fa13d7f88095dc08e2fda6
haddock-interfaces: /usr/share/doc/haskell-esqueleto/html/esqueleto.haddock
haddock-html: /usr/share/doc/haskell-esqueleto/html
' | '/usr/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
