#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: vector
version: 0.11.0.0
id: vector-0.11.0.0-711d35c4a6ac1ea2e529dc3ee3328963
key: vecto_LmZ3LQW4ivu8MsQuVgukln
license: BSD3
copyright: (c) Roman Leshchinskiy 2008-2012
maintainer: Haskell Libraries Team <libraries@haskell.org>
homepage: https://github.com/haskell/vector
synopsis: Efficient Arrays
description:
    .
    An efficient implementation of Int-indexed arrays (both mutable
    and immutable), with a powerful loop optimisation framework .
    .
    It is structured as follows:
    .
    ["Data.Vector"] Boxed vectors of arbitrary types.
    .
    ["Data.Vector.Unboxed"] Unboxed vectors with an adaptive
    representation based on data type families.
    .
    ["Data.Vector.Storable"] Unboxed vectors of '\''Storable'\'' types.
    .
    ["Data.Vector.Primitive"] Unboxed vectors of primitive types as
    defined by the @primitive@ package. "Data.Vector.Unboxed" is more
    flexible at no performance cost.
    .
    ["Data.Vector.Generic"] Generic interface to the vector types.
    .
    There is also a (draft) tutorial on common uses of vector.
    .
    * <http://haskell.org/haskellwiki/Numeric_Haskell:_A_Vector_Tutorial>
category: Data, Data Structures
author: Roman Leshchinskiy <rl@cse.unsw.edu.au>
exposed: True
exposed-modules:
    Data.Vector.Internal.Check Data.Vector.Fusion.Util
    Data.Vector.Fusion.Stream.Monadic Data.Vector.Fusion.Bundle.Size
    Data.Vector.Fusion.Bundle.Monadic Data.Vector.Fusion.Bundle
    Data.Vector.Generic.Mutable.Base Data.Vector.Generic.Mutable
    Data.Vector.Generic.Base Data.Vector.Generic.New
    Data.Vector.Generic Data.Vector.Primitive.Mutable
    Data.Vector.Primitive Data.Vector.Storable.Internal
    Data.Vector.Storable.Mutable Data.Vector.Storable
    Data.Vector.Unboxed.Base Data.Vector.Unboxed.Mutable
    Data.Vector.Unboxed Data.Vector.Mutable Data.Vector
trusted: False
import-dirs: /usr/lib/ghc-7.10.3/site-local/vector-0.11.0.0
library-dirs: /usr/lib/ghc-7.10.3/site-local/vector-0.11.0.0
data-dir: /usr/share/arm-linux-ghc-7.10.3/vector-0.11.0.0
hs-libraries: HSvector-0.11.0.0-LmZ3LQW4ivu8MsQuVgukln
include-dirs: /usr/lib/ghc-7.10.3/site-local/vector-0.11.0.0/include
depends:
    base-4.8.2.0-2f1f71a7fcf013cd47fd21f489064f9a
    deepseq-1.4.1.1-3975618f889b45239daa47b7443eaeee
    ghc-prim-0.4.0.0-bf246eb9fdda7435f0c147a313ce59fb
    primitive-0.6.1.0-013c88e6ffae491f11ac3b8c0552ce0e
haddock-interfaces: /usr/share/doc/haskell-vector/html/vector.haddock
haddock-html: /usr/share/doc/haskell-vector/html
' | '/usr/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
