/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui;

import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.GithubCreatePullRequestWorker;
import org.jetbrains.plugins.github.api.GithubFullPath;

public class GithubCreatePullRequestPanel {
    private JTextField myTitleTextField;
    private JTextArea myDescriptionTextArea;
    private ComboBox myBranchComboBox;
    private SortedComboBoxModel<GithubCreatePullRequestWorker.ForkInfo> myForkModel;
    private SortedComboBoxModel<GithubCreatePullRequestWorker.BranchInfo> myBranchModel;
    private JPanel myPanel;
    private JButton myShowDiffButton;
    private JButton mySelectForkButton;
    private JLabel myForkLabel;
    private ComboBox myForkComboBox;
    private boolean myTitleDescriptionUserModified = false;

    public GithubCreatePullRequestPanel() {
        this.$$$setupUI$$$();
        this.myDescriptionTextArea.setBorder(BorderFactory.createEtchedBorder());
        this.myBranchModel = new SortedComboBoxModel((Comparator)new Comparator<GithubCreatePullRequestWorker.BranchInfo>(){

            @Override
            public int compare(GithubCreatePullRequestWorker.BranchInfo o1, GithubCreatePullRequestWorker.BranchInfo o2) {
                return StringUtil.naturalCompare((String)o1.getRemoteName(), (String)o2.getRemoteName());
            }
        });
        this.myBranchComboBox.setModel(this.myBranchModel);
        this.myForkModel = new SortedComboBoxModel((Comparator)new Comparator<GithubCreatePullRequestWorker.ForkInfo>(){

            @Override
            public int compare(GithubCreatePullRequestWorker.ForkInfo o1, GithubCreatePullRequestWorker.ForkInfo o2) {
                return StringUtil.naturalCompare((String)o1.getPath().getUser(), (String)o2.getPath().getUser());
            }
        });
        this.myForkComboBox.setModel(this.myForkModel);
        DocumentAdapter userModifiedDocumentListener = new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                GithubCreatePullRequestPanel.this.myTitleDescriptionUserModified = true;
            }
        };
        this.myTitleTextField.getDocument().addDocumentListener((DocumentListener)userModifiedDocumentListener);
        this.myDescriptionTextArea.getDocument().addDocumentListener((DocumentListener)userModifiedDocumentListener);
    }

    @NotNull
    public String getTitle() {
        String string = this.myTitleTextField.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubCreatePullRequestPanel", "getTitle"));
        }
        return string;
    }

    @NotNull
    public String getDescription() {
        String string = this.myDescriptionTextArea.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubCreatePullRequestPanel", "getDescription"));
        }
        return string;
    }

    @Nullable
    public GithubCreatePullRequestWorker.ForkInfo getSelectedFork() {
        return (GithubCreatePullRequestWorker.ForkInfo)this.myForkModel.getSelectedItem();
    }

    @Nullable
    public GithubCreatePullRequestWorker.BranchInfo getSelectedBranch() {
        return (GithubCreatePullRequestWorker.BranchInfo)this.myBranchModel.getSelectedItem();
    }

    public void setSelectedFork(@Nullable GithubFullPath path) {
        if (path != null) {
            for (GithubCreatePullRequestWorker.ForkInfo info : this.myForkModel.getItems()) {
                if (!path.equals(info.getPath())) continue;
                this.myForkModel.setSelectedItem((Object)info);
                return;
            }
        }
        if (this.myForkModel.getSize() > 0) {
            this.myForkModel.setSelectedItem(this.myForkModel.get(0));
        }
    }

    public void setSelectedBranch(@Nullable String branch) {
        if (branch != null) {
            for (GithubCreatePullRequestWorker.BranchInfo info : this.myBranchModel.getItems()) {
                if (!branch.equals(info.getRemoteName())) continue;
                this.myBranchModel.setSelectedItem((Object)info);
                return;
            }
        }
        if (this.myBranchModel.getSize() > 0) {
            this.myBranchModel.setSelectedItem(this.myBranchModel.get(0));
        }
    }

    public void setForks(@NotNull Collection<GithubCreatePullRequestWorker.ForkInfo> forks) {
        if (forks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forks", "org/jetbrains/plugins/github/ui/GithubCreatePullRequestPanel", "setForks"));
        }
        this.myForkModel.setSelectedItem(null);
        this.myForkModel.setAll(forks);
    }

    public void setBranches(@NotNull Collection<GithubCreatePullRequestWorker.BranchInfo> branches) {
        if (branches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branches", "org/jetbrains/plugins/github/ui/GithubCreatePullRequestPanel", "setBranches"));
        }
        this.myBranchModel.setSelectedItem(null);
        this.myBranchModel.setAll(branches);
    }

    public void setTitle(@Nullable String title) {
        this.myTitleTextField.setText(title);
        this.myTitleDescriptionUserModified = false;
    }

    public void setDescription(@Nullable String title) {
        this.myDescriptionTextArea.setText(title);
        this.myTitleDescriptionUserModified = false;
    }

    public boolean isTitleDescriptionEmptyOrNotModified() {
        return !this.myTitleDescriptionUserModified || StringUtil.isEmptyOrSpaces((String)this.myTitleTextField.getText()) && StringUtil.isEmptyOrSpaces((String)this.myDescriptionTextArea.getText());
    }

    public void setDiffEnabled(boolean enabled) {
        this.myShowDiffButton.setEnabled(enabled);
    }

    @NotNull
    public JComponent getTitleTextField() {
        JTextField jTextField = this.myTitleTextField;
        if (jTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubCreatePullRequestPanel", "getTitleTextField"));
        }
        return jTextField;
    }

    @NotNull
    public JButton getSelectForkButton() {
        JButton jButton = this.mySelectForkButton;
        if (jButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubCreatePullRequestPanel", "getSelectForkButton"));
        }
        return jButton;
    }

    @NotNull
    public JButton getShowDiffButton() {
        JButton jButton = this.myShowDiffButton;
        if (jButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubCreatePullRequestPanel", "getShowDiffButton"));
        }
        return jButton;
    }

    @NotNull
    public ComboBox getForkComboBox() {
        ComboBox comboBox = this.myForkComboBox;
        if (comboBox == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubCreatePullRequestPanel", "getForkComboBox"));
        }
        return comboBox;
    }

    @NotNull
    public ComboBox getBranchComboBox() {
        ComboBox comboBox = this.myBranchComboBox;
        if (comboBox == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubCreatePullRequestPanel", "getBranchComboBox"));
        }
        return comboBox;
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    @NotNull
    public JComponent getPreferredComponent() {
        JTextField jTextField = this.myTitleTextField;
        if (jTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubCreatePullRequestPanel", "getPreferredComponent"));
        }
        return jTextField;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboBox comboBox;
        ComboBox comboBox2;
        JButton jButton;
        JButton jButton2;
        JTextArea jTextArea;
        JTextField jTextField;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Base branch:");
        jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Title:");
        jPanel.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Description:");
        jPanel.add((Component)jBLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTitleTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(2, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(4, 0, 1, 3, 0, 3, 7, 7, new Dimension(150, 50), null, null));
        jBScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        this.myDescriptionTextArea = jTextArea = new JTextArea();
        jBScrollPane.setViewportView(jTextArea);
        this.myShowDiffButton = jButton2 = new JButton();
        jButton2.setText("Show Diff");
        jPanel.add((Component)jButton2, new GridConstraints(1, 2, 1, 1, 0, 1, 0, 0, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Base fork:");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySelectForkButton = jButton = new JButton();
        jButton.setText("Select Other Fork");
        jPanel.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 0, 1, 0, 0, null, null, null));
        this.myBranchComboBox = comboBox2 = new ComboBox();
        comboBox2.setEditable(false);
        comboBox2.setToolTipText("");
        jPanel.add((Component)comboBox2, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myForkComboBox = comboBox = new ComboBox();
        jPanel.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 0, 1, 2, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

