/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.lazy.types;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.load.java.components.TypeUsage;
import org.jetbrains.kotlin.load.java.lazy.types.ConstantStarSubstitution;
import org.jetbrains.kotlin.load.java.lazy.types.JavaTypeAttributes;
import org.jetbrains.kotlin.load.java.lazy.types.JavaTypeFlexibility;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.StarProjectionImpl;
import org.jetbrains.kotlin.types.StarProjectionImplKt;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a(\u0010\b\u001a\u00020\t*\u00020\u00052\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00052\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\fH\u0000\u001a\n\u0010\r\u001a\u00020\u000e*\u00020\u000f\u001a\n\u0010\u0010\u001a\u00020\u000e*\u00020\u000f\u001a\f\u0010\u0011\u001a\u00020\t*\u00020\tH\u0002\u001a*\u0010\u0012\u001a\u00020\u0007*\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u000e2\b\b\u0002\u0010\u0015\u001a\u00020\u000e2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0005\u001a\u0012\u0010\u0017\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"JAVA_LANG_CLASS_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "makeStarProjection", "Lorg/jetbrains/kotlin/types/TypeProjection;", "typeParameter", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "attr", "Lorg/jetbrains/kotlin/load/java/lazy/types/JavaTypeAttributes;", "getErasedUpperBound", "Lorg/jetbrains/kotlin/types/KotlinType;", "potentiallyRecursiveTypeParameter", "defaultValue", "Lkotlin/Function0;", "isMarkedNotNull", "", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "isMarkedNullable", "replaceArgumentsWithStarProjections", "toAttributes", "Lorg/jetbrains/kotlin/load/java/components/TypeUsage;", "allowFlexible", "isForAnnotationParameter", "upperBoundForTypeParameter", "toFlexible", "flexibility", "Lorg/jetbrains/kotlin/load/java/lazy/types/JavaTypeFlexibility;", "descriptor.loader.java"})
public final class LazyJavaTypeResolverKt {
    private static final FqName JAVA_LANG_CLASS_FQ_NAME = new FqName("java.lang.Class");

    @NotNull
    public static final TypeProjection makeStarProjection(@NotNull TypeParameterDescriptor typeParameter, @NotNull JavaTypeAttributes attr) {
        Intrinsics.checkParameterIsNotNull((Object)typeParameter, (String)"typeParameter");
        Intrinsics.checkParameterIsNotNull((Object)attr, (String)"attr");
        return Intrinsics.areEqual((Object)((Object)attr.getHowThisTypeIsUsed()), (Object)((Object)TypeUsage.SUPERTYPE)) ? (TypeProjection)new TypeProjectionImpl(StarProjectionImplKt.starProjectionType(typeParameter)) : (TypeProjection)new StarProjectionImpl(typeParameter);
    }

    public static final boolean isMarkedNotNull(Annotations $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        FqName fqName2 = JvmAnnotationNames.JETBRAINS_NOT_NULL_ANNOTATION;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"JETBRAINS_NOT_NULL_ANNOTATION");
        return $receiver.findAnnotation(fqName2) != null;
    }

    public static final boolean isMarkedNullable(Annotations $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        FqName fqName2 = JvmAnnotationNames.JETBRAINS_NULLABLE_ANNOTATION;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"JETBRAINS_NULLABLE_ANNOTATION");
        return $receiver.findAnnotation(fqName2) != null;
    }

    @NotNull
    public static final JavaTypeAttributes toAttributes(TypeUsage $receiver, boolean allowFlexible, boolean isForAnnotationParameter, @Nullable TypeParameterDescriptor upperBoundForTypeParameter) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"$receiver");
        return new JavaTypeAttributes($receiver, allowFlexible, isForAnnotationParameter, upperBoundForTypeParameter){
            @NotNull
            private final TypeUsage howThisTypeIsUsed;
            private final boolean isMarkedNotNull = false;
            private final boolean allowFlexible;
            @NotNull
            private final Annotations typeAnnotations;
            private final boolean isForAnnotationParameter;
            @Nullable
            private final TypeParameterDescriptor upperBoundOfTypeParameter;
            final /* synthetic */ TypeUsage receiver$0;
            final /* synthetic */ boolean $allowFlexible;
            final /* synthetic */ boolean $isForAnnotationParameter;
            final /* synthetic */ TypeParameterDescriptor $upperBoundForTypeParameter;

            @NotNull
            public TypeUsage getHowThisTypeIsUsed() {
                return this.howThisTypeIsUsed;
            }

            @NotNull
            public TypeUsage getHowThisTypeIsUsedAccordingToAnnotations() {
                return this.getHowThisTypeIsUsed();
            }

            public boolean isMarkedNotNull() {
                return this.isMarkedNotNull;
            }

            public boolean getAllowFlexible() {
                return this.allowFlexible;
            }

            @NotNull
            public Annotations getTypeAnnotations() {
                return this.typeAnnotations;
            }

            public boolean isForAnnotationParameter() {
                return this.isForAnnotationParameter;
            }

            @Nullable
            public TypeParameterDescriptor getUpperBoundOfTypeParameter() {
                return this.upperBoundOfTypeParameter;
            }
            {
                this.receiver$0 = $receiver;
                this.$allowFlexible = $captured_local_variable$1;
                this.$isForAnnotationParameter = $captured_local_variable$2;
                this.$upperBoundForTypeParameter = $captured_local_variable$3;
                this.howThisTypeIsUsed = this.receiver$0;
                this.allowFlexible = $captured_local_variable$1;
                this.typeAnnotations = Annotations.Companion.getEMPTY();
                this.isForAnnotationParameter = $captured_local_variable$2;
                this.upperBoundOfTypeParameter = $captured_local_variable$3;
            }

            @NotNull
            public JavaTypeFlexibility getFlexibility() {
                return JavaTypeAttributes.DefaultImpls.getFlexibility(this);
            }
        };
    }

    @NotNull
    public static /* bridge */ /* synthetic */ JavaTypeAttributes toAttributes$default(TypeUsage typeUsage, boolean bl, boolean bl2, TypeParameterDescriptor typeParameterDescriptor, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toAttributes");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        if ((n & 4) != 0) {
            typeParameterDescriptor = null;
        }
        return LazyJavaTypeResolverKt.toAttributes(typeUsage, bl, bl2, typeParameterDescriptor);
    }

    @NotNull
    public static final JavaTypeAttributes toFlexible(JavaTypeAttributes $receiver, @NotNull JavaTypeFlexibility flexibility) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)((Object)flexibility), (String)"flexibility");
        return new JavaTypeAttributes($receiver, flexibility){
            @NotNull
            private final JavaTypeFlexibility flexibility;
            private final /* synthetic */ JavaTypeAttributes $delegate_0;
            final /* synthetic */ JavaTypeAttributes receiver$0;
            final /* synthetic */ JavaTypeFlexibility $flexibility;

            @NotNull
            public JavaTypeFlexibility getFlexibility() {
                return this.flexibility;
            }
            {
                this.receiver$0 = $receiver;
                this.$flexibility = $captured_local_variable$1;
                this.$delegate_0 = this.receiver$0;
                this.flexibility = $captured_local_variable$1;
            }

            public boolean getAllowFlexible() {
                return this.$delegate_0.getAllowFlexible();
            }

            @NotNull
            public TypeUsage getHowThisTypeIsUsed() {
                return this.$delegate_0.getHowThisTypeIsUsed();
            }

            @NotNull
            public TypeUsage getHowThisTypeIsUsedAccordingToAnnotations() {
                return this.$delegate_0.getHowThisTypeIsUsedAccordingToAnnotations();
            }

            public boolean isForAnnotationParameter() {
                return this.$delegate_0.isForAnnotationParameter();
            }

            public boolean isMarkedNotNull() {
                return this.$delegate_0.isMarkedNotNull();
            }

            @NotNull
            public Annotations getTypeAnnotations() {
                return this.$delegate_0.getTypeAnnotations();
            }

            @Nullable
            public TypeParameterDescriptor getUpperBoundOfTypeParameter() {
                return this.$delegate_0.getUpperBoundOfTypeParameter();
            }
        };
    }

    @NotNull
    public static final KotlinType getErasedUpperBound(TypeParameterDescriptor $receiver, @Nullable TypeParameterDescriptor potentiallyRecursiveTypeParameter, @NotNull Function0<? extends KotlinType> defaultValue) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(defaultValue, (String)"defaultValue");
        if ($receiver == potentiallyRecursiveTypeParameter) {
            return (KotlinType)defaultValue.invoke();
        }
        KotlinType firstUpperBound = (KotlinType)CollectionsKt.first($receiver.getUpperBounds());
        if (firstUpperBound.getConstructor().getDeclarationDescriptor() instanceof ClassDescriptor) {
            return LazyJavaTypeResolverKt.replaceArgumentsWithStarProjections(firstUpperBound);
        }
        TypeParameterDescriptor typeParameterDescriptor = potentiallyRecursiveTypeParameter;
        if (typeParameterDescriptor == null) {
            typeParameterDescriptor = $receiver;
        }
        TypeParameterDescriptor stopAt = typeParameterDescriptor;
        ClassifierDescriptor classifierDescriptor = firstUpperBound.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.TypeParameterDescriptor");
        }
        TypeParameterDescriptor current = (TypeParameterDescriptor)classifierDescriptor;
        while (Intrinsics.areEqual((Object)current, (Object)stopAt) ^ true) {
            KotlinType nextUpperBound = (KotlinType)CollectionsKt.first(current.getUpperBounds());
            if (nextUpperBound.getConstructor().getDeclarationDescriptor() instanceof ClassDescriptor) {
                return LazyJavaTypeResolverKt.replaceArgumentsWithStarProjections(nextUpperBound);
            }
            ClassifierDescriptor classifierDescriptor2 = nextUpperBound.getConstructor().getDeclarationDescriptor();
            if (classifierDescriptor2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.TypeParameterDescriptor");
            }
            current = (TypeParameterDescriptor)classifierDescriptor2;
        }
        return (KotlinType)defaultValue.invoke();
    }

    @NotNull
    public static /* bridge */ /* synthetic */ KotlinType getErasedUpperBound$default(TypeParameterDescriptor typeParameterDescriptor, TypeParameterDescriptor typeParameterDescriptor2, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getErasedUpperBound");
        }
        if ((n & 1) != 0) {
            typeParameterDescriptor2 = null;
        }
        if ((n & 2) != 0) {
            function0 = (Function0)new Function0<KotlinType>(typeParameterDescriptor){
                final /* synthetic */ TypeParameterDescriptor receiver$0;

                @NotNull
                public final KotlinType invoke() {
                    KotlinType kotlinType = ErrorUtils.createErrorType("Can't compute erased upper bound of type parameter `" + this.receiver$0 + "`");
                    Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"ErrorUtils.createErrorTy\u2026 type parameter `$this`\")");
                    return kotlinType;
                }
                {
                    this.receiver$0 = typeParameterDescriptor;
                    super(0);
                }
            };
        }
        return LazyJavaTypeResolverKt.getErasedUpperBound(typeParameterDescriptor, typeParameterDescriptor2, (Function0<? extends KotlinType>)function0);
    }

    private static final KotlinType replaceArgumentsWithStarProjections(KotlinType $receiver) {
        if ($receiver.getConstructor().getParameters().isEmpty() || $receiver.getConstructor().getDeclarationDescriptor() == null) {
            return $receiver;
        }
        KotlinType kotlinType = TypeSubstitutor.create(ConstantStarSubstitution.INSTANCE).substitute($receiver, Variance.INVARIANT);
        if (kotlinType == null) {
            Intrinsics.throwNpe();
        }
        return kotlinType;
    }

    @NotNull
    public static final /* synthetic */ FqName access$getJAVA_LANG_CLASS_FQ_NAME$p() {
        return JAVA_LANG_CLASS_FQ_NAME;
    }

    @NotNull
    public static final /* synthetic */ KotlinType access$replaceArgumentsWithStarProjections(KotlinType $receiver) {
        return LazyJavaTypeResolverKt.replaceArgumentsWithStarProjections($receiver);
    }
}

