/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.TokenSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitor;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DeclarationsCheckerBuilder;
import org.jetbrains.kotlin.resolve.DeclarationsCheckerKt;
import org.jetbrains.kotlin.resolve.FunctionDescriptorResolver;
import org.jetbrains.kotlin.resolve.FunctionDescriptorUtil;
import org.jetbrains.kotlin.resolve.IdentifierChecker;
import org.jetbrains.kotlin.resolve.UnderscoreChecker;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.types.CommonSupertypes;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.CoercionStrategy;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitor;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.ValueParameterResolver;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J$\u0010\u0019\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0013H\u0002J,\u0010\u001b\u001a\u0004\u0018\u00010\u00132\u0006\u0010\t\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u001c\u001a\u0004\u0018\u00010\u0013H\u0002J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\t\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0015\u001a\u00020 H\u0002J\u001a\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\t\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\bH\u0016J(\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010'\u001a\u00020\u00182\b\u0010(\u001a\u0004\u0018\u00010)\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/types/expressions/FunctionsTypingVisitor;", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingVisitor;", "facade", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingInternals;", "(Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingInternals;)V", "checkReservedAsync", "", "context", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "expression", "Lcom/intellij/psi/PsiElement;", "collectReturns", "", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "functionLiteral", "Lorg/jetbrains/kotlin/psi/KtFunctionLiteral;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "computeReturnType", "Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/impl/SimpleFunctionDescriptorImpl;", "functionTypeExpected", "", "computeReturnTypeBasedOnReturnExpressions", "typeOfBodyExpression", "computeUnsafeReturnType", "expectedReturnType", "createFunctionLiteralDescriptor", "Lorg/jetbrains/kotlin/descriptors/impl/AnonymousFunctionDescriptor;", "createFunctionType", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "visitLambdaExpression", "Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "data", "isStatement", "statementScope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalWritableScope;", "frontend"})
public final class FunctionsTypingVisitor
extends ExpressionTypingVisitor {
    @Override
    @NotNull
    public KotlinTypeInfo visitNamedFunction(@NotNull KtNamedFunction function2, @NotNull ExpressionTypingContext data) {
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return this.visitNamedFunction(function2, data, false, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final KotlinTypeInfo visitNamedFunction(@NotNull KtNamedFunction function2, @NotNull ExpressionTypingContext context, boolean isStatement, @Nullable LexicalWritableScope statementScope) {
        SimpleFunctionDescriptor functionDescriptor;
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.checkReservedAsync(context, function2);
        if (!isStatement) {
            if (!function2.getTypeParameters().isEmpty()) {
                context.trace.report(Errors.TYPE_PARAMETERS_NOT_ALLOWED.on((KtDeclaration)((PsiElement)function2)));
            }
            if (function2.getName() != null) {
                BindingTrace bindingTrace = context.trace;
                PsiElement psiElement = function2.getNameIdentifier();
                if (psiElement == null) {
                    Intrinsics.throwNpe();
                }
                bindingTrace.report(Errors.ANONYMOUS_FUNCTION_WITH_NAME.on(psiElement));
            }
            for (KtParameter parameter : function2.getValueParameters()) {
                if (parameter.hasDefaultValue()) {
                    context.trace.report(Errors.ANONYMOUS_FUNCTION_PARAMETER_WITH_DEFAULT_VALUE.on((KtParameter)((PsiElement)parameter)));
                }
                if (!parameter.isVarArg()) continue;
                context.trace.report(Errors.USELESS_VARARG_ON_PARAMETER.on((KtParameter)((PsiElement)parameter)));
            }
        }
        if (isStatement) {
            Unit unit;
            FunctionDescriptorResolver functionDescriptorResolver = this.components.functionDescriptorResolver;
            DeclarationDescriptor declarationDescriptor = context.scope.getOwnerDescriptor();
            LexicalScope lexicalScope = context.scope;
            Intrinsics.checkExpressionValueIsNotNull((Object)lexicalScope, (String)"context.scope");
            BindingTrace bindingTrace = context.trace;
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace, (String)"context.trace");
            DataFlowInfo dataFlowInfo = context.dataFlowInfo;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataFlowInfo, (String)"context.dataFlowInfo");
            functionDescriptor = functionDescriptorResolver.resolveFunctionDescriptor(declarationDescriptor, lexicalScope, function2, bindingTrace, dataFlowInfo);
            boolean bl = statementScope != null;
            if (_Assertions.ENABLED) {
                void value$iv;
                if (value$iv == false) {
                    String message$iv = "statementScope must be not null for function: " + function2.getName() + " at location " + DiagnosticUtils.atLocation(function2);
                    throw (Throwable)((Object)new AssertionError((Object)message$iv));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
            LexicalWritableScope lexicalWritableScope = statementScope;
            if (lexicalWritableScope == null) {
                Intrinsics.throwNpe();
            }
            lexicalWritableScope.addFunctionDescriptor(functionDescriptor);
        } else {
            FunctionDescriptorResolver functionDescriptorResolver = this.components.functionDescriptorResolver;
            DeclarationDescriptor declarationDescriptor = context.scope.getOwnerDescriptor();
            LexicalScope lexicalScope = context.scope;
            Intrinsics.checkExpressionValueIsNotNull((Object)lexicalScope, (String)"context.scope");
            BindingTrace bindingTrace = context.trace;
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace, (String)"context.trace");
            DataFlowInfo dataFlowInfo = context.dataFlowInfo;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataFlowInfo, (String)"context.dataFlowInfo");
            KotlinType kotlinType = context.expectedType;
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"context.expectedType");
            functionDescriptor = functionDescriptorResolver.resolveFunctionExpressionDescriptor(declarationDescriptor, lexicalScope, function2, bindingTrace, dataFlowInfo, kotlinType);
        }
        ForceResolveUtil.forceResolveAllContents(functionDescriptor.getAnnotations());
        if (!function2.hasDeclaredReturnType() && !function2.hasBlockBody()) {
            ForceResolveUtil.forceResolveAllContents(functionDescriptor.getReturnType());
        } else {
            LexicalScope functionInnerScope = FunctionDescriptorUtil.getFunctionInnerScope(context.scope, (FunctionDescriptor)functionDescriptor, context.trace);
            this.components.expressionTypingServices.checkFunctionReturnType(functionInnerScope, function2, functionDescriptor, context.dataFlowInfo, null, context.trace);
        }
        ValueParameterResolver valueParameterResolver = this.components.valueParameterResolver;
        List<KtParameter> list2 = function2.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"function.getValueParameters()");
        List<ValueParameterDescriptor> list3 = functionDescriptor.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"functionDescriptor.valueParameters");
        LexicalScope lexicalScope = context.scope;
        Intrinsics.checkExpressionValueIsNotNull((Object)lexicalScope, (String)"context.scope");
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        Intrinsics.checkExpressionValueIsNotNull((Object)dataFlowInfo, (String)"context.dataFlowInfo");
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace, (String)"context.trace");
        valueParameterResolver.resolveValueParameters(list2, list3, lexicalScope, dataFlowInfo, bindingTrace);
        KtDeclaration ktDeclaration = function2;
        BindingTrace bindingTrace2 = context.trace;
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace2, (String)"context.trace");
        DeclarationsCheckerKt.checkTypeReferences(ktDeclaration, bindingTrace2);
        this.components.modifiersChecker.withTrace(context.trace).checkModifiersForLocalDeclaration(function2, functionDescriptor);
        IdentifierChecker identifierChecker = this.components.identifierChecker;
        KtDeclaration ktDeclaration2 = function2;
        DiagnosticSink diagnosticSink = context.trace;
        Intrinsics.checkExpressionValueIsNotNull((Object)diagnosticSink, (String)"context.trace");
        identifierChecker.checkDeclaration(ktDeclaration2, diagnosticSink);
        DeclarationsCheckerBuilder declarationsCheckerBuilder = this.components.declarationsCheckerBuilder;
        BindingTrace bindingTrace3 = context.trace;
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace3, (String)"context.trace");
        declarationsCheckerBuilder.withTrace(bindingTrace3).checkFunction(function2, functionDescriptor);
        if (isStatement) {
            return TypeInfoFactoryKt.createTypeInfo(this.components.dataFlowAnalyzer.checkStatementType(function2, context), context);
        }
        KotlinTypeInfo kotlinTypeInfo = this.components.dataFlowAnalyzer.createCheckedTypeInfo(this.createFunctionType(functionDescriptor), context, function2);
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinTypeInfo, (String)"components.dataFlowAnaly\u2026ptor), context, function)");
        return kotlinTypeInfo;
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinType createFunctionType(SimpleFunctionDescriptor functionDescriptor) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        ReceiverParameterDescriptor receiverParameterDescriptor = functionDescriptor.getExtensionReceiverParameter();
        KotlinType receiverType = receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null;
        KotlinType returnType2 = functionDescriptor.getReturnType();
        if (returnType2 == null) {
            return null;
        }
        Iterable iterable = functionDescriptor.getValueParameters();
        void var6_5 = $receiver$iv;
        Collection collection = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv$iv;
            void var14_10 = destination$iv$iv;
            KotlinType kotlinType = it.getType();
            var14_10.add(kotlinType);
        }
        List parameters2 = (List)destination$iv$iv;
        return this.components.builtIns.getFunctionType(Annotations.Companion.getEMPTY(), receiverType, parameters2, returnType2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public KotlinTypeInfo visitLambdaExpression(@NotNull KtLambdaExpression expression2, @NotNull ExpressionTypingContext context) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.checkReservedAsync(context, (PsiElement)expression2);
        if (!expression2.getFunctionLiteral().hasBody()) {
            return null;
        }
        KotlinType expectedType = context.expectedType;
        boolean functionTypeExpected = !TypeUtils.noExpectedType(expectedType) && KotlinBuiltIns.isFunctionOrExtensionFunctionType(expectedType);
        AnonymousFunctionDescriptor functionDescriptor = this.createFunctionLiteralDescriptor(expression2, context);
        Iterable iterable = expression2.getValueParameters();
        for (Object element$iv : $receiver$iv) {
            KtParameter it = (KtParameter)element$iv;
            IdentifierChecker identifierChecker = this.components.identifierChecker;
            KtDeclaration ktDeclaration = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktDeclaration, (String)"it");
            DiagnosticSink diagnosticSink = context.trace;
            Intrinsics.checkExpressionValueIsNotNull((Object)diagnosticSink, (String)"context.trace");
            identifierChecker.checkDeclaration(ktDeclaration, diagnosticSink);
            KtNamedDeclaration ktNamedDeclaration = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktNamedDeclaration, (String)"it");
            DiagnosticSink diagnosticSink2 = context.trace;
            Intrinsics.checkExpressionValueIsNotNull((Object)diagnosticSink2, (String)"context.trace");
            UnderscoreChecker.INSTANCE.checkNamed(ktNamedDeclaration, diagnosticSink2);
        }
        KotlinType safeReturnType = this.computeReturnType(expression2, context, functionDescriptor, functionTypeExpected);
        functionDescriptor.setReturnType(safeReturnType);
        KotlinType kotlinType = this.createFunctionType(functionDescriptor);
        if (kotlinType == null) {
            Intrinsics.throwNpe();
        }
        KotlinType resultType = kotlinType;
        if (functionTypeExpected) {
            return TypeInfoFactoryKt.createTypeInfo(resultType, context);
        }
        return this.components.dataFlowAnalyzer.createCheckedTypeInfo(resultType, context, expression2);
    }

    private final void checkReservedAsync(ExpressionTypingContext context, PsiElement expression2) {
        DiagnosticSink diagnosticSink = context.trace;
        Intrinsics.checkExpressionValueIsNotNull((Object)diagnosticSink, (String)"context.trace");
        TokenSet tokenSet = KtTokens.BINARY_OPERATIONS;
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet, (String)"KtTokens.BINARY_OPERATIONS");
        KtPsiUtilKt.checkReservedPrefixWord(diagnosticSink, expression2, "async", tokenSet, "async block/lambda. Use 'async() { ... }' or 'async(fun...)'");
    }

    private final AnonymousFunctionDescriptor createFunctionLiteralDescriptor(KtLambdaExpression expression2, ExpressionTypingContext context) {
        KtFunctionLiteral functionLiteral = expression2.getFunctionLiteral();
        AnonymousFunctionDescriptor functionDescriptor = new AnonymousFunctionDescriptor(context.scope.getOwnerDescriptor(), this.components.annotationResolver.resolveAnnotationsWithArguments(context.scope, KtPsiUtilKt.getAnnotationEntries(expression2), context.trace), CallableMemberDescriptor.Kind.DECLARATION, KotlinSourceElementKt.toSourceElement(functionLiteral));
        FunctionDescriptorResolver functionDescriptorResolver = this.components.functionDescriptorResolver;
        DeclarationDescriptor declarationDescriptor = context.scope.getOwnerDescriptor();
        LexicalScope lexicalScope = context.scope;
        Intrinsics.checkExpressionValueIsNotNull((Object)lexicalScope, (String)"context.scope");
        KtFunction ktFunction = functionLiteral;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktFunction, (String)"functionLiteral");
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = functionDescriptor;
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace, (String)"context.trace");
        KotlinType kotlinType = context.expectedType;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"context.expectedType");
        functionDescriptorResolver.initializeFunctionDescriptorAndExplicitReturnType(declarationDescriptor, lexicalScope, ktFunction, simpleFunctionDescriptorImpl, bindingTrace, kotlinType);
        for (ValueParameterDescriptor parameterDescriptor : functionDescriptor.getValueParameters()) {
            ForceResolveUtil.forceResolveAllContents(parameterDescriptor.getAnnotations());
        }
        BindingContextUtils.recordFunctionDeclarationToDescriptor(context.trace, functionLiteral, functionDescriptor);
        return functionDescriptor;
    }

    private final KotlinType computeReturnType(KtLambdaExpression expression2, ExpressionTypingContext context, SimpleFunctionDescriptorImpl functionDescriptor, boolean functionTypeExpected) {
        KotlinType kotlinType;
        KotlinType expectedReturnType = functionTypeExpected ? KotlinBuiltIns.getReturnTypeFromFunctionType(context.expectedType) : (KotlinType)null;
        KotlinType returnType2 = this.computeUnsafeReturnType(expression2, context, functionDescriptor, expectedReturnType);
        if (!expression2.getFunctionLiteral().hasDeclaredReturnType() && functionTypeExpected) {
            KotlinType kotlinType2 = expectedReturnType;
            if (kotlinType2 == null) {
                Intrinsics.throwNpe();
            }
            if (!TypeUtils.noExpectedType(kotlinType2) && KotlinBuiltIns.isUnit(expectedReturnType)) {
                KotlinType kotlinType3 = this.components.builtIns.getUnitType();
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType3, (String)"components.builtIns.unitType");
                return kotlinType3;
            }
        }
        if ((kotlinType = returnType2) == null) {
            KotlinType kotlinType4 = TypeUtils.CANT_INFER_FUNCTION_PARAM_TYPE;
            kotlinType = kotlinType4;
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType4, (String)"CANT_INFER_FUNCTION_PARAM_TYPE");
        }
        return kotlinType;
    }

    private final KotlinType computeUnsafeReturnType(KtLambdaExpression expression2, ExpressionTypingContext context, SimpleFunctionDescriptorImpl functionDescriptor, KotlinType expectedReturnType) {
        KtFunctionLiteral functionLiteral = expression2.getFunctionLiteral();
        KotlinType kotlinType = expectedReturnType;
        if (kotlinType == null) {
            KotlinType kotlinType2 = TypeUtils.NO_EXPECTED_TYPE;
            kotlinType = kotlinType2;
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"NO_EXPECTED_TYPE");
        }
        KotlinType expectedType = kotlinType;
        LexicalScope functionInnerScope = FunctionDescriptorUtil.getFunctionInnerScope(context.scope, (FunctionDescriptor)functionDescriptor, context.trace);
        ExpressionTypingContext newContext = (ExpressionTypingContext)((ExpressionTypingContext)context.replaceScope(functionInnerScope)).replaceExpectedType(expectedType);
        context.trace.record(BindingContext.EXPECTED_RETURN_TYPE, functionLiteral, expectedType);
        ExpressionTypingServices expressionTypingServices = this.components.expressionTypingServices;
        KtBlockExpression ktBlockExpression = functionLiteral.getBodyExpression();
        if (ktBlockExpression == null) {
            Intrinsics.throwNpe();
        }
        KotlinType typeOfBodyExpression = expressionTypingServices.getBlockReturnedType(ktBlockExpression, CoercionStrategy.COERCION_TO_UNIT, newContext).getType();
        KtFunctionLiteral ktFunctionLiteral = functionLiteral;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktFunctionLiteral, (String)"functionLiteral");
        return this.computeReturnTypeBasedOnReturnExpressions(ktFunctionLiteral, context, typeOfBodyExpression);
    }

    private final KotlinType computeReturnTypeBasedOnReturnExpressions(KtFunctionLiteral functionLiteral, ExpressionTypingContext context, KotlinType typeOfBodyExpression) {
        KtExpression returnedExpression;
        ArrayList returnedExpressionTypes = Lists.newArrayList();
        boolean hasEmptyReturn = false;
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace, (String)"context.trace");
        Collection<KtReturnExpression> returnExpressions = this.collectReturns(functionLiteral, bindingTrace);
        for (KtReturnExpression returnExpression : returnExpressions) {
            returnedExpression = returnExpression.getReturnedExpression();
            if (returnedExpression == null) {
                hasEmptyReturn = true;
                continue;
            }
            CollectionsKt.addIfNotNull(returnedExpressionTypes, context.trace.getType(returnedExpression));
        }
        if (hasEmptyReturn) {
            for (KtReturnExpression returnExpression : returnExpressions) {
                KotlinType type2;
                returnedExpression = returnExpression.getReturnedExpression();
                if (returnedExpression == null || (type2 = context.trace.getType(returnedExpression)) != null && KotlinBuiltIns.isUnit(type2)) continue;
                context.trace.report(Errors.RETURN_TYPE_MISMATCH.on((KtExpression)((PsiElement)returnedExpression), this.components.builtIns.getUnitType()));
            }
            return this.components.builtIns.getUnitType();
        }
        CollectionsKt.addIfNotNull(returnedExpressionTypes, typeOfBodyExpression);
        if (returnedExpressionTypes.isEmpty()) {
            return null;
        }
        return CommonSupertypes.commonSupertype(returnedExpressionTypes);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<KtReturnExpression> collectReturns(KtFunctionLiteral functionLiteral, BindingTrace trace) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        KtBlockExpression bodyExpression;
        ArrayList result2 = Lists.newArrayList();
        KtBlockExpression ktBlockExpression = bodyExpression = functionLiteral.getBodyExpression();
        Void void_ = ktBlockExpression != null ? (Void)ktBlockExpression.accept((KtVisitor)new KtTreeVisitor<List<KtReturnExpression>>(){

            @Nullable
            public Void visitReturnExpression(@NotNull KtReturnExpression expression2, @NotNull List<KtReturnExpression> data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull(data, (String)"data");
                data.add(expression2);
                return null;
            }
        }, result2) : null;
        Iterable iterable = result2;
        void var6_6 = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            PsiElement psiElement;
            KtReturnExpression it = (KtReturnExpression)element$iv$iv;
            if (it.getTargetLabel() != null) {
                void $receiver$iv2;
                KtSimpleNameExpression it2 = (KtSimpleNameExpression)$receiver$iv2;
                psiElement = (PsiElement)trace.get(BindingContext.LABEL_TARGET, it2);
            } else {
                psiElement = null;
            }
            if (!Intrinsics.areEqual(psiElement, (Object)functionLiteral)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public FunctionsTypingVisitor(@NotNull ExpressionTypingInternals facade) {
        Intrinsics.checkParameterIsNotNull((Object)facade, (String)"facade");
        super(facade);
    }
}

