/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.actions;

import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.propertyInspector.IntrospectedProperty;
import com.intellij.uiDesigner.propertyInspector.PropertyInspectorTable;
import java.awt.Component;
import java.awt.Point;
import javax.swing.JComponent;

public final class ShowJavadocAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.actions.ShowJavadocAction");

    public void actionPerformed(AnActionEvent e) {
        final PropertyInspectorTable inspector = (PropertyInspectorTable)((Object)PropertyInspectorTable.DATA_KEY.getData(e.getDataContext()));
        final IntrospectedProperty introspectedProperty = inspector.getSelectedIntrospectedProperty();
        final PsiClass aClass = inspector.getComponentClass();
        PsiMethod getter = PropertyUtil.findPropertyGetter((PsiClass)aClass, (String)introspectedProperty.getName(), (boolean)false, (boolean)true);
        LOG.assertTrue(getter != null);
        PsiMethod setter = PropertyUtil.findPropertySetter((PsiClass)aClass, (String)introspectedProperty.getName(), (boolean)false, (boolean)true);
        LOG.assertTrue(setter != null);
        DocumentationManager documentationManager = DocumentationManager.getInstance((Project)aClass.getProject());
        final DocumentationComponent component1 = new DocumentationComponent(documentationManager);
        final DocumentationComponent component2 = new DocumentationComponent(documentationManager);
        final Disposable disposable = Disposer.newDisposable();
        final TabbedPaneWrapper tabbedPane = new TabbedPaneWrapper(disposable);
        tabbedPane.addTab(UIDesignerBundle.message("tab.getter", new Object[0]), (JComponent)component1);
        tabbedPane.addTab(UIDesignerBundle.message("tab.setter", new Object[0]), (JComponent)component2);
        documentationManager.fetchDocInfo((PsiElement)getter, component1);
        documentationManager.queueFetchDocInfo((PsiElement)setter, component2).doWhenProcessed(new Runnable(){

            @Override
            public void run() {
                JBPopup hint = JBPopupFactory.getInstance().createComponentPopupBuilder(tabbedPane.getComponent(), (JComponent)component1).setDimensionServiceKey(aClass.getProject(), "javadoc.popup", false).setResizable(true).setMovable(true).setRequestFocus(true).setTitle(UIDesignerBundle.message("property.javadoc.title", introspectedProperty.getName())).createPopup();
                component1.setHint(hint);
                component2.setHint(hint);
                Disposer.register((Disposable)hint, (Disposable)component1);
                Disposer.register((Disposable)hint, (Disposable)component2);
                Disposer.register((Disposable)hint, (Disposable)disposable);
                hint.show(new RelativePoint((Component)((Object)inspector), new Point(0, 0)));
            }
        });
    }

    public void update(AnActionEvent e) {
        PropertyInspectorTable inspector = (PropertyInspectorTable)((Object)PropertyInspectorTable.DATA_KEY.getData(e.getDataContext()));
        e.getPresentation().setEnabled(inspector != null && inspector.getSelectedIntrospectedProperty() != null && inspector.getComponentClass() != null);
    }
}

