/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.concurrency.AppDelayQueue;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;

class SchedulingWrapper
implements ScheduledExecutorService {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.concurrency.SchedulingWrapper");
    private final AtomicBoolean shutdown;
    @NotNull
    final ExecutorService backendExecutorService;
    final AppDelayQueue delayQueue;
    private static final AtomicLong sequencer = new AtomicLong();

    SchedulingWrapper(@NotNull ExecutorService backendExecutorService, @NotNull AppDelayQueue delayQueue) {
        if (backendExecutorService == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backendExecutorService", "com/intellij/util/concurrency/SchedulingWrapper", "<init>"));
        }
        if (delayQueue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delayQueue", "com/intellij/util/concurrency/SchedulingWrapper", "<init>"));
        }
        this.shutdown = new AtomicBoolean();
        this.delayQueue = delayQueue;
        if (backendExecutorService instanceof ScheduledExecutorService) {
            throw new IllegalArgumentException("backendExecutorService: " + backendExecutorService + " is already ScheduledExecutorService");
        }
        this.backendExecutorService = backendExecutorService;
    }

    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        List<Runnable> list = this.doShutdownNow();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/SchedulingWrapper", "shutdownNow"));
        }
        return list;
    }

    @Override
    public void shutdown() {
        this.doShutdown();
    }

    void doShutdown() {
        if (!this.shutdown.compareAndSet(false, true)) {
            throw new IllegalStateException("Already shutdown");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Shutdown", new Throwable());
        }
    }

    @NotNull
    List<Runnable> doShutdownNow() {
        this.doShutdown();
        List<Runnable> result = ContainerUtil.filter(this.delayQueue, new Condition<MyScheduledFutureTask>(){

            @Override
            public boolean value(MyScheduledFutureTask task) {
                if (task.getBackendExecutorService() == SchedulingWrapper.this.backendExecutorService) {
                    task.cancel(false);
                    return true;
                }
                return false;
            }
        });
        this.delayQueue.removeAll(new HashSet<MyScheduledFutureTask>(result));
        if (LOG.isTraceEnabled()) {
            LOG.trace("Shutdown. Drained tasks: " + result);
        }
        List<Runnable> list = result;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/SchedulingWrapper", "doShutdownNow"));
        }
        return list;
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown.get();
    }

    @Override
    public boolean isTerminated() {
        return this.isShutdown();
    }

    @Override
    public boolean awaitTermination(long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException {
        if (timeUnit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/util/concurrency/SchedulingWrapper", "awaitTermination"));
        }
        return this.isTerminated();
    }

    /*
     * WARNING - void declaration
     */
    private static long triggerTime(@NotNull AppDelayQueue queue, long delay, TimeUnit timeUnit) {
        void unit;
        if (queue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queue", "com/intellij/util/concurrency/SchedulingWrapper", "triggerTime"));
        }
        return SchedulingWrapper.triggerTime(queue, unit.toNanos(delay < 0L ? 0L : delay));
    }

    private static long now() {
        return System.nanoTime();
    }

    private static long triggerTime(@NotNull AppDelayQueue queue, long delay) {
        if (queue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queue", "com/intellij/util/concurrency/SchedulingWrapper", "triggerTime"));
        }
        return SchedulingWrapper.now() + (delay < 0x3FFFFFFFFFFFFFFFL ? delay : SchedulingWrapper.overflowFree(queue, delay));
    }

    private static long overflowFree(@NotNull AppDelayQueue queue, long delay) {
        long headDelay;
        if (queue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queue", "com/intellij/util/concurrency/SchedulingWrapper", "overflowFree"));
        }
        Object head = queue.peek();
        if (head != null && (headDelay = head.getDelay(TimeUnit.NANOSECONDS)) < 0L && delay - headDelay < 0L) {
            delay = Long.MAX_VALUE + headDelay;
        }
        return delay;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ScheduledFuture<?> schedule(@NotNull Runnable command, long delay, @NotNull TimeUnit timeUnit) {
        void unit;
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/util/concurrency/SchedulingWrapper", "schedule"));
        }
        if (timeUnit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/util/concurrency/SchedulingWrapper", "schedule"));
        }
        MyScheduledFutureTask t = new MyScheduledFutureTask(command, null, SchedulingWrapper.triggerTime(this.delayQueue, delay, (TimeUnit)unit));
        MyScheduledFutureTask myScheduledFutureTask = this.delayedExecute(t);
        if (myScheduledFutureTask == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/SchedulingWrapper", "schedule"));
        }
        return myScheduledFutureTask;
    }

    @NotNull
    private <T> MyScheduledFutureTask<T> delayedExecute(@NotNull MyScheduledFutureTask<T> t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/util/concurrency/SchedulingWrapper", "delayedExecute"));
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Submit at delay " + t.getDelay(TimeUnit.MILLISECONDS) + "ms " + BoundedTaskExecutor.info(t));
        }
        if (this.isShutdown()) {
            throw new RejectedExecutionException("Already shutdown");
        }
        this.delayQueue.add(t);
        MyScheduledFutureTask<T> myScheduledFutureTask = t;
        if (myScheduledFutureTask == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/SchedulingWrapper", "delayedExecute"));
        }
        return myScheduledFutureTask;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <V> ScheduledFuture<V> schedule(@NotNull Callable<V> callable, long delay, @NotNull TimeUnit timeUnit) {
        void unit;
        if (callable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "com/intellij/util/concurrency/SchedulingWrapper", "schedule"));
        }
        if (timeUnit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/util/concurrency/SchedulingWrapper", "schedule"));
        }
        MyScheduledFutureTask t = new MyScheduledFutureTask(callable, SchedulingWrapper.triggerTime(this.delayQueue, delay, (TimeUnit)unit));
        MyScheduledFutureTask myScheduledFutureTask = this.delayedExecute(t);
        if (myScheduledFutureTask == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/SchedulingWrapper", "schedule"));
        }
        return myScheduledFutureTask;
    }

    @Override
    @NotNull
    public ScheduledFuture<?> scheduleAtFixedRate(@NotNull Runnable command, long initialDelay, long period, @NotNull TimeUnit timeUnit) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/util/concurrency/SchedulingWrapper", "scheduleAtFixedRate"));
        }
        if (timeUnit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/util/concurrency/SchedulingWrapper", "scheduleAtFixedRate"));
        }
        throw new IncorrectOperationException("Not supported because it's bad for hibernation; use scheduleWithFixedDelay() instead.");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ScheduledFuture<?> scheduleWithFixedDelay(@NotNull Runnable command, long initialDelay, long delay, @NotNull TimeUnit timeUnit) {
        void unit;
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/util/concurrency/SchedulingWrapper", "scheduleWithFixedDelay"));
        }
        if (timeUnit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/util/concurrency/SchedulingWrapper", "scheduleWithFixedDelay"));
        }
        if (delay <= 0L) {
            throw new IllegalArgumentException("delay must be positive but got: " + delay);
        }
        MyScheduledFutureTask sft = new MyScheduledFutureTask(command, null, SchedulingWrapper.triggerTime(this.delayQueue, initialDelay, (TimeUnit)unit), unit.toNanos(-delay));
        MyScheduledFutureTask myScheduledFutureTask = this.delayedExecute(sft);
        if (myScheduledFutureTask == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/SchedulingWrapper", "scheduleWithFixedDelay"));
        }
        return myScheduledFutureTask;
    }

    @Override
    @NotNull
    public <T> Future<T> submit(@NotNull Callable<T> task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/util/concurrency/SchedulingWrapper", "submit"));
        }
        Future<T> future = this.backendExecutorService.submit(task);
        if (future == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/SchedulingWrapper", "submit"));
        }
        return future;
    }

    @Override
    @NotNull
    public <T> Future<T> submit(@NotNull Runnable task, T result) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/util/concurrency/SchedulingWrapper", "submit"));
        }
        Future<T> future = this.backendExecutorService.submit(task, result);
        if (future == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/SchedulingWrapper", "submit"));
        }
        return future;
    }

    @Override
    @NotNull
    public Future<?> submit(@NotNull Runnable task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/util/concurrency/SchedulingWrapper", "submit"));
        }
        Future<?> future = this.backendExecutorService.submit(task);
        if (future == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/SchedulingWrapper", "submit"));
        }
        return future;
    }

    @Override
    @NotNull
    public <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> tasks) throws InterruptedException {
        if (tasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasks", "com/intellij/util/concurrency/SchedulingWrapper", "invokeAll"));
        }
        List list = this.backendExecutorService.invokeAll(tasks);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/SchedulingWrapper", "invokeAll"));
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> tasks, long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException {
        void unit;
        if (tasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasks", "com/intellij/util/concurrency/SchedulingWrapper", "invokeAll"));
        }
        if (timeUnit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/util/concurrency/SchedulingWrapper", "invokeAll"));
        }
        List list = this.backendExecutorService.invokeAll(tasks, timeout, (TimeUnit)unit);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/SchedulingWrapper", "invokeAll"));
        }
        return list;
    }

    @Override
    @NotNull
    public <T> T invokeAny(@NotNull Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        if (tasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasks", "com/intellij/util/concurrency/SchedulingWrapper", "invokeAny"));
        }
        Object t = this.backendExecutorService.invokeAny(tasks);
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/SchedulingWrapper", "invokeAny"));
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T invokeAny(@NotNull Collection<? extends Callable<T>> tasks, long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        void unit;
        if (tasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasks", "com/intellij/util/concurrency/SchedulingWrapper", "invokeAny"));
        }
        if (timeUnit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/util/concurrency/SchedulingWrapper", "invokeAny"));
        }
        return this.backendExecutorService.invokeAny(tasks, timeout, (TimeUnit)unit);
    }

    @Override
    public void execute(@NotNull Runnable command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/util/concurrency/SchedulingWrapper", "execute"));
        }
        this.backendExecutorService.execute(command);
    }

    class MyScheduledFutureTask<V>
    extends FutureTask<V>
    implements RunnableScheduledFuture<V> {
        private final long sequenceNumber;
        private long time;
        private final long period;

        private MyScheduledFutureTask(Runnable r, V result, long ns) {
            if (r == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/util/concurrency/SchedulingWrapper$MyScheduledFutureTask", "<init>"));
            }
            super(r, result);
            this.time = ns;
            this.period = 0L;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        /*
         * WARNING - void declaration
         */
        private MyScheduledFutureTask(Runnable r, V result, long ns, long l) {
            void period;
            if (r == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/util/concurrency/SchedulingWrapper$MyScheduledFutureTask", "<init>"));
            }
            super(r, result);
            this.time = ns;
            this.period = period;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        private MyScheduledFutureTask(Callable<V> callable, long ns) {
            if (callable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "com/intellij/util/concurrency/SchedulingWrapper$MyScheduledFutureTask", "<init>"));
            }
            super(callable);
            this.time = ns;
            this.period = 0L;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean canceled = super.cancel(mayInterruptIfRunning);
            SchedulingWrapper.this.delayQueue.remove(this);
            return canceled;
        }

        @Override
        public long getDelay(@NotNull TimeUnit unit) {
            if (unit == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/util/concurrency/SchedulingWrapper$MyScheduledFutureTask", "getDelay"));
            }
            return unit.convert(this.time - SchedulingWrapper.now(), TimeUnit.NANOSECONDS);
        }

        @Override
        public int compareTo(@NotNull Delayed other) {
            if (other == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/util/concurrency/SchedulingWrapper$MyScheduledFutureTask", "compareTo"));
            }
            if (other == this) {
                return 0;
            }
            if (other instanceof MyScheduledFutureTask) {
                MyScheduledFutureTask x = (MyScheduledFutureTask)other;
                long diff = this.time - x.time;
                if (diff < 0L) {
                    return -1;
                }
                if (diff > 0L) {
                    return 1;
                }
                if (this.sequenceNumber < x.sequenceNumber) {
                    return -1;
                }
                return 1;
            }
            long diff = this.getDelay(TimeUnit.NANOSECONDS) - other.getDelay(TimeUnit.NANOSECONDS);
            return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
        }

        @Override
        public boolean isPeriodic() {
            return this.period != 0L;
        }

        private void setNextRunTime() {
            long p = this.period;
            this.time = p > 0L ? (this.time += p) : SchedulingWrapper.triggerTime(SchedulingWrapper.this.delayQueue, -p);
        }

        @Override
        public void run() {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Executing " + BoundedTaskExecutor.info(this));
            }
            boolean periodic = this.isPeriodic();
            if (SchedulingWrapper.this.backendExecutorService.isShutdown()) {
                this.cancel(false);
            } else if (!periodic) {
                super.run();
            } else if (this.runAndReset()) {
                this.setNextRunTime();
                SchedulingWrapper.this.delayQueue.offer(this);
            }
        }

        @Override
        public String toString() {
            return "Delay: " + this.getDelay(TimeUnit.MILLISECONDS) + "ms; " + BoundedTaskExecutor.info(this);
        }

        @NotNull
        ExecutorService getBackendExecutorService() {
            ExecutorService executorService = SchedulingWrapper.this.backendExecutorService;
            if (executorService == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/SchedulingWrapper$MyScheduledFutureTask", "getBackendExecutorService"));
            }
            return executorService;
        }
    }
}

