/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ClassMap<T> {
    protected final Map<Class, T> myMap;

    public ClassMap() {
        this((Map<Class, T>)new THashMap());
    }

    protected ClassMap(@NotNull Map<Class, T> map) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/util/containers/ClassMap", "<init>"));
        }
        this.myMap = map;
    }

    public void put(@NotNull Class aClass, T value) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/containers/ClassMap", "put"));
        }
        this.myMap.put(aClass, value);
    }

    public void remove(@NotNull Class aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/containers/ClassMap", "remove"));
        }
        this.myMap.remove(aClass);
    }

    public T get(@NotNull Class aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/containers/ClassMap", "get"));
        }
        T t = this.myMap.get(aClass);
        if (t != null) {
            return t;
        }
        for (Class<?> aClass1 : aClass.getInterfaces()) {
            t = this.get(aClass1);
            if (t == null) continue;
            this.myMap.put(aClass, t);
            return t;
        }
        Class superclass = aClass.getSuperclass();
        if (superclass != null && (t = this.get(superclass)) != null) {
            this.myMap.put(aClass, t);
            return t;
        }
        return null;
    }

    @NotNull
    public final Collection<T> values() {
        Collection<T> collection = this.myMap.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ClassMap", "values"));
        }
        return collection;
    }

    public void clear() {
        this.myMap.clear();
    }
}

