/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OpenTHashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class OrderedSet<T>
extends ArrayList<T>
implements Set<T>,
RandomAccess {
    private final OpenTHashSet<T> myHashSet;

    public OrderedSet() {
        this(ContainerUtil.canonicalStrategy());
    }

    public OrderedSet(@NotNull Collection<T> set) {
        if (set == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/intellij/util/containers/OrderedSet", "<init>"));
        }
        super(set.size());
        this.myHashSet = new OpenTHashSet(set.size());
        this.addAll((Collection<? extends T>)set);
    }

    public OrderedSet(@NotNull TObjectHashingStrategy<T> hashingStrategy) {
        if (hashingStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "com/intellij/util/containers/OrderedSet", "<init>"));
        }
        this(hashingStrategy, 4);
    }

    public OrderedSet(@NotNull TObjectHashingStrategy<T> hashingStrategy, int capacity) {
        if (hashingStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashingStrategy", "com/intellij/util/containers/OrderedSet", "<init>"));
        }
        super(capacity);
        this.myHashSet = new OpenTHashSet<T>(capacity, hashingStrategy);
    }

    public OrderedSet(int capacity) {
        this(ContainerUtil.canonicalStrategy(), capacity);
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/containers/OrderedSet", "removeAll"));
        }
        boolean removed = false;
        for (Object o : c) {
            removed |= this.remove(o);
        }
        return removed;
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/containers/OrderedSet", "retainAll"));
        }
        boolean removed = false;
        for (int i = this.size() - 1; i >= 0; --i) {
            Object o = this.get(i);
            if (c.contains(o)) continue;
            removed |= this.remove(o);
        }
        return removed;
    }

    @Override
    @NotNull
    public List<T> subList(int fromIndex, int toIndex) {
        throw new IncorrectOperationException();
    }

    @Override
    public boolean contains(Object o) {
        return this.myHashSet.contains(o);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/containers/OrderedSet", "addAll"));
        }
        boolean result = false;
        for (T t : c) {
            result |= this.add(t);
        }
        return result;
    }

    @Override
    public boolean add(T o) {
        if (this.myHashSet.add(o)) {
            super.add(o);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (this.myHashSet.remove(o)) {
            super.remove(o);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.myHashSet.clear();
        super.clear();
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends T> c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/containers/OrderedSet", "addAll"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public T set(int index, @NotNull T element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/containers/OrderedSet", "set"));
        }
        T removed = this.remove(index);
        this.add(index, element);
        return removed;
    }

    @Override
    public void add(int index, @NotNull T element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/containers/OrderedSet", "add"));
        }
        if (this.myHashSet.add(element)) {
            super.add(index, element);
        }
    }

    @Override
    public T remove(int index) {
        Object t = super.remove(index);
        this.myHashSet.remove(t);
        return (T)t;
    }

    @Override
    public int indexOf(Object o) {
        int index = this.myHashSet.index(o);
        return index >= 0 ? super.indexOf(this.myHashSet.get(index)) : -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        int index = this.myHashSet.index(o);
        return index >= 0 ? super.lastIndexOf(this.myHashSet.get(index)) : -1;
    }
}

