/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.icns;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.sanselan.ImageFormat;
import org.apache.sanselan.ImageInfo;
import org.apache.sanselan.ImageParser;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.common.BinaryOutputStream;
import org.apache.sanselan.common.IImageMetadata;
import org.apache.sanselan.common.byteSources.ByteSource;
import org.apache.sanselan.formats.icns.IcnsDecoder;
import org.apache.sanselan.formats.icns.IcnsType;
import org.apache.sanselan.util.Debug;
import org.apache.sanselan.util.ParamMap;

public class IcnsImageParser
extends ImageParser {
    public static final int ICNS_MAGIC = IcnsType.typeAsInt("icns");
    private static final String DEFAULT_EXTENSION = ".icns";
    private static final String[] ACCEPTED_EXTENSIONS = new String[]{".icns"};

    public IcnsImageParser() {
        super.setByteOrder(77);
    }

    @Override
    public String getName() {
        return "icns-Custom";
    }

    @Override
    public String getDefaultExtension() {
        return DEFAULT_EXTENSION;
    }

    @Override
    protected String[] getAcceptedExtensions() {
        return ACCEPTED_EXTENSIONS;
    }

    @Override
    protected ImageFormat[] getAcceptedTypes() {
        return new ImageFormat[]{ImageFormat.IMAGE_FORMAT_ICNS};
    }

    @Override
    public boolean embedICCProfile(File src, File dst, byte[] profile) {
        return false;
    }

    @Override
    public IImageMetadata getMetadata(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        return null;
    }

    @Override
    public ImageInfo getImageInfo(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        params = params == null ? new HashMap() : new HashMap(params);
        boolean verbose = ParamMap.getParamBoolean(params, "VERBOSE", false);
        if (params.containsKey("VERBOSE")) {
            params.remove("VERBOSE");
        }
        if (params.size() > 0) {
            Object firstKey = params.keySet().iterator().next();
            throw new ImageReadException("Unknown parameter: " + firstKey);
        }
        IcnsContents contents = this.readImage(byteSource);
        ArrayList images = IcnsDecoder.decodeAllImages(contents.icnsElements);
        if (images.isEmpty()) {
            throw new ImageReadException("No icons in ICNS file");
        }
        BufferedImage image0 = (BufferedImage)images.get(0);
        return new ImageInfo("Icns", 32, new ArrayList(), ImageFormat.IMAGE_FORMAT_ICNS, "ICNS Apple Icon Image", image0.getHeight(), "image/x-icns", images.size(), 0, 0.0f, 0, 0.0f, image0.getWidth(), false, true, false, 2, "Unknown");
    }

    @Override
    public Dimension getImageSize(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        params = params == null ? new HashMap() : new HashMap(params);
        boolean verbose = ParamMap.getParamBoolean(params, "VERBOSE", false);
        if (params.containsKey("VERBOSE")) {
            params.remove("VERBOSE");
        }
        if (params.size() > 0) {
            Object firstKey = params.keySet().iterator().next();
            throw new ImageReadException("Unknown parameter: " + firstKey);
        }
        IcnsContents contents = this.readImage(byteSource);
        ArrayList images = IcnsDecoder.decodeAllImages(contents.icnsElements);
        if (images.isEmpty()) {
            throw new ImageReadException("No icons in ICNS file");
        }
        BufferedImage image0 = (BufferedImage)images.get(0);
        return new Dimension(image0.getWidth(), image0.getHeight());
    }

    @Override
    public byte[] getICCProfileBytes(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        return null;
    }

    private IcnsHeader readIcnsHeader(InputStream is) throws ImageReadException, IOException {
        int Magic = this.read4Bytes("Magic", is, "Not a Valid ICNS File");
        int FileSize = this.read4Bytes("FileSize", is, "Not a Valid ICNS File");
        if (Magic != ICNS_MAGIC) {
            throw new ImageReadException("Not a Valid ICNS File: magic is 0x" + Integer.toHexString(Magic));
        }
        return new IcnsHeader(Magic, FileSize);
    }

    private IcnsElement readIcnsElement(InputStream is) throws ImageReadException, IOException {
        int type = this.read4Bytes("Type", is, "Not a Valid ICNS File");
        int elementSize = this.read4Bytes("ElementSize", is, "Not a Valid ICNS File");
        byte[] data = this.readByteArray("Data", elementSize - 8, is, "Not a Valid ICNS File");
        return new IcnsElement(type, elementSize, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IcnsContents readImage(ByteSource byteSource) throws ImageReadException, IOException {
        InputStream is = null;
        try {
            IcnsElement icnsElement;
            is = byteSource.getInputStream();
            IcnsHeader icnsHeader = this.readIcnsHeader(is);
            ArrayList<IcnsElement> icnsElementList = new ArrayList<IcnsElement>();
            for (int remainingSize = icnsHeader.fileSize - 8; remainingSize > 0; remainingSize -= icnsElement.elementSize) {
                icnsElement = this.readIcnsElement(is);
                icnsElementList.add(icnsElement);
            }
            IcnsElement[] icnsElements = new IcnsElement[icnsElementList.size()];
            for (int i = 0; i < icnsElements.length; ++i) {
                icnsElements[i] = (IcnsElement)icnsElementList.get(i);
            }
            IcnsContents icnsContents = new IcnsContents(icnsHeader, icnsElements);
            return icnsContents;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e) {
                Debug.debug(e);
            }
        }
    }

    @Override
    public boolean dumpImageFile(PrintWriter pw, ByteSource byteSource) throws ImageReadException, IOException {
        IcnsContents icnsContents = this.readImage(byteSource);
        icnsContents.icnsHeader.dump(pw);
        for (int i = 0; i < icnsContents.icnsElements.length; ++i) {
            icnsContents.icnsElements[i].dump(pw);
        }
        return true;
    }

    @Override
    public final BufferedImage getBufferedImage(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        IcnsContents icnsContents = this.readImage(byteSource);
        ArrayList result = IcnsDecoder.decodeAllImages(icnsContents.icnsElements);
        if (result.size() > 0) {
            return (BufferedImage)result.get(0);
        }
        throw new ImageReadException("No icons in ICNS file");
    }

    @Override
    public ArrayList getAllBufferedImages(ByteSource byteSource) throws ImageReadException, IOException {
        IcnsContents icnsContents = this.readImage(byteSource);
        return IcnsDecoder.decodeAllImages(icnsContents.icnsElements);
    }

    @Override
    public void writeImage(BufferedImage src, OutputStream os, Map params) throws ImageWriteException, IOException {
        IcnsType imageType;
        HashMap hashMap = params = params == null ? new HashMap() : new HashMap(params);
        if (params.containsKey("FORMAT")) {
            params.remove("FORMAT");
        }
        if (params.size() > 0) {
            Object firstKey = params.keySet().iterator().next();
            throw new ImageWriteException("Unknown parameter: " + firstKey);
        }
        if (src.getWidth() == 16 && src.getHeight() == 16) {
            imageType = IcnsType.ICNS_16x16_32BIT_IMAGE;
        } else if (src.getWidth() == 32 && src.getHeight() == 32) {
            imageType = IcnsType.ICNS_32x32_32BIT_IMAGE;
        } else if (src.getWidth() == 48 && src.getHeight() == 48) {
            imageType = IcnsType.ICNS_48x48_32BIT_IMAGE;
        } else if (src.getWidth() == 128 && src.getHeight() == 128) {
            imageType = IcnsType.ICNS_128x128_32BIT_IMAGE;
        } else {
            throw new ImageWriteException("Invalid/unsupported source width " + src.getWidth() + " and height " + src.getHeight());
        }
        BinaryOutputStream bos = new BinaryOutputStream(os, 77);
        bos.write4Bytes(ICNS_MAGIC);
        bos.write4Bytes(16 + 4 * imageType.getWidth() * imageType.getHeight() + 4 + 4 + imageType.getWidth() * imageType.getHeight());
        bos.write4Bytes(imageType.getType());
        bos.write4Bytes(8 + 4 * imageType.getWidth() * imageType.getHeight());
        for (int y = 0; y < src.getHeight(); ++y) {
            for (int x = 0; x < src.getWidth(); ++x) {
                int argb = src.getRGB(x, y);
                bos.write(0);
                bos.write(argb >> 16);
                bos.write(argb >> 8);
                bos.write(argb);
            }
        }
        IcnsType maskType = IcnsType.find8BPPMaskType(imageType);
        bos.write4Bytes(maskType.getType());
        bos.write4Bytes(8 + imageType.getWidth() * imageType.getWidth());
        for (int y = 0; y < src.getHeight(); ++y) {
            for (int x = 0; x < src.getWidth(); ++x) {
                int argb = src.getRGB(x, y);
                bos.write(argb >> 24);
            }
        }
    }

    @Override
    public String getXmpXml(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        return null;
    }

    private static class IcnsContents {
        public final IcnsHeader icnsHeader;
        public final IcnsElement[] icnsElements;

        public IcnsContents(IcnsHeader icnsHeader, IcnsElement[] icnsElements) {
            this.icnsHeader = icnsHeader;
            this.icnsElements = icnsElements;
        }
    }

    public static class IcnsElement {
        public final int type;
        public final int elementSize;
        public final byte[] data;

        public IcnsElement(int type, int elementSize, byte[] data) {
            this.type = type;
            this.elementSize = elementSize;
            this.data = data;
        }

        public void dump(PrintWriter pw) {
            pw.println("IcnsElement");
            IcnsType icnsType = IcnsType.findAnyType(this.type);
            String typeDescription = icnsType == null ? "" : " " + icnsType.toString();
            pw.println("Type: 0x" + Integer.toHexString(this.type) + " (" + IcnsType.describeType(this.type) + ")" + typeDescription);
            pw.println("ElementSize: " + this.elementSize);
            pw.println("");
        }
    }

    private static class IcnsHeader {
        public final int magic;
        public final int fileSize;

        public IcnsHeader(int magic, int fileSize) {
            this.magic = magic;
            this.fileSize = fileSize;
        }

        public void dump(PrintWriter pw) {
            pw.println("IcnsHeader");
            pw.println("Magic: 0x" + Integer.toHexString(this.magic) + " (" + IcnsType.describeType(this.magic) + ")");
            pw.println("FileSize: " + this.fileSize);
            pw.println("");
        }
    }
}

