/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.util;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ICC_Profile;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

public final class Debug {
    private static long counter = 0L;
    public static String newline = "\r\n";
    private static final SimpleDateFormat timestamp = new SimpleDateFormat("yyyy-MM-dd kk:mm:ss:SSS");

    public static void debug(String message) {
        System.out.println(message);
    }

    public static void debug(Object o) {
        System.out.println(o == null ? "null" : o.toString());
    }

    public static String getDebug(String message) {
        return message;
    }

    public static void debug() {
        Debug.newline();
    }

    public static void newline() {
        System.out.print(newline);
    }

    public static String getDebug(String message, int value) {
        return Debug.getDebug(message + ": " + value);
    }

    public static String getDebug(String message, double value) {
        return Debug.getDebug(message + ": " + value);
    }

    public static String getDebug(String message, String value) {
        return Debug.getDebug(message + " " + value);
    }

    public static String getDebug(String message, long value) {
        return Debug.getDebug(message + " " + Long.toString(value));
    }

    public static String getDebug(String message, int[] v) {
        StringBuffer result = new StringBuffer();
        if (v == null) {
            result.append(message + " (" + null + ")" + newline);
        } else {
            result.append(message + " (" + v.length + ")" + newline);
            for (int i = 0; i < v.length; ++i) {
                result.append("\t" + v[i] + newline);
            }
            result.append(newline);
        }
        return result.toString();
    }

    public static String getDebug(String message, byte[] v) {
        int max = 250;
        return Debug.getDebug(message, v, 250);
    }

    public static String getDebug(String message, byte[] v, int max) {
        StringBuffer result = new StringBuffer();
        if (v == null) {
            result.append(message + " (" + null + ")" + newline);
        } else {
            result.append(message + " (" + v.length + ")" + newline);
            for (int i = 0; i < max && i < v.length; ++i) {
                int b = 0xFF & v[i];
                char c = b == 0 || b == 10 || b == 11 || b == 13 ? (char)' ' : (char)((char)b);
                result.append("\t" + i + ": " + b + " (" + c + ", 0x" + Integer.toHexString(b) + ")" + newline);
            }
            if (v.length > max) {
                result.append("\t..." + newline);
            }
            result.append(newline);
        }
        return result.toString();
    }

    public static String getDebug(String message, char[] v) {
        StringBuffer result = new StringBuffer();
        if (v == null) {
            result.append(Debug.getDebug(message + " (" + null + ")") + newline);
        } else {
            result.append(Debug.getDebug(message + " (" + v.length + ")") + newline);
            for (int i = 0; i < v.length; ++i) {
                result.append(Debug.getDebug("\t" + v[i] + " (" + (0xFF & v[i])) + ")" + newline);
            }
            result.append(newline);
        }
        return result.toString();
    }

    public static String getDebug(String message, List v) {
        StringBuffer result = new StringBuffer();
        String suffix = " [" + counter++ + "]";
        result.append(Debug.getDebug(message + " (" + v.size() + ")" + suffix) + newline);
        for (int i = 0; i < v.size(); ++i) {
            result.append(Debug.getDebug("\t" + v.get(i).toString() + suffix) + newline);
        }
        result.append(newline);
        return result.toString();
    }

    public static void debug(String message, Map map) {
        Debug.debug(Debug.getDebug(message, map));
    }

    public static String getDebug(String message, Map map) {
        StringBuffer result = new StringBuffer();
        if (map == null) {
            return Debug.getDebug(message + " map: " + null);
        }
        ArrayList keys = new ArrayList(map.keySet());
        result.append(Debug.getDebug(message + " map: " + keys.size()) + newline);
        for (int i = 0; i < keys.size(); ++i) {
            Object key = keys.get(i);
            Object value = map.get(key);
            result.append(Debug.getDebug("\t" + i + ": '" + key + "' -> '" + value + "'") + newline);
        }
        result.append(newline);
        return result.toString();
    }

    public static boolean compare(String prefix, Map a, Map b) {
        return Debug.compare(prefix, a, b, null, null);
    }

    private static void log(StringBuffer buffer, String s) {
        Debug.debug(s);
        if (buffer != null) {
            buffer.append(s + newline);
        }
    }

    public static boolean compare(String prefix, Map a, Map b, ArrayList ignore, StringBuffer buffer) {
        Object key;
        int i;
        if (a == null && b == null) {
            Debug.log(buffer, prefix + " both maps null");
            return true;
        }
        if (a == null) {
            Debug.log(buffer, prefix + " map a: null, map b: map");
            return false;
        }
        if (b == null) {
            Debug.log(buffer, prefix + " map a: map, map b: null");
            return false;
        }
        ArrayList keys_a = new ArrayList(a.keySet());
        ArrayList keys_b = new ArrayList(b.keySet());
        if (ignore != null) {
            keys_a.removeAll(ignore);
            keys_b.removeAll(ignore);
        }
        boolean result = true;
        for (i = 0; i < keys_a.size(); ++i) {
            key = keys_a.get(i);
            if (!keys_b.contains(key)) {
                Debug.log(buffer, prefix + "b is missing key '" + key + "' from a");
                result = false;
                continue;
            }
            keys_b.remove(key);
            Object value_a = a.get(key);
            Object value_b = b.get(key);
            if (value_a.equals(value_b)) continue;
            Debug.log(buffer, prefix + "key(" + key + ") value a: " + value_a + ") !=  b: " + value_b + ")");
            result = false;
        }
        for (i = 0; i < keys_b.size(); ++i) {
            key = keys_b.get(i);
            Debug.log(buffer, prefix + "a is missing key '" + key + "' from b");
            result = false;
        }
        if (result) {
            Debug.log(buffer, prefix + "a is the same as  b");
        }
        return result;
    }

    private static final String byteQuadToString(int bytequad) {
        byte b1 = (byte)(bytequad >> 24 & 0xFF);
        byte b2 = (byte)(bytequad >> 16 & 0xFF);
        byte b3 = (byte)(bytequad >> 8 & 0xFF);
        byte b4 = (byte)(bytequad >> 0 & 0xFF);
        char c1 = (char)b1;
        char c2 = (char)b2;
        char c3 = (char)b3;
        char c4 = (char)b4;
        StringBuffer fStringBuffer = new StringBuffer();
        fStringBuffer.append(new String(new char[]{c1, c2, c3, c4}));
        fStringBuffer.append(" bytequad: " + bytequad);
        fStringBuffer.append(" b1: " + b1);
        fStringBuffer.append(" b2: " + b2);
        fStringBuffer.append(" b3: " + b3);
        fStringBuffer.append(" b4: " + b4);
        return fStringBuffer.toString();
    }

    public static String getDebug(String message, ICC_Profile value) {
        StringBuffer result = new StringBuffer();
        result.append(Debug.getDebug("ICC_Profile " + message + ": " + (value == null ? "null" : value.toString())) + newline);
        if (value != null) {
            result.append(Debug.getDebug("\t getProfileClass: " + Debug.byteQuadToString(value.getProfileClass())) + newline);
            result.append(Debug.getDebug("\t getPCSType: " + Debug.byteQuadToString(value.getPCSType())) + newline);
            result.append(Debug.getDebug("\t getColorSpaceType() : " + Debug.byteQuadToString(value.getColorSpaceType())) + newline);
        }
        return result.toString();
    }

    public static String getDebug(String message, boolean value) {
        return Debug.getDebug(message + " " + (value ? "true" : "false"));
    }

    public static String getDebug(String message, File file) {
        return Debug.getDebug(message + ": " + (file == null ? "null" : file.getPath()));
    }

    public static String getDebug(String message, Date value) {
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        return Debug.getDebug(message, value == null ? "null" : df.format(value));
    }

    public static String getDebug(String message, Calendar value) {
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        return Debug.getDebug(message, value == null ? "null" : df.format(value.getTime()));
    }

    public static void debug(String message, Object value) {
        if (value == null) {
            Debug.debug(message, "null");
        } else if (value instanceof char[]) {
            Debug.debug(message, (char[])value);
        } else if (value instanceof byte[]) {
            Debug.debug(message, (byte[])value);
        } else if (value instanceof int[]) {
            Debug.debug(message, (int[])value);
        } else if (value instanceof String) {
            Debug.debug(message, (String)value);
        } else if (value instanceof List) {
            Debug.debug(message, (List)value);
        } else if (value instanceof Map) {
            Debug.debug(message, (Map)value);
        } else if (value instanceof ICC_Profile) {
            Debug.debug(message, (ICC_Profile)value);
        } else if (value instanceof File) {
            Debug.debug(message, (File)value);
        } else if (value instanceof Date) {
            Debug.debug(message, (Date)value);
        } else if (value instanceof Calendar) {
            Debug.debug(message, (Calendar)value);
        } else {
            Debug.debug(message, value.toString());
        }
    }

    public static void debug(String message, Object[] value) {
        if (value == null) {
            Debug.debug(message, "null");
        } else {
            Debug.debug(message, value.length);
            int max = 10;
            for (int i = 0; i < value.length && i < 10; ++i) {
                Debug.debug("\t" + i, value[i]);
            }
            if (value.length > 10) {
                Debug.debug("\t...");
            }
        }
        Debug.debug();
    }

    public static String getDebug(String message, Object value) {
        if (value == null) {
            return Debug.getDebug(message, "null");
        }
        if (value instanceof Calendar) {
            return Debug.getDebug(message, (Calendar)value);
        }
        if (value instanceof Date) {
            return Debug.getDebug(message, (Date)value);
        }
        if (value instanceof File) {
            return Debug.getDebug(message, (File)value);
        }
        if (value instanceof ICC_Profile) {
            return Debug.getDebug(message, (ICC_Profile)value);
        }
        if (value instanceof Map) {
            return Debug.getDebug(message, (Map)value);
        }
        if (value instanceof Map) {
            return Debug.getDebug(message, (Map)value);
        }
        if (value instanceof String) {
            return Debug.getDebug(message, (String)value);
        }
        if (value instanceof byte[]) {
            return Debug.getDebug(message, (byte[])value);
        }
        if (value instanceof char[]) {
            return Debug.getDebug(message, (char[])value);
        }
        if (value instanceof int[]) {
            return Debug.getDebug(message, (int[])value);
        }
        if (value instanceof List) {
            return Debug.getDebug(message, (List)value);
        }
        return Debug.getDebug(message, value.toString());
    }

    public static String getType(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof Object[]) {
            return "[Object[]: " + ((Object[])value).length + "]";
        }
        if (value instanceof char[]) {
            return "[char[]: " + ((char[])value).length + "]";
        }
        if (value instanceof byte[]) {
            return "[byte[]: " + ((byte[])value).length + "]";
        }
        if (value instanceof short[]) {
            return "[short[]: " + ((short[])value).length + "]";
        }
        if (value instanceof int[]) {
            return "[int[]: " + ((int[])value).length + "]";
        }
        if (value instanceof long[]) {
            return "[long[]: " + ((long[])value).length + "]";
        }
        if (value instanceof float[]) {
            return "[float[]: " + ((float[])value).length + "]";
        }
        if (value instanceof double[]) {
            return "[double[]: " + ((double[])value).length + "]";
        }
        if (value instanceof boolean[]) {
            return "[boolean[]: " + ((boolean[])value).length + "]";
        }
        return value.getClass().getName();
    }

    public static boolean isArray(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Object[]) {
            return true;
        }
        if (value instanceof char[]) {
            return true;
        }
        if (value instanceof byte[]) {
            return true;
        }
        if (value instanceof short[]) {
            return true;
        }
        if (value instanceof int[]) {
            return true;
        }
        if (value instanceof long[]) {
            return true;
        }
        if (value instanceof float[]) {
            return true;
        }
        if (value instanceof double[]) {
            return true;
        }
        return value instanceof boolean[];
    }

    public static String getDebug(String message, Object[] value) {
        StringBuffer result = new StringBuffer();
        if (value == null) {
            result.append(Debug.getDebug(message, "null") + newline);
        } else {
            result.append(Debug.getDebug(message, value.length));
            int max = 10;
            for (int i = 0; i < value.length && i < 10; ++i) {
                result.append(Debug.getDebug("\t" + i, value[i]) + newline);
            }
            if (value.length > 10) {
                result.append(Debug.getDebug("\t...") + newline);
            }
        }
        result.append(newline);
        return result.toString();
    }

    public static String getDebug(Class fClass, Throwable e) {
        return Debug.getDebug(fClass == null ? "[Unknown]" : fClass.getName(), e);
    }

    public static void debug(Class fClass, Throwable e) {
        Debug.debug(fClass.getName(), e);
    }

    public static void debug(String message, boolean value) {
        Debug.debug(message + " " + (value ? "true" : "false"));
    }

    public static void debug(String message, byte[] v) {
        Debug.debug(Debug.getDebug(message, v));
    }

    public static void debug(String message, char[] v) {
        Debug.debug(Debug.getDebug(message, v));
    }

    public static void debug(String message, Calendar value) {
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        Debug.debug(message, value == null ? "null" : df.format(value.getTime()));
    }

    public static void debug(String message, Date value) {
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        Debug.debug(message, value == null ? "null" : df.format(value));
    }

    public static void debug(String message, double value) {
        Debug.debug(message + ": " + value);
    }

    public static void debug(String message, File file) {
        Debug.debug(message + ": " + (file == null ? "null" : file.getPath()));
    }

    public static void debug(String message, ICC_Profile value) {
        Debug.debug("ICC_Profile " + message + ": " + (value == null ? "null" : value.toString()));
        if (value != null) {
            Debug.debug("\t getProfileClass: " + Debug.byteQuadToString(value.getProfileClass()));
            Debug.debug("\t getPCSType: " + Debug.byteQuadToString(value.getPCSType()));
            Debug.debug("\t getColorSpaceType() : " + Debug.byteQuadToString(value.getColorSpaceType()));
        }
    }

    public static void debug(String message, int value) {
        Debug.debug(message + ": " + value);
    }

    public static void debug(String message, int[] v) {
        Debug.debug(Debug.getDebug(message, v));
    }

    public static void debug(String message, byte[] v, int max) {
        Debug.debug(Debug.getDebug(message, v, max));
    }

    public static void debug(String message, List v) {
        String suffix = " [" + counter++ + "]";
        Debug.debug(message + " (" + v.size() + ")" + suffix);
        for (int i = 0; i < v.size(); ++i) {
            Debug.debug("\t" + v.get(i).toString() + suffix);
        }
        Debug.debug();
    }

    public static void debug(String message, long value) {
        Debug.debug(message + " " + Long.toString(value));
    }

    public static void debug(String prefix, Point p) {
        System.out.println(prefix + ": " + (p == null ? "null" : p.x + ", " + p.y));
    }

    public static void debug(String prefix, Rectangle r) {
        Debug.debug(Debug.getDebug(prefix, r));
    }

    public static void debug(String message, String value) {
        Debug.debug(message + " " + value);
    }

    public static void debug(String message, Throwable e) {
        Debug.debug(Debug.getDebug(message, e));
    }

    public static void debug(Throwable e) {
        Debug.debug(Debug.getDebug(e));
    }

    public static void debug(Throwable e, int value) {
        Debug.debug(Debug.getDebug(e, value));
    }

    public static void dumpStack() {
        Debug.debug(Debug.getStackTrace(new Exception("Stack trace"), -1, 1));
    }

    public static void dumpStack(int limit) {
        Debug.debug(Debug.getStackTrace(new Exception("Stack trace"), limit, 1));
    }

    public static String getDebug(String message, Throwable e) {
        return message + newline + Debug.getDebug(e);
    }

    public static String getDebug(Throwable e) {
        return Debug.getDebug(e, -1);
    }

    public static String getDebug(Throwable e, int max) {
        StringBuffer result = new StringBuffer();
        String datetime = timestamp.format(new Date()).toLowerCase();
        result.append(newline);
        result.append("Throwable: " + (e == null ? "" : "(" + e.getClass().getName() + ")") + ":" + datetime + newline);
        result.append("Throwable: " + (e == null ? "null" : e.getLocalizedMessage()) + newline);
        result.append(newline);
        result.append(Debug.getStackTrace(e, max));
        result.append("Caught here:" + newline);
        result.append(Debug.getStackTrace(new Exception(), max, 1));
        result.append(newline);
        return result.toString();
    }

    public static String getStackTrace(Throwable e) {
        return Debug.getStackTrace(e, -1);
    }

    public static String getStackTrace(Throwable e, int limit) {
        return Debug.getStackTrace(e, limit, 0);
    }

    public static String getStackTrace(Throwable e, int limit, int skip) {
        StringBuffer result = new StringBuffer();
        if (e != null) {
            StackTraceElement[] stes = e.getStackTrace();
            if (stes != null) {
                for (int i = skip; i < stes.length && (limit < 0 || i < limit); ++i) {
                    StackTraceElement ste = stes[i];
                    result.append("\tat " + ste.getClassName() + "." + ste.getMethodName() + "(" + ste.getFileName() + ":" + ste.getLineNumber() + ")" + newline);
                }
                if (limit >= 0 && stes.length > limit) {
                    result.append("\t..." + newline);
                }
            }
            result.append(newline);
        }
        return result.toString();
    }

    public static void debugByteQuad(String message, int i) {
        int alpha = i >> 24 & 0xFF;
        int red = i >> 16 & 0xFF;
        int green = i >> 8 & 0xFF;
        int blue = i >> 0 & 0xFF;
        System.out.println(message + ": " + "alpha: " + alpha + ", " + "red: " + red + ", " + "green: " + green + ", " + "blue: " + blue);
    }

    public static void debugIPQuad(String message, int i) {
        int b1 = i >> 24 & 0xFF;
        int b2 = i >> 16 & 0xFF;
        int b3 = i >> 8 & 0xFF;
        int b4 = i >> 0 & 0xFF;
        System.out.println(message + ": " + "b1: " + b1 + ", " + "b2: " + b2 + ", " + "b3: " + b3 + ", " + "b4: " + b4);
    }

    public static void debugIPQuad(String message, byte[] bytes) {
        System.out.print(message + ": ");
        if (bytes == null) {
            System.out.print("null");
        } else {
            for (int i = 0; i < bytes.length; ++i) {
                if (i > 0) {
                    System.out.print(".");
                }
                System.out.print(0xFF & bytes[i]);
            }
        }
        System.out.println();
    }

    public static String getDebug(String prefix, Dimension r) {
        String s_ar1 = "null";
        String s_ar2 = "null";
        if (r != null) {
            double aspect_ratio = (double)r.width / (double)r.height;
            double aspect_ratio2 = 1.0 / aspect_ratio;
            s_ar1 = "" + aspect_ratio;
            s_ar2 = "" + aspect_ratio2;
            if (s_ar1.length() > 7) {
                s_ar1 = s_ar1.substring(0, 7);
            }
            if (s_ar2.length() > 7) {
                s_ar2 = s_ar2.substring(0, 7);
            }
        }
        return prefix + ": " + (r == null ? "null" : r.width + "x" + r.height) + " aspect_ratio: " + s_ar1 + " (" + s_ar2 + ")";
    }

    public static void debug(String prefix, Dimension r) {
        Debug.debug(Debug.getDebug(prefix, r));
    }

    public static String getDebug(String prefix, Rectangle r) {
        String s_ar1 = "null";
        String s_ar2 = "null";
        if (r != null) {
            double aspect_ratio = (double)r.width / (double)r.height;
            double aspect_ratio2 = 1.0 / aspect_ratio;
            s_ar1 = "" + aspect_ratio;
            s_ar2 = "" + aspect_ratio2;
            if (s_ar1.length() > 7) {
                s_ar1 = s_ar1.substring(0, 7);
            }
            if (s_ar2.length() > 7) {
                s_ar2 = s_ar2.substring(0, 7);
            }
        }
        return prefix + ": " + (r == null ? "null" : r.x + "x" + r.y + "," + r.width + "x" + r.height) + " aspect_ratio: " + s_ar1 + " (" + s_ar2 + ")";
    }

    public static String getDebug(String prefix, Point p) {
        return prefix + ": " + (p == null ? "null" : p.x + ", " + p.y);
    }

    public static void dump(String prefix, Object value) {
        if (value == null) {
            Debug.debug(prefix, "null");
        } else if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            Debug.debug(prefix, array);
            for (int i = 0; i < array.length; ++i) {
                Debug.dump(prefix + "\t" + i + ": ", array[i]);
            }
        } else if (value instanceof int[]) {
            int[] array = (int[])value;
            Debug.debug(prefix, array);
            for (int i = 0; i < array.length; ++i) {
                Debug.debug(prefix + "\t" + i + ": ", array[i]);
            }
        } else if (value instanceof char[]) {
            char[] array = (char[])value;
            Debug.debug(prefix, "[" + new String(array) + "]");
        } else if (value instanceof long[]) {
            long[] array = (long[])value;
            Debug.debug(prefix, (Object)array);
            for (int i = 0; i < array.length; ++i) {
                Debug.debug(prefix + "\t" + i + ": ", array[i]);
            }
        } else if (value instanceof boolean[]) {
            boolean[] array = (boolean[])value;
            Debug.debug(prefix, (Object)array);
            for (int i = 0; i < array.length; ++i) {
                Debug.debug(prefix + "\t" + i + ": ", array[i]);
            }
        } else if (value instanceof byte[]) {
            byte[] array = (byte[])value;
            Debug.debug(prefix, array);
            for (int i = 0; i < array.length; ++i) {
                Debug.debug(prefix + "\t" + i + ": ", (int)array[i]);
            }
        } else if (value instanceof float[]) {
            float[] array = (float[])value;
            Debug.debug(prefix, (Object)array);
            for (int i = 0; i < array.length; ++i) {
                Debug.debug(prefix + "\t" + i + ": ", array[i]);
            }
        } else if (value instanceof byte[]) {
            double[] array = (double[])value;
            Debug.debug(prefix, (Object)array);
            for (int i = 0; i < array.length; ++i) {
                Debug.debug(prefix + "\t" + i + ": ", array[i]);
            }
        } else if (value instanceof List) {
            List list = (List)value;
            Debug.debug(prefix, "list");
            for (int i = 0; i < list.size(); ++i) {
                Debug.dump(prefix + "\t" + "list: " + i + ": ", list.get(i));
            }
        } else if (value instanceof Map) {
            Map map = (Map)value;
            Debug.debug(prefix, "map");
            ArrayList keys = new ArrayList(map.keySet());
            Collections.sort(keys);
            for (int i = 0; i < keys.size(); ++i) {
                Object key = keys.get(i);
                Debug.dump(prefix + "\t" + "map: " + key + " -> ", map.get(key));
            }
        } else {
            Debug.debug(prefix, value.toString());
            Debug.debug(prefix + "\t", value.getClass().getName());
        }
    }

    public static final void purgeMemory() {
        try {
            System.runFinalization();
            Thread.sleep(50L);
            System.gc();
            Thread.sleep(50L);
        }
        catch (Throwable e) {
            Debug.debug(e);
        }
    }
}

