/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.auth;

import java.io.File;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;

public class SVNSSLAuthentication
extends SVNAuthentication {
    public static final String MSCAPI = "MSCAPI";
    public static final String SSL = "SSL";
    private File myCertificate;
    private String myPassword;
    private String mySSLKind;
    private String myAlias;
    private String myCertificatePath;

    public SVNSSLAuthentication(File certFile, String password, boolean storageAllowed) {
        this(certFile, password, storageAllowed, null, false);
    }

    public SVNSSLAuthentication(File certFile, String password, boolean storageAllowed, SVNURL url, boolean isPartial) {
        super("svn.ssl.client-passphrase", null, storageAllowed, url, isPartial);
        this.myCertificate = certFile;
        this.myPassword = password;
        this.mySSLKind = SSL;
    }

    public SVNSSLAuthentication(String sslKind, String alias, boolean storageAllowed, SVNURL url, boolean isPartial) {
        this((File)null, null, storageAllowed, url, isPartial);
        this.mySSLKind = sslKind;
        this.myAlias = alias;
    }

    public String getPassword() {
        return this.myPassword;
    }

    public File getCertificateFile() {
        return this.myCertificate;
    }

    public String getSSLKind() {
        return this.mySSLKind;
    }

    public String getAlias() {
        return this.myAlias;
    }

    public String getCertificatePath() {
        if (this.myCertificatePath != null) {
            return this.myCertificatePath;
        }
        return this.myCertificate.getAbsolutePath();
    }

    public void setCertificatePath(String path) {
        this.myCertificatePath = path;
    }

    public static boolean isCertificatePath(String path) {
        return SVNFileType.getType(new File(path)) == SVNFileType.FILE;
    }
}

