/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.tools.lint.detector.api.XmlContext;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AndroidTvDetector
extends Detector
implements Detector.XmlScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(AndroidTvDetector.class, Scope.MANIFEST_SCOPE);
    public static final Issue UNSUPPORTED_TV_HARDWARE = Issue.create("UnsupportedTvHardware", "Unsupported TV Hardware Feature", "The <uses-feature> element should not require this unsupported TV hardware feature. Any uses-feature not explicitly marked with required=\"false\" is necessary on the device to be installed on. Ensure that any features that might prevent it from being installed on a TV device are reviewed and marked as not required in the manifest.", Category.CORRECTNESS, 6, Severity.ERROR, IMPLEMENTATION).addMoreInfo("https://developer.android.com/training/tv/start/hardware.html#unsupported-features");
    public static final Issue MISSING_LEANBACK_LAUNCHER = Issue.create("MissingLeanbackLauncher", "Missing Leanback Launcher Intent Filter.", "An application intended to run on TV devices must declare a launcher activity for TV in its manifest using a `android.intent.category.LEANBACK_LAUNCHER` intent filter.", Category.CORRECTNESS, 8, Severity.ERROR, IMPLEMENTATION).addMoreInfo("https://developer.android.com/training/tv/start/start.html#tv-activity");
    public static final Issue MISSING_LEANBACK_SUPPORT = Issue.create("MissingLeanbackSupport", "Missing Leanback Support.", "The manifest should declare the use of the Leanback user interface required by Android TV.\nTo fix this, add\n`<uses-feature android:name=\"android.software.leanback\"   android:required=\"false\" />`\nto your manifest.", Category.CORRECTNESS, 6, Severity.ERROR, IMPLEMENTATION).addMoreInfo("https://developer.android.com/training/tv/start/start.html#leanback-req");
    public static final Issue PERMISSION_IMPLIES_UNSUPPORTED_HARDWARE = Issue.create("PermissionImpliesUnsupportedHardware", "Permission Implies Unsupported Hardware", "The <uses-permission> element should not require a permission that implies an unsupported TV hardware feature. Google Play assumes that certain hardware related permissions indicate that the underlying hardware features are required by default. To fix the issue, consider declaring the corresponding uses-feature element with required=\"false\" attribute.", Category.CORRECTNESS, 3, Severity.WARNING, IMPLEMENTATION).addMoreInfo("http://developer.android.com/guide/topics/manifest/uses-feature-element.html#permissions");
    public static final Issue MISSING_BANNER = Issue.create("MissingTvBanner", "TV Missing Banner", "A TV application must provide a home screen banner for each localization if it includes a Leanback launcher intent filter. The banner is the app launch point that appears on the home screen in the apps and games rows.", Category.CORRECTNESS, 5, Severity.WARNING, IMPLEMENTATION).addMoreInfo("http://developer.android.com/training/tv/start/start.html#banner");
    public static final String SOFTWARE_FEATURE_LEANBACK = "android.software.leanback";
    private static final String LEANBACK_LIB_ARTIFACT = "com.android.support:leanback-v17";
    private static final String CATEGORY_LEANBACK_LAUNCHER = "android.intent.category.LEANBACK_LAUNCHER";
    private static final String HARDWARE_FEATURE_CAMERA = "android.hardware.camera";
    private static final String HARDWARE_FEATURE_LOCATION_GPS = "android.hardware.location.gps";
    private static final String ANDROID_HARDWARE_TELEPHONY = "android.hardware.telephony";
    private static final String ANDROID_HARDWARE_BLUETOOTH = "android.hardware.bluetooth";
    private static final String ATTR_BANNER = "banner";
    private static final String ANDROID_HARDWARE_MICROPHONE = "android.hardware.microphone";
    private static final Set<String> UNSUPPORTED_HARDWARE_FEATURES = ImmutableSet.builder().add((Object)"android.hardware.touchscreen").add((Object)"android.hardware.faketouch").add((Object)"android.hardware.telephony").add((Object)"android.hardware.camera").add((Object)"android.hardware.bluetooth").add((Object)"android.hardware.nfc").add((Object)"android.hardware.location.gps").add((Object)"android.hardware.microphone").add((Object)"android.hardware.sensors").build();
    private static final Map<String, String> PERMISSIONS_TO_IMPLIED_UNSUPPORTED_HARDWARE = ImmutableMap.builder().put((Object)"android.permission.BLUETOOTH", (Object)"android.hardware.bluetooth").put((Object)"android.permission.BLUETOOTH_ADMIN", (Object)"android.hardware.bluetooth").put((Object)"android.permission.CAMERA", (Object)"android.hardware.camera").put((Object)"android.permission.RECORD_AUDIO", (Object)"android.hardware.microphone").put((Object)"android.permission.ACCESS_FINE_LOCATION", (Object)"android.hardware.location.gps").put((Object)"android.permission.CALL_PHONE", (Object)"android.hardware.telephony").put((Object)"android.permission.CALL_PRIVILEGED", (Object)"android.hardware.telephony").put((Object)"android.permission.PROCESS_OUTGOING_CALLS", (Object)"android.hardware.telephony").put((Object)"android.permission.READ_SMS", (Object)"android.hardware.telephony").put((Object)"android.permission.RECEIVE_SMS", (Object)"android.hardware.telephony").put((Object)"android.permission.RECEIVE_MMS", (Object)"android.hardware.telephony").put((Object)"android.permission.RECEIVE_WAP_PUSH", (Object)"android.hardware.telephony").put((Object)"android.permission.SEND_SMS", (Object)"android.hardware.telephony").put((Object)"android.permission.WRITE_APN_SETTINGS", (Object)"android.hardware.telephony").put((Object)"android.permission.WRITE_SMS", (Object)"android.hardware.telephony").build();
    private static final String USES_HARDWARE_ERROR_MESSAGE_FORMAT = "Permission exists without corresponding hardware `<uses-feature android:name=\"%1$s\" required=\"false\">` tag.";
    private boolean mHasLeanbackLauncherActivity;
    private boolean mHasLeanbackSupport;
    private boolean mHasLeanbackDependency;
    private boolean mHasApplicationBanner;
    private int mLeanbackActivitiesWithoutBanners;
    private List<String> mUnsupportedHardwareImpliedPermissions;
    private Set<String> mAllUnsupportedTvUsesFeatures;
    private Set<String> mUnsupportedTvUsesFeatures;

    @Override
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Arrays.asList("application", "activity", "uses-feature", "uses-permission");
    }

    @Override
    public void beforeCheckFile(Context context) {
        this.mHasLeanbackLauncherActivity = false;
        this.mHasLeanbackSupport = false;
        this.mHasApplicationBanner = false;
        this.mLeanbackActivitiesWithoutBanners = 0;
        this.mUnsupportedHardwareImpliedPermissions = Lists.newArrayListWithExpectedSize((int)2);
        this.mUnsupportedTvUsesFeatures = Sets.newHashSetWithExpectedSize((int)2);
        this.mAllUnsupportedTvUsesFeatures = Sets.newHashSetWithExpectedSize((int)2);
        Project mainProject = context.getMainProject();
        this.mHasLeanbackDependency = mainProject.isGradleProject() && Boolean.TRUE.equals(mainProject.dependsOn(LEANBACK_LIB_ARTIFACT));
    }

    @Override
    public void afterCheckFile(Context context) {
        boolean isTvApp;
        boolean bl = isTvApp = this.mHasLeanbackSupport || this.mHasLeanbackDependency || this.mHasLeanbackLauncherActivity;
        if (!context.getMainProject().isLibrary() && isTvApp) {
            Node applicationElement;
            Element manifestNode;
            XmlContext xmlContext = (XmlContext)context;
            if (!this.mHasLeanbackLauncherActivity && xmlContext.isEnabled(MISSING_LEANBACK_LAUNCHER) && (manifestNode = xmlContext.document.getDocumentElement()) != null) {
                xmlContext.report(MISSING_LEANBACK_LAUNCHER, manifestNode, xmlContext.getLocation(manifestNode), "Expecting an activity to have `android.intent.category.LEANBACK_LAUNCHER` intent filter.");
            }
            if (!this.mHasLeanbackSupport && xmlContext.isEnabled(MISSING_LEANBACK_SUPPORT) && (manifestNode = xmlContext.document.getDocumentElement()) != null) {
                xmlContext.report(MISSING_LEANBACK_SUPPORT, manifestNode, xmlContext.getLocation(manifestNode), "Expecting <uses-feature android:name=\"android.software.leanback\" android:required=\"false\" /> tag.");
            }
            if (!this.mHasApplicationBanner && this.mLeanbackActivitiesWithoutBanners > 0 && xmlContext.isEnabled(MISSING_BANNER) && (applicationElement = AndroidTvDetector.getApplicationElement(xmlContext.document)) != null) {
                xmlContext.report(MISSING_BANNER, applicationElement, xmlContext.getLocation(applicationElement), "Expecting `android:banner` with the `<application>` tag or each Leanback launcher activity.");
            }
            if (!this.mUnsupportedTvUsesFeatures.isEmpty() && xmlContext.isEnabled(UNSUPPORTED_TV_HARDWARE)) {
                List<Element> usesFeatureElements = AndroidTvDetector.findUsesFeatureElements(this.mUnsupportedTvUsesFeatures, xmlContext.document);
                for (Element element : usesFeatureElements) {
                    Attr attrRequired = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "required");
                    Node location = attrRequired == null ? element : attrRequired;
                    xmlContext.report(UNSUPPORTED_TV_HARDWARE, location, xmlContext.getLocation(location), "Expecting `android:required=\"false\"` for this hardware feature that may not be supported by all Android TVs.");
                }
            }
            if (!this.mUnsupportedHardwareImpliedPermissions.isEmpty() && xmlContext.isEnabled(PERMISSION_IMPLIES_UNSUPPORTED_HARDWARE)) {
                Collection filteredPermissions = Collections2.filter(this.mUnsupportedHardwareImpliedPermissions, (Predicate)new Predicate<String>(){

                    public boolean apply(String input) {
                        String usesFeature = (String)PERMISSIONS_TO_IMPLIED_UNSUPPORTED_HARDWARE.get(input);
                        return usesFeature != null && !AndroidTvDetector.this.mAllUnsupportedTvUsesFeatures.contains(usesFeature);
                    }
                });
                List<Element> permissionsWithoutUsesFeatures = AndroidTvDetector.findPermissionElements(filteredPermissions, xmlContext.document);
                for (Element permissionElement : permissionsWithoutUsesFeatures) {
                    String name = permissionElement.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                    String unsupportedHardwareName = PERMISSIONS_TO_IMPLIED_UNSUPPORTED_HARDWARE.get(name);
                    if (unsupportedHardwareName == null) continue;
                    String message = String.format(USES_HARDWARE_ERROR_MESSAGE_FORMAT, unsupportedHardwareName);
                    xmlContext.report(PERMISSION_IMPLIES_UNSUPPORTED_HARDWARE, permissionElement, xmlContext.getLocation(permissionElement), message);
                }
            }
        }
    }

    private static List<Element> findPermissionElements(Collection<String> permissions, Document document) {
        Element manifestElement = document.getDocumentElement();
        if (manifestElement == null) {
            return Collections.emptyList();
        }
        ArrayList<Element> nodes = new ArrayList<Element>(permissions.size());
        for (Element child : LintUtils.getChildren(manifestElement)) {
            if (!"uses-permission".equals(child.getTagName()) || !permissions.contains(child.getAttributeNS("http://schemas.android.com/apk/res/android", "name"))) continue;
            nodes.add(child);
        }
        return nodes;
    }

    private static List<Element> findUsesFeatureElements(Set<String> featureNames, Document document) {
        Element manifestElement = document.getDocumentElement();
        if (manifestElement == null) {
            return Collections.emptyList();
        }
        ArrayList<Element> nodes = new ArrayList<Element>(featureNames.size());
        for (Element child : LintUtils.getChildren(manifestElement)) {
            if (!"uses-feature".equals(child.getTagName()) || !featureNames.contains(child.getAttributeNS("http://schemas.android.com/apk/res/android", "name"))) continue;
            nodes.add(child);
        }
        return nodes;
    }

    private static Node getApplicationElement(Document document) {
        Element manifestNode = document.getDocumentElement();
        if (manifestNode != null) {
            return AndroidTvDetector.getElementWithTagName("application", manifestNode);
        }
        return null;
    }

    @Override
    public void visitElement(XmlContext context, Element element) {
        String permissionName;
        String elementName = element.getTagName();
        if ("application".equals(elementName)) {
            this.mHasApplicationBanner = element.hasAttributeNS("http://schemas.android.com/apk/res/android", ATTR_BANNER);
        } else if ("uses-feature".equals(elementName)) {
            String featureName;
            Attr name = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
            if (name != null && AndroidTvDetector.isUnsupportedHardwareFeature(featureName = name.getValue())) {
                this.mAllUnsupportedTvUsesFeatures.add(featureName);
                Attr required = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "required");
                if (required == null || Boolean.parseBoolean(required.getValue())) {
                    this.mUnsupportedTvUsesFeatures.add(featureName);
                }
            }
            if (!this.mHasLeanbackSupport && AndroidTvDetector.hasLeanbackSupport(element)) {
                this.mHasLeanbackSupport = true;
            }
        } else if ("activity".equals(elementName) && AndroidTvDetector.hasLeanbackIntentFilter(element)) {
            this.mHasLeanbackLauncherActivity = true;
            if (!element.hasAttributeNS("http://schemas.android.com/apk/res/android", ATTR_BANNER)) {
                ++this.mLeanbackActivitiesWithoutBanners;
            }
        } else if ("uses-permission".equals(elementName) && PERMISSIONS_TO_IMPLIED_UNSUPPORTED_HARDWARE.containsKey(permissionName = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name"))) {
            this.mUnsupportedHardwareImpliedPermissions.add(permissionName);
        }
    }

    private static boolean hasLeanbackSupport(Element element) {
        assert ("uses-feature".equals(element.getTagName())) : element.getTagName();
        return SOFTWARE_FEATURE_LEANBACK.equals(element.getAttributeNS("http://schemas.android.com/apk/res/android", "name"));
    }

    private static boolean isUnsupportedHardwareFeature(String featureName) {
        for (String prefix : UNSUPPORTED_HARDWARE_FEATURES) {
            if (!featureName.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasLeanbackIntentFilter(Node activityNode) {
        assert ("activity".equals(activityNode.getNodeName())) : activityNode.getNodeName();
        for (Element activityChild : LintUtils.getChildren(activityNode)) {
            if (!"intent-filter".equals(activityChild.getNodeName())) continue;
            for (Element intentFilterChild : LintUtils.getChildren(activityChild)) {
                String attrName = intentFilterChild.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                if (!"category".equals(intentFilterChild.getNodeName()) || !CATEGORY_LEANBACK_LAUNCHER.equals(attrName)) continue;
                return true;
            }
        }
        return false;
    }

    private static Node getElementWithTagName(String tagName, Node node) {
        for (Element child : LintUtils.getChildren(node)) {
            if (!tagName.equals(child.getTagName())) continue;
            return child;
        }
        return null;
    }

    public static String getHardwareFeature(String errorMessage, TextFormat format) {
        List<String> parameters = LintUtils.getFormattedParameters(TextFormat.RAW.convertTo(USES_HARDWARE_ERROR_MESSAGE_FORMAT, format), errorMessage);
        if (parameters.size() == 1) {
            return parameters.get(0);
        }
        return null;
    }
}

