/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap;

import com.android.tools.perflib.analyzer.Capture;
import com.android.tools.perflib.captures.DataBuffer;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Field;
import com.android.tools.perflib.heap.Heap;
import com.android.tools.perflib.heap.HprofParser;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.RootObj;
import com.android.tools.perflib.heap.RootType;
import com.android.tools.perflib.heap.StackFrame;
import com.android.tools.perflib.heap.StackTrace;
import com.android.tools.perflib.heap.ThreadObj;
import com.android.tools.perflib.heap.Type;
import com.android.tools.perflib.heap.analysis.Dominators;
import com.android.tools.perflib.heap.analysis.ShortestDistanceVisitor;
import com.android.tools.perflib.heap.analysis.TopologicalSort;
import com.google.common.collect.ImmutableList;
import gnu.trove.THashSet;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TLongObjectHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class Snapshot
extends Capture {
    public static final String TYPE_NAME = "hprof";
    private static final String JAVA_LANG_CLASS = "java.lang.Class";
    public static final Instance SENTINEL_ROOT = new RootObj(RootType.UNKNOWN);
    private static final int DEFAULT_HEAP_ID = 0;
    private final DataBuffer mBuffer;
    ArrayList<Heap> mHeaps = new ArrayList();
    Heap mCurrentHeap;
    TIntObjectHashMap<StackTrace> mTraces = new TIntObjectHashMap();
    TLongObjectHashMap<StackFrame> mFrames = new TLongObjectHashMap();
    private ImmutableList<Instance> mTopSort;
    private Dominators mDominators;
    private THashSet<ClassObj> mReferenceClasses = new THashSet();
    private int[] mTypeSizes;
    private long mIdSizeMask = 0xFFFFFFFFL;

    public static Snapshot createSnapshot(DataBuffer buffer) {
        Snapshot snapshot = new Snapshot(buffer);
        HprofParser.parseBuffer(snapshot, buffer);
        return snapshot;
    }

    public Snapshot(DataBuffer buffer) {
        this.mBuffer = buffer;
        this.setToDefaultHeap();
    }

    public void dispose() {
        this.mBuffer.dispose();
    }

    DataBuffer getBuffer() {
        return this.mBuffer;
    }

    public Heap setToDefaultHeap() {
        return this.setHeapTo(0, "default");
    }

    public Heap setHeapTo(int id, String name) {
        Heap heap = this.getHeap(id);
        if (heap == null) {
            heap = new Heap(id, name);
            heap.mSnapshot = this;
            this.mHeaps.add(heap);
        }
        this.mCurrentHeap = heap;
        return this.mCurrentHeap;
    }

    public int getHeapIndex(Heap heap) {
        return this.mHeaps.indexOf(heap);
    }

    public Heap getHeap(int id) {
        for (int i = 0; i < this.mHeaps.size(); ++i) {
            if (this.mHeaps.get(i).getId() != id) continue;
            return this.mHeaps.get(i);
        }
        return null;
    }

    public Heap getHeap(String name) {
        for (int i = 0; i < this.mHeaps.size(); ++i) {
            if (!name.equals(this.mHeaps.get(i).getName())) continue;
            return this.mHeaps.get(i);
        }
        return null;
    }

    public Collection<Heap> getHeaps() {
        return this.mHeaps;
    }

    public Collection<RootObj> getGCRoots() {
        return this.mHeaps.get((int)0).mRoots;
    }

    public final void addStackFrame(StackFrame theFrame) {
        this.mFrames.put(theFrame.mId, (Object)theFrame);
    }

    public final StackFrame getStackFrame(long id) {
        return (StackFrame)this.mFrames.get(id);
    }

    public final void addStackTrace(StackTrace theTrace) {
        this.mTraces.put(theTrace.mSerialNumber, (Object)theTrace);
    }

    public final StackTrace getStackTrace(int traceSerialNumber) {
        return (StackTrace)this.mTraces.get(traceSerialNumber);
    }

    public final StackTrace getStackTraceAtDepth(int traceSerialNumber, int depth) {
        StackTrace trace = (StackTrace)this.mTraces.get(traceSerialNumber);
        if (trace != null) {
            trace = trace.fromDepth(depth);
        }
        return trace;
    }

    public final void addRoot(RootObj root) {
        this.mCurrentHeap.addRoot(root);
        root.setHeap(this.mCurrentHeap);
    }

    public final void addThread(ThreadObj thread, int serialNumber) {
        this.mCurrentHeap.addThread(thread, serialNumber);
    }

    public final ThreadObj getThread(int serialNumber) {
        return this.mCurrentHeap.getThread(serialNumber);
    }

    public final void setIdSize(int size) {
        int i;
        int maxId = -1;
        for (i = 0; i < Type.values().length; ++i) {
            maxId = Math.max(Type.values()[i].getTypeId(), maxId);
        }
        assert (maxId > 0 && maxId <= Type.LONG.getTypeId());
        this.mTypeSizes = new int[maxId + 1];
        Arrays.fill(this.mTypeSizes, -1);
        for (i = 0; i < Type.values().length; ++i) {
            this.mTypeSizes[Type.values()[i].getTypeId()] = Type.values()[i].getSize();
        }
        this.mTypeSizes[Type.OBJECT.getTypeId()] = size;
        this.mIdSizeMask = -1L >>> (8 - size) * 8;
    }

    public final int getTypeSize(Type type) {
        return this.mTypeSizes[type.getTypeId()];
    }

    public final long getIdSizeMask() {
        return this.mIdSizeMask;
    }

    public final void addInstance(long id, Instance instance) {
        this.mCurrentHeap.addInstance(id, instance);
        instance.setHeap(this.mCurrentHeap);
    }

    public final void addClass(long id, ClassObj theClass) {
        this.mCurrentHeap.addClass(id, theClass);
        theClass.setHeap(this.mCurrentHeap);
    }

    public final Instance findInstance(long id) {
        for (int i = 0; i < this.mHeaps.size(); ++i) {
            Instance instance = this.mHeaps.get(i).getInstance(id);
            if (instance == null) continue;
            return instance;
        }
        return this.findClass(id);
    }

    public final ClassObj findClass(long id) {
        for (int i = 0; i < this.mHeaps.size(); ++i) {
            ClassObj theClass = this.mHeaps.get(i).getClass(id);
            if (theClass == null) continue;
            return theClass;
        }
        return null;
    }

    public final ClassObj findClass(String name) {
        for (int i = 0; i < this.mHeaps.size(); ++i) {
            ClassObj theClass = this.mHeaps.get(i).getClass(name);
            if (theClass == null) continue;
            return theClass;
        }
        return null;
    }

    public final Collection<ClassObj> findClasses(String name) {
        ArrayList<ClassObj> classObjs = new ArrayList<ClassObj>();
        for (int i = 0; i < this.mHeaps.size(); ++i) {
            classObjs.addAll(this.mHeaps.get(i).getClasses(name));
        }
        return classObjs;
    }

    public void resolveClasses() {
        ClassObj clazz = this.findClass(JAVA_LANG_CLASS);
        int javaLangClassSize = clazz != null ? clazz.getInstanceSize() : 0;
        for (Heap heap : this.mHeaps) {
            for (ClassObj classObj : heap.getClasses()) {
                ClassObj superClass = classObj.getSuperClassObj();
                if (superClass != null) {
                    superClass.addSubclass(classObj);
                }
                int classSize = javaLangClassSize;
                for (Field f : classObj.mStaticFields) {
                    classSize += this.getTypeSize(f.getType());
                }
                classObj.setSize(classSize);
            }
            for (Instance instance : heap.getInstances()) {
                ClassObj classObj = instance.getClassObj();
                if (classObj == null) continue;
                classObj.addInstance(heap.getId(), instance);
            }
        }
    }

    public void resolveReferences() {
        List<ClassObj> referenceDescendants = this.findAllDescendantClasses(ClassObj.getReferenceClassName());
        for (ClassObj classObj : referenceDescendants) {
            classObj.setIsSoftReference();
            this.mReferenceClasses.add((Object)classObj);
        }
    }

    public List<ClassObj> findAllDescendantClasses(String className) {
        Collection<ClassObj> ancestorClasses = this.findClasses(className);
        ArrayList<ClassObj> descendants = new ArrayList<ClassObj>();
        for (ClassObj ancestor : ancestorClasses) {
            descendants.addAll(ancestor.getDescendantClasses());
        }
        return descendants;
    }

    public void computeDominators() {
        if (this.mDominators == null) {
            this.mTopSort = TopologicalSort.compute(this.getGCRoots());
            this.mDominators = new Dominators(this, this.mTopSort);
            this.mDominators.computeRetainedSizes();
            ShortestDistanceVisitor shortestDistanceVisitor = new ShortestDistanceVisitor();
            shortestDistanceVisitor.doVisit(this.getGCRoots());
        }
    }

    public List<Instance> getReachableInstances() {
        ArrayList<Instance> result = new ArrayList<Instance>(this.mTopSort.size());
        for (Instance node : this.mTopSort) {
            if (node.getImmediateDominator() == null) continue;
            result.add(node);
        }
        return result;
    }

    public ImmutableList<Instance> getTopologicalOrdering() {
        return this.mTopSort;
    }

    public final void dumpInstanceCounts() {
        for (Heap heap : this.mHeaps) {
            System.out.println("+------------------ instance counts for heap: " + heap.getName());
            heap.dumpInstanceCounts();
        }
    }

    public final void dumpSizes() {
        for (Heap heap : this.mHeaps) {
            System.out.println("+------------------ sizes for heap: " + heap.getName());
            heap.dumpSizes();
        }
    }

    public final void dumpSubclasses() {
        for (Heap heap : this.mHeaps) {
            System.out.println("+------------------ subclasses for heap: " + heap.getName());
            heap.dumpSubclasses();
        }
    }

    @Override
    public <T> T getRepresentation(Class<T> asClass) {
        if (asClass.isAssignableFrom(this.getClass())) {
            return asClass.cast(this);
        }
        return null;
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }
}

