/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.checkout;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.CvsVcs2;
import com.intellij.cvsSupport2.config.CvsApplicationLevelConfiguration;
import com.intellij.cvsSupport2.cvsBrowser.CvsElement;
import com.intellij.cvsSupport2.cvsExecution.CvsOperationExecutor;
import com.intellij.cvsSupport2.cvsExecution.CvsOperationExecutorCallback;
import com.intellij.cvsSupport2.cvsExecution.ModalityContext;
import com.intellij.cvsSupport2.cvshandlers.CommandCvsHandler;
import com.intellij.cvsSupport2.cvshandlers.CvsHandler;
import com.intellij.cvsSupport2.ui.experts.checkout.CheckoutWizard;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class CvsCheckoutProvider
implements CheckoutProvider {
    public void doCheckout(@NotNull Project project, final CheckoutProvider.Listener listener) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/cvsSupport2/checkout/CvsCheckoutProvider", "doCheckout"));
        }
        CheckoutWizard checkoutWizard = new CheckoutWizard(project);
        if (!checkoutWizard.showAndGet()) {
            return;
        }
        final boolean useAlternateCheckoutPath = checkoutWizard.useAlternativeCheckoutLocation();
        final File checkoutDirectory = checkoutWizard.getCheckoutDirectory();
        final CvsElement[] selectedElements = checkoutWizard.getSelectedElements();
        CvsHandler checkoutHandler = CommandCvsHandler.createCheckoutHandler(checkoutWizard.getConfigurationWithDateOrRevisionSettings(), CvsCheckoutProvider.collectCheckoutPaths(selectedElements), checkoutDirectory, useAlternateCheckoutPath, CvsApplicationLevelConfiguration.getInstance().MAKE_CHECKED_OUT_FILES_READONLY, VcsConfiguration.getInstance((Project)project).getCheckoutOption());
        final CvsOperationExecutor executor = new CvsOperationExecutor(null);
        executor.performActionSync(checkoutHandler, new CvsOperationExecutorCallback(){

            @Override
            public void executionFinished(boolean successfully) {
                if (!executor.hasNoErrors()) {
                    Messages.showErrorDialog((String)CvsBundle.message((String)"message.error.checkout", (Object[])new Object[]{executor.getResult().composeError().getLocalizedMessage()}), (String)CvsBundle.message((String)"operation.name.check.out.project", (Object[])new Object[0]));
                }
                CvsCheckoutProvider.this.refreshAfterCheckout(listener, selectedElements, checkoutDirectory, useAlternateCheckoutPath);
            }

            @Override
            public void executionFinishedSuccessfully() {
            }

            @Override
            public void executeInProgressAfterAction(ModalityContext modaityContext) {
            }
        });
    }

    public void refreshAfterCheckout(final CheckoutProvider.Listener listener, final CvsElement[] selectedElements, final File checkoutDirectory, final boolean useAlternateCheckoutPath) {
        VirtualFileManager.getInstance().asyncRefresh(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        for (CvsElement element : selectedElements) {
                            File path = useAlternateCheckoutPath ? checkoutDirectory : new File(checkoutDirectory, element.getCheckoutPath());
                            listener.directoryCheckedOut(path, CvsVcs2.getKey());
                        }
                        listener.checkoutCompleted();
                    }
                });
            }
        });
    }

    private static String[] collectCheckoutPaths(CvsElement[] mySelectedElements) {
        String[] checkoutPaths = new String[mySelectedElements.length];
        for (int i = 0; i < mySelectedElements.length; ++i) {
            CvsElement selectedElement = mySelectedElements[i];
            checkoutPaths[i] = selectedElement.getCheckoutPath();
        }
        return checkoutPaths;
    }

    public String getVcsName() {
        return "_CVS";
    }
}

