/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.openapi.fileTypes.ExactFileNameMatcher;
import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcherEx;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.ArrayUtil;
import com.intellij.util.text.CharSequenceHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTypeAssocTable<T> {
    private final Map<CharSequence, T> myExtensionMappings;
    private final Map<CharSequence, T> myExactFileNameMappings;
    private final Map<CharSequence, T> myExactFileNameAnyCaseMappings;
    private final List<Pair<FileNameMatcher, T>> myMatchingMappings;

    private FileTypeAssocTable(@NotNull Map<CharSequence, T> extensionMappings, @NotNull Map<CharSequence, T> exactFileNameMappings, @NotNull Map<CharSequence, T> exactFileNameAnyCaseMappings, @NotNull List<Pair<FileNameMatcher, T>> matchingMappings) {
        if (extensionMappings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionMappings", "com/intellij/openapi/fileTypes/impl/FileTypeAssocTable", "<init>"));
        }
        if (exactFileNameMappings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exactFileNameMappings", "com/intellij/openapi/fileTypes/impl/FileTypeAssocTable", "<init>"));
        }
        if (exactFileNameAnyCaseMappings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exactFileNameAnyCaseMappings", "com/intellij/openapi/fileTypes/impl/FileTypeAssocTable", "<init>"));
        }
        if (matchingMappings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matchingMappings", "com/intellij/openapi/fileTypes/impl/FileTypeAssocTable", "<init>"));
        }
        this.myExtensionMappings = new THashMap(Math.max(10, extensionMappings.size()), 0.5f, (TObjectHashingStrategy)CharSequenceHashingStrategy.CASE_INSENSITIVE);
        this.myExtensionMappings.putAll(extensionMappings);
        this.myExactFileNameMappings = new THashMap(Math.max(10, exactFileNameMappings.size()), 0.5f, (TObjectHashingStrategy)CharSequenceHashingStrategy.CASE_SENSITIVE);
        this.myExactFileNameMappings.putAll(exactFileNameMappings);
        this.myExactFileNameAnyCaseMappings = new THashMap(Math.max(10, exactFileNameAnyCaseMappings.size()), 0.5f, (TObjectHashingStrategy)CharSequenceHashingStrategy.CASE_INSENSITIVE);
        this.myExactFileNameAnyCaseMappings.putAll(exactFileNameAnyCaseMappings);
        this.myMatchingMappings = new ArrayList<Pair<FileNameMatcher, T>>(matchingMappings);
    }

    public FileTypeAssocTable() {
        this(Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyList());
    }

    public boolean isAssociatedWith(@NotNull T type, @NotNull FileNameMatcher matcher) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/fileTypes/impl/FileTypeAssocTable", "isAssociatedWith"));
        }
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matcher", "com/intellij/openapi/fileTypes/impl/FileTypeAssocTable", "isAssociatedWith"));
        }
        if (matcher instanceof ExtensionFileNameMatcher || matcher instanceof ExactFileNameMatcher) {
            return this.findAssociatedFileType(matcher) == type;
        }
        for (Pair<FileNameMatcher, T> mapping : this.myMatchingMappings) {
            if (!matcher.equals(mapping.getFirst()) || type != mapping.getSecond()) continue;
            return true;
        }
        return false;
    }

    public void addAssociation(FileNameMatcher matcher, T type) {
        if (matcher instanceof ExtensionFileNameMatcher) {
            this.myExtensionMappings.put(((ExtensionFileNameMatcher)matcher).getExtension(), type);
        } else if (matcher instanceof ExactFileNameMatcher) {
            ExactFileNameMatcher exactFileNameMatcher = (ExactFileNameMatcher)matcher;
            Map<CharSequence, T> mapToUse = exactFileNameMatcher.isIgnoreCase() ? this.myExactFileNameAnyCaseMappings : this.myExactFileNameMappings;
            mapToUse.put(exactFileNameMatcher.getFileName(), type);
        } else {
            this.myMatchingMappings.add(Pair.create((Object)matcher, type));
        }
    }

    boolean removeAssociation(@NotNull FileNameMatcher matcher, @NotNull T type) {
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matcher", "com/intellij/openapi/fileTypes/impl/FileTypeAssocTable", "removeAssociation"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/fileTypes/impl/FileTypeAssocTable", "removeAssociation"));
        }
        if (matcher instanceof ExtensionFileNameMatcher) {
            String extension = ((ExtensionFileNameMatcher)matcher).getExtension();
            if (this.myExtensionMappings.get(extension) == type) {
                this.myExtensionMappings.remove(extension);
                return true;
            }
            return false;
        }
        if (matcher instanceof ExactFileNameMatcher) {
            Map<CharSequence, T> map;
            ExactFileNameMatcher exactFileNameMatcher = (ExactFileNameMatcher)matcher;
            String fileName = exactFileNameMatcher.getFileName();
            Map<CharSequence, T> map2 = map = exactFileNameMatcher.isIgnoreCase() ? this.myExactFileNameAnyCaseMappings : this.myExactFileNameMappings;
            if (map.get(fileName) == type) {
                map.remove(fileName);
                return true;
            }
            return false;
        }
        ArrayList<Pair<FileNameMatcher, T>> copy = new ArrayList<Pair<FileNameMatcher, T>>(this.myMatchingMappings);
        for (Pair pair : copy) {
            if (!matcher.equals(pair.getFirst())) continue;
            this.myMatchingMappings.remove(pair);
            return true;
        }
        return false;
    }

    boolean removeAllAssociations(@NotNull T type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/fileTypes/impl/FileTypeAssocTable", "removeAllAssociations"));
        }
        boolean changed = this.removeAssociationsFromMap(this.myExtensionMappings, type, false);
        changed = this.removeAssociationsFromMap(this.myExactFileNameAnyCaseMappings, type, changed);
        changed = this.removeAssociationsFromMap(this.myExactFileNameMappings, type, changed);
        ArrayList<Pair<FileNameMatcher, T>> copy = new ArrayList<Pair<FileNameMatcher, T>>(this.myMatchingMappings);
        for (Pair pair : copy) {
            if (pair.getSecond() != type) continue;
            this.myMatchingMappings.remove(pair);
            changed = true;
        }
        return changed;
    }

    private boolean removeAssociationsFromMap(@NotNull Map<CharSequence, T> extensionMappings, @NotNull T type, boolean changed) {
        CharSequence[] extsStrings;
        if (extensionMappings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionMappings", "com/intellij/openapi/fileTypes/impl/FileTypeAssocTable", "removeAssociationsFromMap"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/fileTypes/impl/FileTypeAssocTable", "removeAssociationsFromMap"));
        }
        Set<CharSequence> exts = extensionMappings.keySet();
        for (CharSequence s : extsStrings = exts.toArray(new CharSequence[exts.size()])) {
            if (extensionMappings.get(s) != type) continue;
            extensionMappings.remove(s);
            changed = true;
        }
        return changed;
    }

    @Nullable
    public T findAssociatedFileType(@NotNull @NonNls CharSequence fileName) {
        T t;
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/fileTypes/impl/FileTypeAssocTable", "findAssociatedFileType"));
        }
        if (!this.myExactFileNameMappings.isEmpty() && (t = this.myExactFileNameMappings.get(fileName)) != null) {
            return t;
        }
        if (!this.myExactFileNameAnyCaseMappings.isEmpty() && (t = this.myExactFileNameAnyCaseMappings.get(fileName)) != null) {
            return t;
        }
        for (int i = 0; i < this.myMatchingMappings.size(); ++i) {
            Pair<FileNameMatcher, T> mapping = this.myMatchingMappings.get(i);
            if (!FileNameMatcherEx.acceptsCharSequence((FileNameMatcher)((FileNameMatcher)mapping.getFirst()), (CharSequence)fileName)) continue;
            return (T)mapping.getSecond();
        }
        return this.myExtensionMappings.get(FileUtilRt.getExtension((CharSequence)fileName));
    }

    @Nullable
    public T findAssociatedFileType(@NotNull FileNameMatcher matcher) {
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matcher", "com/intellij/openapi/fileTypes/impl/FileTypeAssocTable", "findAssociatedFileType"));
        }
        if (matcher instanceof ExtensionFileNameMatcher) {
            return this.myExtensionMappings.get(((ExtensionFileNameMatcher)matcher).getExtension());
        }
        if (matcher instanceof ExactFileNameMatcher) {
            ExactFileNameMatcher exactFileNameMatcher = (ExactFileNameMatcher)matcher;
            Map<CharSequence, T> mapToUse = exactFileNameMatcher.isIgnoreCase() ? this.myExactFileNameAnyCaseMappings : this.myExactFileNameMappings;
            return mapToUse.get(exactFileNameMatcher.getFileName());
        }
        for (Pair<FileNameMatcher, T> mapping : this.myMatchingMappings) {
            if (!matcher.equals(mapping.getFirst())) continue;
            return (T)mapping.getSecond();
        }
        return null;
    }

    @Deprecated
    @NotNull
    public String[] getAssociatedExtensions(@NotNull T type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/fileTypes/impl/FileTypeAssocTable", "getAssociatedExtensions"));
        }
        Map<CharSequence, T> extMap = this.myExtensionMappings;
        ArrayList<String> exts = new ArrayList<String>();
        for (Map.Entry<CharSequence, T> entry : extMap.entrySet()) {
            if (entry.getValue() != type) continue;
            exts.add(entry.getKey().toString());
        }
        String[] stringArray = ArrayUtil.toStringArray(exts);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeAssocTable", "getAssociatedExtensions"));
        }
        return stringArray;
    }

    @NotNull
    public FileTypeAssocTable<T> copy() {
        FileTypeAssocTable<T> fileTypeAssocTable = new FileTypeAssocTable<T>(this.myExtensionMappings, this.myExactFileNameMappings, this.myExactFileNameAnyCaseMappings, this.myMatchingMappings);
        if (fileTypeAssocTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeAssocTable", "copy"));
        }
        return fileTypeAssocTable;
    }

    @NotNull
    public List<FileNameMatcher> getAssociations(@NotNull T type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/fileTypes/impl/FileTypeAssocTable", "getAssociations"));
        }
        ArrayList<FileNameMatcher> result = new ArrayList<FileNameMatcher>();
        for (Pair<FileNameMatcher, T> pair : this.myMatchingMappings) {
            if (pair.getSecond() != type) continue;
            result.add((FileNameMatcher)pair.getFirst());
        }
        for (Map.Entry entry : this.myExactFileNameMappings.entrySet()) {
            if (entry.getValue() != type) continue;
            result.add((FileNameMatcher)new ExactFileNameMatcher(((CharSequence)entry.getKey()).toString()));
        }
        for (Map.Entry entry : this.myExactFileNameAnyCaseMappings.entrySet()) {
            if (entry.getValue() != type) continue;
            result.add((FileNameMatcher)new ExactFileNameMatcher(((CharSequence)entry.getKey()).toString(), true));
        }
        for (Map.Entry entry : this.myExtensionMappings.entrySet()) {
            if (entry.getValue() != type) continue;
            result.add((FileNameMatcher)new ExtensionFileNameMatcher(((CharSequence)entry.getKey()).toString()));
        }
        ArrayList<FileNameMatcher> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeAssocTable", "getAssociations"));
        }
        return arrayList;
    }

    public boolean hasAssociationsFor(@NotNull T fileType) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileTypes/impl/FileTypeAssocTable", "hasAssociationsFor"));
        }
        if (this.myExtensionMappings.values().contains(fileType) || this.myExactFileNameMappings.values().contains(fileType) || this.myExactFileNameAnyCaseMappings.values().contains(fileType)) {
            return true;
        }
        for (Pair<FileNameMatcher, T> mapping : this.myMatchingMappings) {
            if (mapping.getSecond() != fileType) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileTypeAssocTable that = (FileTypeAssocTable)o;
        return this.myExtensionMappings.equals(that.myExtensionMappings) && this.myMatchingMappings.equals(that.myMatchingMappings) && this.myExactFileNameMappings.equals(that.myExactFileNameMappings) && this.myExactFileNameAnyCaseMappings.equals(that.myExactFileNameAnyCaseMappings);
    }

    public int hashCode() {
        int result = this.myExtensionMappings.hashCode();
        result = 31 * result + this.myMatchingMappings.hashCode();
        result = 31 * result + this.myExactFileNameMappings.hashCode();
        result = 31 * result + this.myExactFileNameAnyCaseMappings.hashCode();
        return result;
    }
}

