/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.concurrency;

import com.intellij.concurrency.AsyncFuture;
import com.intellij.concurrency.AsyncFutureResult;
import com.intellij.openapi.components.ServiceManager;
import org.jetbrains.annotations.NotNull;

public abstract class AsyncFutureFactory {
    public static AsyncFutureFactory getInstance() {
        return ServiceManager.getService(AsyncFutureFactory.class);
    }

    @NotNull
    public static <V> AsyncFuture<V> wrap(V v) {
        AsyncFutureResult<V> result = AsyncFutureFactory.getInstance().createAsyncFutureResult();
        result.set(v);
        AsyncFutureResult<V> asyncFutureResult = result;
        if (asyncFutureResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/concurrency/AsyncFutureFactory", "wrap"));
        }
        return asyncFutureResult;
    }

    @NotNull
    public static <V> AsyncFuture<V> wrapException(Throwable e) {
        AsyncFutureResult<V> result = AsyncFutureFactory.getInstance().createAsyncFutureResult();
        result.setException(e);
        AsyncFutureResult<V> asyncFutureResult = result;
        if (asyncFutureResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/concurrency/AsyncFutureFactory", "wrapException"));
        }
        return asyncFutureResult;
    }

    @NotNull
    public abstract <V> AsyncFutureResult<V> createAsyncFutureResult();
}

