/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.openapi.editor.Document;
import org.jetbrains.annotations.NotNull;

public class LineCol {
    public final int line;
    public final int column;

    public LineCol(int line) {
        this(line, 0);
    }

    public LineCol(int line, int column) {
        this.line = line;
        this.column = column;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LineCol col = (LineCol)o;
        if (this.line != col.line) {
            return false;
        }
        return this.column == col.column;
    }

    public int hashCode() {
        int result = this.line;
        result = 31 * result + this.column;
        return result;
    }

    public String toString() {
        return String.format("{ line: %s, column: %s }", this.line, this.column);
    }

    @NotNull
    public static LineCol fromOffset(@NotNull Document document, int offset) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/LineCol", "fromOffset"));
        }
        int line = document.getLineNumber(offset);
        int column = offset - document.getLineStartOffset(line);
        LineCol lineCol = new LineCol(line, column);
        if (lineCol == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/LineCol", "fromOffset"));
        }
        return lineCol;
    }

    public static int toOffset(@NotNull Document document, @NotNull LineCol linecol) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/LineCol", "toOffset"));
        }
        if (linecol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linecol", "com/intellij/diff/util/LineCol", "toOffset"));
        }
        return document.getLineStartOffset(linecol.line) + linecol.column;
    }
}

