/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.project.Project;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.PlatformColors;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

class Banner
extends NonOpaquePanel
implements PropertyChangeListener {
    private int myBannerMinHeight;
    private final JComponent myText = new MyText();
    private final JLabel myProjectIcon = new JLabel(AllIcons.General.ProjectConfigurableBanner, 2);
    private final NonOpaquePanel myActionsPanel = new NonOpaquePanel(new FlowLayout(2, 2, 2));
    private final Map<Action, LinkLabel> myActions = new HashMap();

    public Banner() {
        this.setLayout(new BorderLayout());
        this.setBorder((Border)JBUI.Borders.empty((int)2, (int)12, (int)2, (int)4));
        this.myProjectIcon.setVisible(false);
        this.myProjectIcon.setBorder(new EmptyBorder(0, 12, 0, 4));
        this.add((Component)this.myText, "West");
        this.add((Component)this.myProjectIcon, "Center");
        this.add((Component)this.myActionsPanel, "East");
    }

    public void addAction(final Action action) {
        action.addPropertyChangeListener(this);
        LinkLabel label = new LinkLabel(null, null, new LinkListener(){

            public void linkSelected(LinkLabel aSource, Object aLinkData) {
                action.actionPerformed(new ActionEvent(Banner.this, 1001, "ActionCommandKey"));
            }
        }){

            @Override
            protected Color getTextColor() {
                return PlatformColors.BLUE;
            }
        };
        label.setFont(label.getFont().deriveFont(1));
        this.myActions.put(action, label);
        this.myActionsPanel.add(label);
        this.updateAction(action);
    }

    void updateAction(Action action) {
        LinkLabel label = this.myActions.get(action);
        label.setVisible(action.isEnabled());
        label.setText((String)action.getValue("Name"));
        label.setToolTipText((String)action.getValue("ShortDescription"));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object source = evt.getSource();
        if (source instanceof Action) {
            this.updateAction((Action)source);
        }
    }

    public void clearActions() {
        Set<Action> actions = this.myActions.keySet();
        for (Action each : actions) {
            each.removePropertyChangeListener(this);
        }
        this.myActions.clear();
        this.myActionsPanel.removeAll();
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension size = super.getMinimumSize();
        size.height = Math.max(this.myBannerMinHeight, size.height);
        return size;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        size.height = this.getMinimumSize().height;
        return size;
    }

    public void setMinHeight(int height) {
        this.myBannerMinHeight = height;
        this.revalidate();
        this.repaint();
    }

    public void forProject(Project project) {
        if (project != null) {
            this.myProjectIcon.setVisible(true);
            this.myProjectIcon.setText(OptionsBundle.message(project.isDefault() ? "configurable.default.project.tooltip" : "configurable.current.project.tooltip", new Object[0]));
        } else {
            this.myProjectIcon.setVisible(false);
        }
    }

    public void setText(String ... text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/ui/Banner", "setText"));
        }
        this.myText.removeAll();
        for (int i = 0; i < text.length; ++i) {
            JLabel eachLabel = new JLabel(text[i], 0);
            eachLabel.setBorder(new EmptyBorder(0, 0, 0, 5));
            eachLabel.setFont(RelativeFont.BOLD.derive(eachLabel.getFont()));
            this.myText.add(eachLabel);
            if (i >= text.length - 1) continue;
            JLabel eachIcon = new JLabel("\u203a", 0);
            eachIcon.setFont(RelativeFont.HUGE.derive(eachIcon.getFont()));
            eachIcon.setBorder(new EmptyBorder(0, 0, 0, 5));
            this.myText.add(eachIcon);
        }
    }

    public void updateActions() {
        Set<Action> actions = this.myActions.keySet();
        for (Action action : actions) {
            this.updateAction(action);
        }
    }

    private static class MyText
    extends NonOpaquePanel {
        private MyText() {
        }

        @Override
        public void doLayout() {
            int x = 0;
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component each = this.getComponent(i);
                Dimension eachSize = each.getPreferredSize();
                each.setBounds(x, 0, eachSize.width, this.getHeight());
                x += each.getBounds().width;
            }
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = new Dimension();
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component each = this.getComponent(i);
                Dimension eachSize = each.getPreferredSize();
                size.width += eachSize.width;
                size.height = Math.max(size.height, eachSize.height);
            }
            return size;
        }
    }
}

