/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.DifferenceFilter;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.AppCodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LegacyCodeStyleSettingsManager;
import com.intellij.psi.codeStyle.ProjectCodeStyleSettingsManager;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleSettingsManager
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance((String)("#" + CodeStyleSettingsManager.class.getName()));
    public volatile CodeStyleSettings PER_PROJECT_SETTINGS = null;
    public volatile boolean USE_PER_PROJECT_SETTINGS = false;
    public volatile String PREFERRED_PROJECT_CODE_STYLE = null;
    private volatile CodeStyleSettings myTemporarySettings;
    private volatile boolean myIsLoaded = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CodeStyleSettingsManager getInstance(@Nullable Project project) {
        if (project == null || project.isDefault()) {
            return CodeStyleSettingsManager.getInstance();
        }
        ProjectCodeStyleSettingsManager projectSettingsManager = ServiceManager.getService(project, ProjectCodeStyleSettingsManager.class);
        if (!projectSettingsManager.isLoaded()) {
            ProjectCodeStyleSettingsManager projectCodeStyleSettingsManager = projectSettingsManager;
            synchronized (projectCodeStyleSettingsManager) {
                LegacyCodeStyleSettingsManager legacySettingsManager;
                if (!projectSettingsManager.isLoaded() && (legacySettingsManager = ServiceManager.getService(project, LegacyCodeStyleSettingsManager.class)) != null && legacySettingsManager.getState() != null) {
                    projectSettingsManager.loadState(legacySettingsManager.getState());
                    LOG.info("Imported old project code style settings.");
                }
            }
        }
        return projectSettingsManager;
    }

    public static CodeStyleSettingsManager getInstance() {
        return ServiceManager.getService(AppCodeStyleSettingsManager.class);
    }

    public CodeStyleSettingsManager(Project project) {
    }

    public CodeStyleSettingsManager() {
    }

    @NotNull
    public static CodeStyleSettings getSettings(@Nullable Project project) {
        CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getInstance(project).getCurrentSettings();
        if (codeStyleSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/CodeStyleSettingsManager", "getSettings"));
        }
        return codeStyleSettings;
    }

    @NotNull
    public CodeStyleSettings getCurrentSettings() {
        CodeStyleSettings temporarySettings = this.myTemporarySettings;
        if (temporarySettings != null) {
            CodeStyleSettings codeStyleSettings = temporarySettings;
            if (codeStyleSettings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/CodeStyleSettingsManager", "getCurrentSettings"));
            }
            return codeStyleSettings;
        }
        CodeStyleSettings projectSettings = this.PER_PROJECT_SETTINGS;
        if (this.USE_PER_PROJECT_SETTINGS && projectSettings != null) {
            CodeStyleSettings codeStyleSettings = projectSettings;
            if (codeStyleSettings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/CodeStyleSettingsManager", "getCurrentSettings"));
            }
            return codeStyleSettings;
        }
        CodeStyleSettings codeStyleSettings = CodeStyleSchemes.getInstance().findPreferredScheme(this.PREFERRED_PROJECT_CODE_STYLE).getCodeStyleSettings();
        if (codeStyleSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/CodeStyleSettingsManager", "getCurrentSettings"));
        }
        return codeStyleSettings;
    }

    private void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
    }

    private void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element, (DefaultJDOMExternalizer.JDOMFilter)new DifferenceFilter((Object)this, (Object)new CodeStyleSettingsManager()));
    }

    @Override
    public Element getState() {
        Element result = new Element("state");
        try {
            this.writeExternal(result);
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
        }
        return result;
    }

    @Override
    public void loadState(Element state) {
        try {
            this.readExternal(state);
            this.myIsLoaded = true;
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
    }

    public CodeStyleSettings getTemporarySettings() {
        return this.myTemporarySettings;
    }

    public void setTemporarySettings(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/psi/codeStyle/CodeStyleSettingsManager", "setTemporarySettings"));
        }
        this.myTemporarySettings = settings;
    }

    public void dropTemporarySettings() {
        this.myTemporarySettings = null;
    }

    public boolean isLoaded() {
        return this.myIsLoaded;
    }

    public static void updateDocumentIndentOptions(@NotNull Project project, @NotNull Document document) {
        PsiFile file;
        PsiDocumentManager documentManager;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/codeStyle/CodeStyleSettingsManager", "updateDocumentIndentOptions"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/codeStyle/CodeStyleSettingsManager", "updateDocumentIndentOptions"));
        }
        if (!project.isDisposed() && (documentManager = PsiDocumentManager.getInstance(project)) != null && (file = documentManager.getPsiFile(document)) != null) {
            CommonCodeStyleSettings.IndentOptions indentOptions = CodeStyleSettingsManager.getSettings(project).getIndentOptionsByFile(file, null, true, null);
            indentOptions.associateWithDocument(document);
        }
    }
}

