/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiFormatUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiFormatUtil
extends PsiFormatUtilBase {
    public static String formatVariable(@NotNull PsiVariable variable, @FormatVariableOptions int options, PsiSubstitutor substitutor) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/psi/util/PsiFormatUtil", "formatVariable"));
        }
        StringBuilder buffer = new StringBuilder();
        PsiFormatUtil.formatVariable(variable, options, substitutor, buffer);
        return buffer.toString();
    }

    private static void formatVariable(@NotNull PsiVariable variable, @FormatVariableOptions int options, PsiSubstitutor substitutor, @NotNull StringBuilder buffer) {
        PsiExpression initializer;
        String name;
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/psi/util/PsiFormatUtil", "formatVariable"));
        }
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/psi/util/PsiFormatUtil", "formatVariable"));
        }
        if ((options & 8) != 0 && (options & 0x10) == 0) {
            PsiFormatUtil.formatModifiers(variable, options, buffer);
        }
        if ((options & 2) != 0 && (options & 4) == 0) {
            PsiFormatUtil.appendSpaceIfNeeded(buffer);
            buffer.append(PsiFormatUtil.formatType(variable.getType(), options, substitutor));
        }
        if (variable instanceof PsiField && (options & 0x1000) != 0) {
            String className;
            PsiClass aClass = ((PsiField)variable).getContainingClass();
            if (aClass != null && (className = aClass.getName()) != null) {
                PsiFormatUtil.appendSpaceIfNeeded(buffer);
                if ((options & 0x800) != 0) {
                    String qName = aClass.getQualifiedName();
                    if (qName != null) {
                        buffer.append(qName);
                    } else {
                        buffer.append(className);
                    }
                } else {
                    buffer.append(className);
                }
                buffer.append('.');
            }
            if ((options & 1) != 0) {
                buffer.append(variable.getName());
            }
        } else if ((options & 1) != 0 && StringUtil.isNotEmpty((String)(name = variable.getName()))) {
            PsiFormatUtil.appendSpaceIfNeeded(buffer);
            buffer.append(name);
        }
        if ((options & 2) != 0 && (options & 4) != 0) {
            if ((options & 1) != 0 && variable.getName() != null) {
                buffer.append(':');
            }
            buffer.append(PsiFormatUtil.formatType(variable.getType(), options, substitutor));
        }
        if ((options & 8) != 0 && (options & 0x10) != 0) {
            PsiFormatUtil.formatModifiers(variable, options, buffer);
        }
        if ((options & 0x80) != 0 && (initializer = variable.getInitializer()) != null) {
            int index2;
            buffer.append(" = ");
            String text = PsiExpressionTrimRenderer.render(initializer);
            int index1 = text.lastIndexOf(10);
            if (index1 < 0) {
                index1 = text.length();
            }
            if ((index2 = text.lastIndexOf(13)) < 0) {
                index2 = text.length();
            }
            int index = Math.min(index1, index2);
            buffer.append(text.substring(0, index));
            if (index < text.length()) {
                buffer.append(" ...");
            }
        }
    }

    public static String formatMethod(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor, @FormatMethodOptions int options, @FormatVariableOptions int parameterOptions) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/util/PsiFormatUtil", "formatMethod"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/util/PsiFormatUtil", "formatMethod"));
        }
        return PsiFormatUtil.formatMethod(method, substitutor, options, parameterOptions, 7);
    }

    public static String formatMethod(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor, @FormatMethodOptions int options, @FormatVariableOptions int parameterOptions, int maxParametersToShow) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/util/PsiFormatUtil", "formatMethod"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/util/PsiFormatUtil", "formatMethod"));
        }
        StringBuilder buffer = new StringBuilder();
        PsiFormatUtil.formatMethod(method, substitutor, options, parameterOptions, maxParametersToShow, buffer);
        return buffer.toString();
    }

    private static void formatMethod(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor, @FormatMethodOptions int options, @FormatVariableOptions int parameterOptions, int maxParametersToShow, StringBuilder buffer) {
        String throwsText;
        PsiType type;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/util/PsiFormatUtil", "formatMethod"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/util/PsiFormatUtil", "formatMethod"));
        }
        if ((options & 8) != 0 && (options & 0x10) == 0) {
            PsiFormatUtil.formatModifiers(method, options, buffer);
        }
        if ((options & 2) != 0 && (options & 4) == 0 && (type = method.getReturnType()) != null) {
            PsiFormatUtil.appendSpaceIfNeeded(buffer);
            buffer.append(PsiFormatUtil.formatType(type, options, substitutor));
        }
        if ((options & 0x1000) != 0) {
            PsiClass aClass = method.getContainingClass();
            if (aClass != null) {
                PsiFormatUtil.appendSpaceIfNeeded(buffer);
                String name = aClass.getName();
                if (name != null) {
                    if ((options & 0x800) != 0) {
                        String qName = aClass.getQualifiedName();
                        if (qName != null) {
                            buffer.append(qName);
                        } else {
                            buffer.append(name);
                        }
                    } else {
                        buffer.append(name);
                    }
                    buffer.append('.');
                }
            }
            if ((options & 1) != 0) {
                buffer.append(method.getName());
            }
        } else if ((options & 1) != 0) {
            PsiFormatUtil.appendSpaceIfNeeded(buffer);
            buffer.append(method.getName());
        }
        if ((options & 0x100) != 0) {
            buffer.append('(');
            PsiParameter[] params = method.getParameterList().getParameters();
            for (int i = 0; i < Math.min(params.length, maxParametersToShow); ++i) {
                PsiParameter parm = params[i];
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(PsiFormatUtil.formatVariable(parm, parameterOptions, substitutor));
            }
            if (params.length > maxParametersToShow) {
                buffer.append(", ...");
            }
            buffer.append(')');
        }
        if ((options & 2) != 0 && (options & 4) != 0 && (type = method.getReturnType()) != null) {
            if (buffer.length() > 0) {
                buffer.append(':');
            }
            buffer.append(PsiFormatUtil.formatType(type, options, substitutor));
        }
        if ((options & 8) != 0 && (options & 0x10) != 0) {
            PsiFormatUtil.formatModifiers(method, options, buffer);
        }
        if ((options & 0x200) != 0 && !(throwsText = PsiFormatUtil.formatReferenceList(method.getThrowsList(), options)).isEmpty()) {
            PsiFormatUtil.appendSpaceIfNeeded(buffer);
            buffer.append("throws ");
            buffer.append(throwsText);
        }
    }

    @NotNull
    public static String formatClass(@NotNull PsiClass aClass, @FormatClassOptions int options) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/util/PsiFormatUtil", "formatClass"));
        }
        StringBuilder buffer = new StringBuilder();
        if ((options & 8) != 0 && (options & 0x10) == 0) {
            PsiFormatUtil.formatModifiers(aClass, options, buffer);
        }
        if ((options & 1) != 0) {
            if (aClass instanceof PsiAnonymousClass && (options & 0x8000) != 0) {
                PsiClassType baseClassReference = ((PsiAnonymousClass)aClass).getBaseClassType();
                PsiClass baseClass = baseClassReference.resolve();
                String name = baseClass == null ? baseClassReference.getPresentableText() : PsiFormatUtil.formatClass(baseClass, options);
                buffer.append(PsiBundle.message("anonymous.class.derived.display", name));
            } else {
                String name = aClass.getName();
                if (name != null) {
                    PsiFormatUtil.appendSpaceIfNeeded(buffer);
                    if ((options & 0x800) != 0) {
                        String qName = aClass.getQualifiedName();
                        if (qName != null) {
                            buffer.append(qName);
                        } else {
                            buffer.append(aClass.getName());
                        }
                    } else {
                        buffer.append(aClass.getName());
                    }
                }
            }
        }
        if ((options & 8) != 0 && (options & 0x10) != 0) {
            PsiFormatUtil.formatModifiers(aClass, options, buffer);
        }
        if ((options & 0x400) != 0) {
            String implementsText;
            String extendsText = PsiFormatUtil.formatReferenceList(aClass.getExtendsList(), options);
            if (!extendsText.isEmpty()) {
                PsiFormatUtil.appendSpaceIfNeeded(buffer);
                buffer.append("extends ");
                buffer.append(extendsText);
            }
            if (!(implementsText = PsiFormatUtil.formatReferenceList(aClass.getImplementsList(), options)).isEmpty()) {
                PsiFormatUtil.appendSpaceIfNeeded(buffer);
                buffer.append("implements ");
                buffer.append(implementsText);
            }
        }
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/PsiFormatUtil", "formatClass"));
        }
        return string;
    }

    public static String formatModifiers(PsiElement element, int options) throws IllegalArgumentException {
        StringBuilder buffer = new StringBuilder();
        PsiFormatUtil.formatModifiers(element, options, buffer);
        return buffer.toString();
    }

    private static void formatModifiers(PsiElement element, int options, StringBuilder buffer) throws IllegalArgumentException {
        PsiModifierList list;
        boolean isInterface = false;
        if (element instanceof PsiVariable) {
            list = ((PsiVariable)element).getModifierList();
        } else if (element instanceof PsiMethod) {
            list = ((PsiMethod)element).getModifierList();
        } else if (element instanceof PsiClass) {
            isInterface = ((PsiClass)element).isInterface();
            list = ((PsiClass)element).getModifierList();
            if (list == null) {
                return;
            }
        } else if (element instanceof PsiClassInitializer) {
            list = ((PsiClassInitializer)element).getModifierList();
            if (list == null) {
                return;
            }
        } else {
            throw new IllegalArgumentException();
        }
        if (list == null) {
            return;
        }
        if ((options & 0x20) == 0 ? list.hasExplicitModifier("public") : list.hasModifierProperty("public")) {
            PsiFormatUtil.appendModifier(buffer, "public");
        }
        if (list.hasModifierProperty("protected")) {
            PsiFormatUtil.appendModifier(buffer, "protected");
        }
        if (list.hasModifierProperty("private")) {
            PsiFormatUtil.appendModifier(buffer, "private");
        }
        if ((options & 0x20) == 0 ? list.hasExplicitModifier("packageLocal") : list.hasModifierProperty("packageLocal")) {
            if (element instanceof PsiClass && element.getParent() instanceof PsiDeclarationStatement) {
                PsiFormatUtil.appendModifier(buffer, PsiBundle.message("local.class.preposition", new Object[0]));
            } else {
                PsiFormatUtil.appendModifier(buffer, PsiBundle.visibilityPresentation("packageLocal"));
            }
        }
        if ((options & 0x20) == 0 ? list.hasExplicitModifier("static") : list.hasModifierProperty("static")) {
            PsiFormatUtil.appendModifier(buffer, "static");
        }
        if (!isInterface && ((options & 0x20) == 0 ? list.hasExplicitModifier("abstract") : list.hasModifierProperty("abstract"))) {
            PsiFormatUtil.appendModifier(buffer, "abstract");
        }
        if ((options & 0x20) == 0 ? list.hasExplicitModifier("final") : list.hasModifierProperty("final")) {
            PsiFormatUtil.appendModifier(buffer, "final");
        }
        if (list.hasModifierProperty("native") && (options & 0x4000) == 0) {
            PsiFormatUtil.appendModifier(buffer, "native");
        }
        if (list.hasModifierProperty("synchronized") && (options & 0x4000) == 0) {
            PsiFormatUtil.appendModifier(buffer, "synchronized");
        }
        if (list.hasModifierProperty("strictfp") && (options & 0x4000) == 0) {
            PsiFormatUtil.appendModifier(buffer, "strictfp");
        }
        if (list.hasModifierProperty("transient") && element instanceof PsiVariable) {
            PsiFormatUtil.appendModifier(buffer, "transient");
        }
        if (list.hasModifierProperty("volatile")) {
            PsiFormatUtil.appendModifier(buffer, "volatile");
        }
    }

    private static void appendModifier(StringBuilder buffer, String modifier) {
        PsiFormatUtil.appendSpaceIfNeeded(buffer);
        buffer.append(modifier);
    }

    public static String formatReferenceList(PsiReferenceList list, int options) {
        StringBuilder buffer = new StringBuilder();
        PsiJavaCodeReferenceElement[] refs = list.getReferenceElements();
        for (int i = 0; i < refs.length; ++i) {
            PsiJavaCodeReferenceElement ref = refs[i];
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(PsiFormatUtil.formatReference(ref, options));
        }
        return buffer.toString();
    }

    public static String formatType(@Nullable PsiType type, int options, @NotNull PsiSubstitutor substitutor) {
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/util/PsiFormatUtil", "formatType"));
        }
        type = substitutor.substitute(type);
        if ((options & 0x10000) != 0) {
            type = TypeConversionUtil.erasure(type);
        } else if ((options & 0x20000) != 0 && !(PsiUtil.resolveClassInType(type) instanceof PsiTypeParameter)) {
            boolean preserveEllipsis = type instanceof PsiEllipsisType;
            type = TypeConversionUtil.erasure(type);
            if (preserveEllipsis && type instanceof PsiArrayType) {
                type = new PsiEllipsisType(((PsiArrayType)type).getComponentType());
            }
        }
        if (type == null) {
            return "null";
        }
        return (options & 0x2000) == 0 ? type.getPresentableText() : ((options & 0x40000) == 0 ? type.getCanonicalText(false) : type.getInternalCanonicalText());
    }

    public static String formatReference(PsiJavaCodeReferenceElement ref, int options) {
        return (options & 0x2000) == 0 ? ref.getText() : ref.getCanonicalText();
    }

    @Nullable
    public static String getExternalName(PsiModifierListOwner owner) {
        return PsiFormatUtil.getExternalName(owner, true);
    }

    @Nullable
    public static String getExternalName(PsiModifierListOwner owner, boolean showParamName) {
        return PsiFormatUtil.getExternalName(owner, showParamName, 7);
    }

    @Nullable
    public static String getExternalName(PsiModifierListOwner owner, boolean showParamName, int maxParamsToShow) {
        StringBuilder builder = new StringBuilder();
        if (owner instanceof PsiClass) {
            ClassUtil.formatClassName((PsiClass)owner, builder);
            return builder.toString();
        }
        PsiClass psiClass = PsiTreeUtil.getParentOfType((PsiElement)owner, PsiClass.class, false);
        if (psiClass == null) {
            return null;
        }
        ClassUtil.formatClassName(psiClass, builder);
        if (owner instanceof PsiMethod) {
            builder.append(" ");
            PsiFormatUtil.formatMethod((PsiMethod)owner, PsiSubstitutor.EMPTY, 10499, showParamName ? 8195 : 8194, maxParamsToShow, builder);
        } else if (owner instanceof PsiField) {
            builder.append(" ").append(((PsiField)owner).getName());
        } else if (owner instanceof PsiParameter) {
            PsiElement declarationScope = ((PsiParameter)owner).getDeclarationScope();
            if (!(declarationScope instanceof PsiMethod)) {
                return null;
            }
            PsiMethod psiMethod = (PsiMethod)declarationScope;
            builder.append(" ");
            PsiFormatUtil.formatMethod(psiMethod, PsiSubstitutor.EMPTY, 10499, showParamName ? 8195 : 8194, maxParamsToShow, builder);
            builder.append(" ");
            if (showParamName) {
                PsiFormatUtil.formatVariable((PsiVariable)owner, 1, PsiSubstitutor.EMPTY, builder);
            } else {
                builder.append(psiMethod.getParameterList().getParameterIndex((PsiParameter)owner));
            }
        } else {
            return null;
        }
        return builder.toString();
    }

    public static String getPackageDisplayName(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/util/PsiFormatUtil", "getPackageDisplayName"));
        }
        if (psiClass instanceof PsiTypeParameter) {
            PsiTypeParameterListOwner owner = ((PsiTypeParameter)psiClass).getOwner();
            String ownerName = null;
            if (owner instanceof PsiClass) {
                ownerName = ((PsiClass)owner).getQualifiedName();
                if (ownerName == null) {
                    ownerName = owner.getName();
                }
            } else if (owner instanceof PsiMethod) {
                ownerName = owner.getName();
            }
            return ownerName == null ? "type parameter" : "type parameter of " + ownerName;
        }
        String packageName = psiClass.getQualifiedName();
        String string = packageName = packageName == null || packageName.lastIndexOf(46) <= 0 ? "" : packageName.substring(0, packageName.lastIndexOf(46));
        if (packageName.isEmpty()) {
            packageName = "default package";
        }
        return packageName;
    }

    public static @interface FormatClassOptions {
    }

    public static @interface FormatMethodOptions {
    }

    public static @interface FormatVariableOptions {
    }
}

