/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.RemoteServerConfigurable;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfigurator;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.runtime.deployment.debug.DebugConnector;
import java.util.Comparator;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ServerType<C extends ServerConfiguration> {
    public static final ExtensionPointName<ServerType> EP_NAME = ExtensionPointName.create((String)"com.intellij.remoteServer.type");
    private final String myId;

    protected ServerType(String id) {
        this.myId = id;
    }

    public final String getId() {
        return this.myId;
    }

    @NotNull
    public abstract String getPresentableName();

    @NotNull
    public abstract Icon getIcon();

    @NotNull
    public abstract C createDefaultConfiguration();

    @NotNull
    public RemoteServerConfigurable createServerConfigurable(@NotNull C configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/remoteServer/ServerType", "createServerConfigurable"));
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public UnnamedConfigurable createConfigurable(@NotNull C configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/remoteServer/ServerType", "createConfigurable"));
        }
        RemoteServerConfigurable remoteServerConfigurable = this.createServerConfigurable(configuration);
        if (remoteServerConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/ServerType", "createConfigurable"));
        }
        return remoteServerConfigurable;
    }

    @NotNull
    public abstract DeploymentConfigurator<?, C> createDeploymentConfigurator(Project var1);

    @NotNull
    public abstract ServerConnector<?> createConnector(@NotNull C var1, @NotNull ServerTaskExecutor var2);

    @NotNull
    public ServerConnector<?> createConnector(@NotNull RemoteServer<C> server, @NotNull ServerTaskExecutor asyncTasksExecutor) {
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/remoteServer/ServerType", "createConnector"));
        }
        if (asyncTasksExecutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asyncTasksExecutor", "com/intellij/remoteServer/ServerType", "createConnector"));
        }
        ServerConnector<?> serverConnector = this.createConnector(server.getConfiguration(), asyncTasksExecutor);
        if (serverConnector == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/ServerType", "createConnector"));
        }
        return serverConnector;
    }

    @Nullable
    public DebugConnector<?, ?> createDebugConnector() {
        return null;
    }

    @NotNull
    public Comparator<Deployment> getDeploymentComparator() {
        Comparator<Deployment> comparator = new Comparator<Deployment>(){

            @Override
            public int compare(Deployment o1, Deployment o2) {
                return o1.getName().compareTo(o2.getName());
            }
        };
        if (comparator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/ServerType", "getDeploymentComparator"));
        }
        return comparator;
    }

    @Nullable
    public String getCustomToolWindowId() {
        return null;
    }
}

