/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;

abstract class BaseFix
implements LocalQuickFix {
    protected final SmartPsiElementPointer<? extends PsiElement> myPointer;
    protected final boolean myOnTheFly;

    protected BaseFix(@NotNull SmartPsiElementPointer<? extends PsiElement> pointer, boolean onTheFly) {
        if (pointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "org/jetbrains/idea/devkit/inspections/quickfix/BaseFix", "<init>"));
        }
        this.myPointer = pointer;
        this.myOnTheFly = onTheFly;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        boolean external;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/devkit/inspections/quickfix/BaseFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/idea/devkit/inspections/quickfix/BaseFix", "applyFix"));
        }
        PsiElement element = this.myPointer.getElement();
        if (element == null || !element.isValid()) {
            return;
        }
        boolean bl = external = descriptor.getPsiElement().getContainingFile() != element.getContainingFile();
        if (external) {
            VirtualFile[] files;
            PsiClass clazz = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class, (boolean)false);
            ReadonlyStatusHandler readonlyStatusHandler = ReadonlyStatusHandler.getInstance((Project)project);
            ReadonlyStatusHandler.OperationStatus status = readonlyStatusHandler.ensureFilesWritable(files = new VirtualFile[]{element.getContainingFile().getVirtualFile()});
            if (status.hasReadonlyFiles()) {
                String className = clazz != null ? clazz.getQualifiedName() : element.getContainingFile().getName();
                Messages.showMessageDialog((Project)project, (String)DevKitBundle.message("inspections.registration.problems.quickfix.read-only", className), (String)this.getName(), (Icon)Messages.getErrorIcon());
                return;
            }
        }
        try {
            this.doFix(project, descriptor, external);
        }
        catch (IncorrectOperationException e) {
            Logger.getInstance((String)("#" + this.getClass().getName())).error((Throwable)e);
        }
    }

    protected abstract void doFix(Project var1, ProblemDescriptor var2, boolean var3) throws IncorrectOperationException;
}

