/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.deserialization;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.serialization.ClassData;
import org.jetbrains.kotlin.serialization.ClassDataWithSource;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.SerializedResourcePaths;
import org.jetbrains.kotlin.serialization.deserialization.ClassDataFinder;
import org.jetbrains.kotlin.serialization.deserialization.DeserializedPackageFragment;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0007\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u001c\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/serialization/deserialization/ResourceLoadingClassDataFinder;", "Lorg/jetbrains/kotlin/serialization/deserialization/ClassDataFinder;", "packageFragmentProvider", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentProvider;", "serializedResourcePaths", "Lorg/jetbrains/kotlin/serialization/SerializedResourcePaths;", "loadResource", "Lkotlin/Function1;", "", "Ljava/io/InputStream;", "(Lorg/jetbrains/kotlin/descriptors/PackageFragmentProvider;Lorg/jetbrains/kotlin/serialization/SerializedResourcePaths;Lkotlin/jvm/functions/Function1;)V", "findClassData", "Lorg/jetbrains/kotlin/serialization/ClassDataWithSource;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "deserialization"})
public final class ResourceLoadingClassDataFinder
implements ClassDataFinder {
    private final PackageFragmentProvider packageFragmentProvider;
    private final SerializedResourcePaths serializedResourcePaths;
    private final Function1<String, InputStream> loadResource;

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public ClassDataWithSource findClassData(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        FqName fqName = classId.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName, (String)"classId.packageFqName");
        Object object = CollectionsKt.singleOrNull((List)this.packageFragmentProvider.getPackageFragments(fqName));
        if (!(object instanceof DeserializedPackageFragment)) {
            object = null;
        }
        DeserializedPackageFragment deserializedPackageFragment = (DeserializedPackageFragment)((Object)object);
        if (deserializedPackageFragment == null) {
            return null;
        }
        DeserializedPackageFragment packageFragment = deserializedPackageFragment;
        Map<ClassId, ProtoBuf.Class> map = packageFragment.getClassIdToProto();
        if (map == null || (map = map.get(classId)) == null) {
            void $receiver$iv;
            ResourceLoadingClassDataFinder resourceLoadingClassDataFinder = this;
            ResourceLoadingClassDataFinder $receiver = (ResourceLoadingClassDataFinder)$receiver$iv;
            InputStream inputStream = (InputStream)$receiver.loadResource.invoke((Object)$receiver.serializedResourcePaths.getClassMetadataPath(classId));
            if (inputStream == null) {
                return null;
            }
            InputStream stream = inputStream;
            map = ProtoBuf.Class.parseFrom(stream, $receiver.serializedResourcePaths.getExtensionRegistry());
        }
        Map<ClassId, ProtoBuf.Class> classProto = map;
        NameResolver nameResolver = packageFragment.getNameResolver();
        Map<ClassId, ProtoBuf.Class> map2 = classProto;
        Intrinsics.checkExpressionValueIsNotNull((Object)map2, (String)"classProto");
        return new ClassDataWithSource(new ClassData(nameResolver, (ProtoBuf.Class)((Object)map2)), null, 2, null);
    }

    public ResourceLoadingClassDataFinder(@NotNull PackageFragmentProvider packageFragmentProvider, @NotNull SerializedResourcePaths serializedResourcePaths, @NotNull Function1<? super String, ? extends InputStream> loadResource) {
        Intrinsics.checkParameterIsNotNull((Object)packageFragmentProvider, (String)"packageFragmentProvider");
        Intrinsics.checkParameterIsNotNull((Object)serializedResourcePaths, (String)"serializedResourcePaths");
        Intrinsics.checkParameterIsNotNull(loadResource, (String)"loadResource");
        this.packageFragmentProvider = packageFragmentProvider;
        this.serializedResourcePaths = serializedResourcePaths;
        this.loadResource = loadResource;
    }
}

