/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding;

import com.android.tools.idea.databinding.DataBindingProjectComponent;
import com.android.tools.idea.databinding.DataBindingUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrShortNamesCache
extends PsiShortNamesCache {
    private final DataBindingProjectComponent myComponent;
    private CachedValue<String[]> myAllFieldNamesCache;
    private static final String[] BR_CLASS_NAME_LIST = new String[]{"BR"};

    public BrShortNamesCache(DataBindingProjectComponent dataBindingProjectComponent) {
        this.myComponent = dataBindingProjectComponent;
        this.myAllFieldNamesCache = CachedValuesManager.getManager((Project)this.myComponent.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<String[]>(){

            @Nullable
            public CachedValueProvider.Result<String[]> compute() {
                String[] result;
                AndroidFacet[] facets = BrShortNamesCache.this.myComponent.getDataBindingEnabledFacets();
                if (facets.length == 0) {
                    result = ArrayUtil.EMPTY_STRING_ARRAY;
                } else {
                    java.util.HashSet allFields = Sets.newHashSet();
                    for (AndroidFacet facet : facets) {
                        DataBindingUtil.LightBrClass brClass = DataBindingUtil.getOrCreateBrClassFor(facet);
                        Collections.addAll(allFields, brClass.getAllFieldNames());
                    }
                    result = ArrayUtil.toStringArray((Collection)allFields);
                }
                return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{BrShortNamesCache.this.myComponent});
            }
        }, false);
    }

    private boolean isMyScope(GlobalSearchScope scope) {
        if (!this.myComponent.hasAnyDataBindingEnabledFacet()) {
            return false;
        }
        if (scope.getProject() == null) {
            return false;
        }
        return this.myComponent.getProject().equals(scope.getProject());
    }

    @NotNull
    public PsiClass[] getClassesByName(@NotNull @NonNls String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/databinding/BrShortNamesCache", "getClassesByName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/databinding/BrShortNamesCache", "getClassesByName"));
        }
        if (!this.isMyScope(scope)) {
            if (PsiClass.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/BrShortNamesCache", "getClassesByName"));
            }
            return PsiClass.EMPTY_ARRAY;
        }
        if (!"BR".equals(name)) {
            if (PsiClass.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/BrShortNamesCache", "getClassesByName"));
            }
            return PsiClass.EMPTY_ARRAY;
        }
        AndroidFacet[] facets = this.myComponent.getDataBindingEnabledFacets();
        PsiClass[] psiClassArray = BrShortNamesCache.filterByScope(facets, scope);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/BrShortNamesCache", "getClassesByName"));
        }
        return psiClassArray;
    }

    @NotNull
    public String[] getAllClassNames() {
        if (!this.myComponent.hasAnyDataBindingEnabledFacet()) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/BrShortNamesCache", "getAllClassNames"));
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        if (BR_CLASS_NAME_LIST == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/BrShortNamesCache", "getAllClassNames"));
        }
        return BR_CLASS_NAME_LIST;
    }

    public void getAllClassNames(@NotNull HashSet<String> dest) {
        if (dest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dest", "com/android/tools/idea/databinding/BrShortNamesCache", "getAllClassNames"));
        }
        if (!this.myComponent.hasAnyDataBindingEnabledFacet()) {
            return;
        }
        dest.add((Object)"BR");
    }

    @NotNull
    public PsiMethod[] getMethodsByName(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/databinding/BrShortNamesCache", "getMethodsByName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/databinding/BrShortNamesCache", "getMethodsByName"));
        }
        if (PsiMethod.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/BrShortNamesCache", "getMethodsByName"));
        }
        return PsiMethod.EMPTY_ARRAY;
    }

    @NotNull
    public PsiMethod[] getMethodsByNameIfNotMoreThan(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope, int maxCount) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/databinding/BrShortNamesCache", "getMethodsByNameIfNotMoreThan"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/databinding/BrShortNamesCache", "getMethodsByNameIfNotMoreThan"));
        }
        if (PsiMethod.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/BrShortNamesCache", "getMethodsByNameIfNotMoreThan"));
        }
        return PsiMethod.EMPTY_ARRAY;
    }

    @NotNull
    public PsiField[] getFieldsByNameIfNotMoreThan(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope, int maxCount) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/databinding/BrShortNamesCache", "getFieldsByNameIfNotMoreThan"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/databinding/BrShortNamesCache", "getFieldsByNameIfNotMoreThan"));
        }
        PsiField[] fields = this.getFieldsByName(name, scope);
        if (fields.length > maxCount) {
            if (PsiField.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/BrShortNamesCache", "getFieldsByNameIfNotMoreThan"));
            }
            return PsiField.EMPTY_ARRAY;
        }
        if (fields == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/BrShortNamesCache", "getFieldsByNameIfNotMoreThan"));
        }
        return fields;
    }

    public boolean processMethodsWithName(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiMethod> processor) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/databinding/BrShortNamesCache", "processMethodsWithName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/databinding/BrShortNamesCache", "processMethodsWithName"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/android/tools/idea/databinding/BrShortNamesCache", "processMethodsWithName"));
        }
        return true;
    }

    @NotNull
    public String[] getAllMethodNames() {
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/BrShortNamesCache", "getAllMethodNames"));
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public void getAllMethodNames(@NotNull HashSet<String> set) {
        if (set == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/android/tools/idea/databinding/BrShortNamesCache", "getAllMethodNames"));
        }
    }

    @NotNull
    public PsiField[] getFieldsByName(@NotNull @NonNls String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/databinding/BrShortNamesCache", "getFieldsByName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/databinding/BrShortNamesCache", "getFieldsByName"));
        }
        if (!this.isMyScope(scope)) {
            if (PsiField.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/BrShortNamesCache", "getFieldsByName"));
            }
            return PsiField.EMPTY_ARRAY;
        }
        PsiClass[] psiClasses = BrShortNamesCache.filterByScope(this.myComponent.getDataBindingEnabledFacets(), scope);
        if (psiClasses.length == 0) {
            if (PsiField.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/BrShortNamesCache", "getFieldsByName"));
            }
            return PsiField.EMPTY_ARRAY;
        }
        ArrayList result = Lists.newArrayList();
        for (PsiClass psiClass : psiClasses) {
            PsiField field = psiClass.findFieldByName(name, false);
            if (field == null) continue;
            result.add(field);
        }
        PsiField[] psiFieldArray = result.toArray(new PsiField[result.size()]);
        if (psiFieldArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/BrShortNamesCache", "getFieldsByName"));
        }
        return psiFieldArray;
    }

    @NotNull
    public String[] getAllFieldNames() {
        if (!this.myComponent.hasAnyDataBindingEnabledFacet()) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/BrShortNamesCache", "getAllFieldNames"));
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        String[] stringArray = (String[])this.myAllFieldNamesCache.getValue();
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/databinding/BrShortNamesCache", "getAllFieldNames"));
        }
        return stringArray;
    }

    public void getAllFieldNames(@NotNull HashSet<String> set) {
        if (set == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/android/tools/idea/databinding/BrShortNamesCache", "getAllFieldNames"));
        }
        Collections.addAll(set, this.getAllFieldNames());
    }

    private static PsiClass[] filterByScope(AndroidFacet[] facets, @NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/databinding/BrShortNamesCache", "filterByScope"));
        }
        if (facets == null || facets.length == 0) {
            return PsiClass.EMPTY_ARRAY;
        }
        ArrayList selected = Lists.newArrayList();
        for (AndroidFacet facet : facets) {
            if (!scope.isSearchInModuleContent(facet.getModule())) continue;
            selected.add(DataBindingUtil.getOrCreateBrClassFor(facet));
        }
        if (selected.size() == 0) {
            return PsiClass.EMPTY_ARRAY;
        }
        return selected.toArray(new PsiClass[selected.size()]);
    }
}

