/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.service;

import com.android.tools.idea.editors.gfxtrace.service.ServiceClient;
import com.android.tools.idea.editors.gfxtrace.service.ServiceClientWrapper;
import com.android.tools.idea.editors.gfxtrace.service.path.Path;
import com.android.tools.rpclib.schema.Message;
import com.google.common.base.Function;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.diagnostic.Logger;

public class ServiceClientCache
extends ServiceClientWrapper {
    private static final Logger LOG = Logger.getInstance(ServiceClientCache.class);
    private ListenableFuture<Message> mySchema;
    private final Object mySchemaLock = new Object();
    private final Cache<Path, Object> myPathCache = CacheBuilder.newBuilder().softValues().build();

    public ServiceClientCache(ServiceClient client) {
        super(client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListenableFuture<Message> getSchema() {
        Object object = this.mySchemaLock;
        synchronized (object) {
            if (this.mySchema == null) {
                this.mySchema = this.myClient.getSchema();
            }
        }
        return this.mySchema;
    }

    @Override
    public ListenableFuture<Object> get(final Path p) {
        LOG.debug("Getting " + p);
        Object result = this.myPathCache.getIfPresent((Object)p);
        if (result != null) {
            return Futures.immediateFuture((Object)result);
        }
        return Futures.transform(this.myClient.get(p), (Function)new Function<Object, Object>(){

            public Object apply(Object result) {
                ServiceClientCache.this.myPathCache.put((Object)p, result);
                return result;
            }
        });
    }
}

