/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationListener;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.ThemeResolver;
import com.android.tools.idea.editors.theme.datamodels.ThemeEditorStyle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemeEditorContext
implements Disposable {
    @NotNull
    private Configuration myConfiguration;
    @Nullable
    private ThemeEditorStyle myCurrentTheme;
    @NotNull
    private ThemeResolver myThemeResolver;
    private final List<ChangeListener> myChangeListeners;
    private final List<ConfigurationListener> myConfigurationListeners;
    private boolean myEnabledListeners;
    private final ConfigurationListener myConfigurationListener;

    public ThemeEditorContext(@NotNull Configuration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/editors/theme/ThemeEditorContext", "<init>"));
        }
        this.myChangeListeners = new ArrayList<ChangeListener>();
        this.myConfigurationListeners = new ArrayList<ConfigurationListener>();
        this.myEnabledListeners = true;
        this.myConfigurationListener = new ConfigurationListener(){

            @Override
            public boolean changed(int flags) {
                if (!ThemeEditorContext.this.myEnabledListeners) {
                    return true;
                }
                boolean accepted = true;
                for (ConfigurationListener listener : ThemeEditorContext.this.myConfigurationListeners) {
                    accepted &= listener.changed(flags);
                }
                return accepted;
            }
        };
        this.setConfiguration(configuration);
        this.addConfigurationListener(new ConfigurationListener(){

            @Override
            public boolean changed(int flags) {
                if ((0xF6 & flags) != 0) {
                    ThemeEditorContext.this.updateThemeResolver();
                }
                return true;
            }
        });
    }

    public void updateThemeResolver() {
        this.myEnabledListeners = false;
        this.myConfiguration.setTheme(null);
        this.myEnabledListeners = true;
        this.myThemeResolver = new ThemeResolver(this.myConfiguration);
    }

    @NotNull
    public Configuration getConfiguration() {
        Configuration configuration = this.myConfiguration;
        if (configuration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorContext", "getConfiguration"));
        }
        return configuration;
    }

    @NotNull
    public Module getCurrentContextModule() {
        Module module = this.myConfiguration.getModule();
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorContext", "getCurrentContextModule"));
        }
        return module;
    }

    public void setCurrentTheme(@Nullable ThemeEditorStyle currentTheme) {
        this.myCurrentTheme = currentTheme;
    }

    @Nullable
    public ThemeEditorStyle getCurrentTheme() {
        return this.myCurrentTheme;
    }

    @NotNull
    public Module getModuleForResources() {
        if (this.myCurrentTheme != null && this.myCurrentTheme.getSourceModule() != null) {
            Module module = this.myCurrentTheme.getSourceModule();
            if (module == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorContext", "getModuleForResources"));
            }
            return module;
        }
        Module module = this.myConfiguration.getModule();
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorContext", "getModuleForResources"));
        }
        return module;
    }

    public void setCurrentContextModule(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/editors/theme/ThemeEditorContext", "setCurrentContextModule"));
        }
        this.setConfiguration(ThemeEditorUtils.getConfigurationForModule(module));
    }

    @Nullable(value="if there is no theme selected or the current selected module is not valid")
    public ResourceResolver getResourceResolver() {
        if (this.getCurrentContextModule().isDisposed()) {
            return null;
        }
        return this.myConfiguration.getResourceResolver();
    }

    @NotNull
    public Project getProject() {
        Project project = this.myConfiguration.getModule().getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorContext", "getProject"));
        }
        return project;
    }

    public void addConfigurationListener(@NotNull ConfigurationListener configurationListener) {
        if (configurationListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationListener", "com/android/tools/idea/editors/theme/ThemeEditorContext", "addConfigurationListener"));
        }
        this.myConfigurationListeners.add(configurationListener);
    }

    @NotNull
    public ThemeResolver getThemeResolver() {
        ThemeResolver themeResolver = this.myThemeResolver;
        if (themeResolver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorContext", "getThemeResolver"));
        }
        return themeResolver;
    }

    public void setConfiguration(@NotNull Configuration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/editors/theme/ThemeEditorContext", "setConfiguration"));
        }
        if (this.myConfiguration != null) {
            this.myConfiguration.removeListener(this.myConfigurationListener);
        }
        this.myConfiguration = configuration;
        this.updateThemeResolver();
        this.myConfiguration.addListener(this.myConfigurationListener);
        this.fireNewConfiguration();
    }

    public void addChangeListener(ChangeListener listener) {
        this.myChangeListeners.add(listener);
    }

    private void fireNewConfiguration() {
        for (ChangeListener listener : this.myChangeListeners) {
            listener.onNewConfiguration(this);
        }
    }

    public void dispose() {
        this.myConfiguration.removeListener(this.myConfigurationListener);
        this.myConfigurationListeners.clear();
    }

    public static interface ChangeListener {
        public void onNewConfiguration(ThemeEditorContext var1);
    }
}

