/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.actions;

import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.startup.AndroidStudioInitializer;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidStudioGradleAction
extends AnAction {
    public AndroidStudioGradleAction(@Nullable String text) {
        super(text);
    }

    public AndroidStudioGradleAction(@Nullable String text, @Nullable String description, @Nullable Icon icon) {
        super(text, description, icon);
    }

    public final void update(AnActionEvent e) {
        if (!AndroidStudioGradleAction.isGradleProjectInAndroidStudio(e)) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setEnabledAndVisible(true);
        Project project = e.getProject();
        assert (project != null);
        this.doUpdate(e, project);
    }

    protected abstract void doUpdate(@NotNull AnActionEvent var1, @NotNull Project var2);

    public final void actionPerformed(AnActionEvent e) {
        if (!AndroidStudioGradleAction.isGradleProjectInAndroidStudio(e)) {
            return;
        }
        Project project = e.getProject();
        assert (project != null);
        this.doPerform(e, project);
    }

    protected abstract void doPerform(@NotNull AnActionEvent var1, @NotNull Project var2);

    private static boolean isGradleProjectInAndroidStudio(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/gradle/actions/AndroidStudioGradleAction", "isGradleProjectInAndroidStudio"));
        }
        if (!AndroidStudioInitializer.isAndroidStudio()) {
            return false;
        }
        Project project = e.getProject();
        return project != null && Projects.isBuildWithGradle(project);
    }
}

