/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.editor.entity;

import com.android.tools.idea.gradle.editor.entity.GradleEditorEntity;
import com.android.tools.idea.gradle.editor.entity.GradleEditorSourceBinding;
import com.android.tools.idea.gradle.editor.metadata.GradleEditorEntityMetaData;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGradleEditorEntity
implements GradleEditorEntity {
    @NotNull
    private final Set<GradleEditorEntityMetaData> myMetaData;
    @NotNull
    private final GradleEditorSourceBinding myEntityLocation;
    @Nullable
    private final String myHelpUrl;

    protected AbstractGradleEditorEntity(@NotNull GradleEditorSourceBinding entityLocation, @NotNull Set<GradleEditorEntityMetaData> metaData, @Nullable String helpUrl) {
        if (entityLocation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entityLocation", "com/android/tools/idea/gradle/editor/entity/AbstractGradleEditorEntity", "<init>"));
        }
        if (metaData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaData", "com/android/tools/idea/gradle/editor/entity/AbstractGradleEditorEntity", "<init>"));
        }
        this.myEntityLocation = entityLocation;
        this.myMetaData = ImmutableSet.copyOf(metaData);
        this.myHelpUrl = helpUrl;
    }

    @Override
    @NotNull
    public GradleEditorSourceBinding getEntityLocation() {
        GradleEditorSourceBinding gradleEditorSourceBinding = this.myEntityLocation;
        if (gradleEditorSourceBinding == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/editor/entity/AbstractGradleEditorEntity", "getEntityLocation"));
        }
        return gradleEditorSourceBinding;
    }

    @Override
    @NotNull
    public Set<GradleEditorEntityMetaData> getMetaData() {
        Set<GradleEditorEntityMetaData> set = this.myMetaData;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/editor/entity/AbstractGradleEditorEntity", "getMetaData"));
        }
        return set;
    }

    @Override
    @Nullable
    public String getHelpId() {
        return this.myHelpUrl;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myEntityLocation);
    }
}

