/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.module.Module;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public final class Facets {
    private Facets() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Facet> void removeAllFacetsOfType(@NotNull Module module, @NotNull FacetTypeId<T> typeId) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/util/Facets", "removeAllFacetsOfType"));
        }
        if (typeId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeId", "com/android/tools/idea/gradle/util/Facets", "removeAllFacetsOfType"));
        }
        FacetManager facetManager = FacetManager.getInstance((Module)module);
        Collection facets = facetManager.getFacetsByType(typeId);
        if (!facets.isEmpty()) {
            ModifiableFacetModel model = facetManager.createModifiableModel();
            try {
                for (Facet facet : facets) {
                    model.removeFacet(facet);
                }
            }
            finally {
                model.commit();
            }
        }
    }

    public static <T extends Facet> void removeAllFacetsOfType(@NotNull FacetTypeId<T> typeId, @NotNull ModifiableFacetModel modifiableFacetModel) {
        if (typeId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeId", "com/android/tools/idea/gradle/util/Facets", "removeAllFacetsOfType"));
        }
        if (modifiableFacetModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiableFacetModel", "com/android/tools/idea/gradle/util/Facets", "removeAllFacetsOfType"));
        }
        Collection facets = modifiableFacetModel.getFacetsByType(typeId);
        if (!facets.isEmpty()) {
            for (Facet facet : facets) {
                modifiableFacetModel.removeFacet(facet);
            }
        }
    }
}

