/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lang.databinding;

import com.android.tools.idea.lang.databinding._DbLexer;
import com.android.tools.idea.lang.databinding.psi.DbTokenTypes;
import com.google.common.collect.Maps;
import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.io.Reader;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSyntaxHighlighterFactory
extends SyntaxHighlighterFactory {
    @NotNull
    public SyntaxHighlighter getSyntaxHighlighter(@Nullable Project project, @Nullable VirtualFile virtualFile) {
        DbSyntaxHighlighter dbSyntaxHighlighter = new DbSyntaxHighlighter();
        if (dbSyntaxHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lang/databinding/DbSyntaxHighlighterFactory", "getSyntaxHighlighter"));
        }
        return dbSyntaxHighlighter;
    }

    private static class DbSyntaxHighlighter
    extends SyntaxHighlighterBase {
        private static final Map<IElementType, TextAttributesKey> sAttributes = Maps.newHashMapWithExpectedSize((int)50);

        private DbSyntaxHighlighter() {
        }

        @NotNull
        public Lexer getHighlightingLexer() {
            FlexAdapter flexAdapter = new FlexAdapter((FlexLexer)new _DbLexer((Reader)null));
            if (flexAdapter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lang/databinding/DbSyntaxHighlighterFactory$DbSyntaxHighlighter", "getHighlightingLexer"));
            }
            return flexAdapter;
        }

        @NotNull
        public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
            TextAttributesKey[] textAttributesKeyArray = DbSyntaxHighlighter.pack((TextAttributesKey)sAttributes.get(tokenType));
            if (textAttributesKeyArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lang/databinding/DbSyntaxHighlighterFactory$DbSyntaxHighlighter", "getTokenHighlights"));
            }
            return textAttributesKeyArray;
        }

        static {
            TokenSet keywords = TokenSet.create((IElementType[])new IElementType[]{DbTokenTypes.BOOLEAN_KEYWORD, DbTokenTypes.BYTE_KEYWORD, DbTokenTypes.CHAR_KEYWORD, DbTokenTypes.SHORT_KEYWORD, DbTokenTypes.INT_KEYWORD, DbTokenTypes.LONG_KEYWORD, DbTokenTypes.FLOAT_KEYWORD, DbTokenTypes.DOUBLE_KEYWORD, DbTokenTypes.VOID_KEYWORD, DbTokenTypes.CLASS_KEYWORD, DbTokenTypes.INSTANCEOF_KEYWORD, DbTokenTypes.DEFAULT_KEYWORD, DbTokenTypes.TRUE, DbTokenTypes.FALSE, DbTokenTypes.NULL});
            TokenSet brackets = TokenSet.create((IElementType[])new IElementType[]{DbTokenTypes.LBRACKET, DbTokenTypes.RBRACKET});
            TokenSet parentheses = TokenSet.create((IElementType[])new IElementType[]{DbTokenTypes.LPARENTH, DbTokenTypes.RPARENTH});
            TokenSet numbers = TokenSet.create((IElementType[])new IElementType[]{DbTokenTypes.INTEGER_LITERAL, DbTokenTypes.FLOAT_LITERAL, DbTokenTypes.LONG_LITERAL, DbTokenTypes.DOUBLE_LITERAL});
            TokenSet operators = TokenSet.create((IElementType[])new IElementType[]{DbTokenTypes.EQEQ, DbTokenTypes.NE, DbTokenTypes.LE, DbTokenTypes.LTLT, DbTokenTypes.LT, DbTokenTypes.GTGTGT, DbTokenTypes.GTGT, DbTokenTypes.GTEQ, DbTokenTypes.GT, DbTokenTypes.EQ, DbTokenTypes.EXCL, DbTokenTypes.TILDE, DbTokenTypes.QUESTQUEST, DbTokenTypes.QUEST, DbTokenTypes.COLON, DbTokenTypes.PLUS, DbTokenTypes.MINUS, DbTokenTypes.ASTERISK, DbTokenTypes.DIV, DbTokenTypes.ANDAND, DbTokenTypes.AND, DbTokenTypes.OROR, DbTokenTypes.OR, DbTokenTypes.XOR});
            TokenSet strings = TokenSet.create((IElementType[])new IElementType[]{DbTokenTypes.STRING_LITERAL, DbTokenTypes.CHARACTER_LITERAL});
            DbSyntaxHighlighter.fillMap(sAttributes, (TokenSet)keywords, (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
            DbSyntaxHighlighter.fillMap(sAttributes, (TokenSet)brackets, (TextAttributesKey)DefaultLanguageHighlighterColors.BRACKETS);
            DbSyntaxHighlighter.fillMap(sAttributes, (TokenSet)parentheses, (TextAttributesKey)DefaultLanguageHighlighterColors.PARENTHESES);
            DbSyntaxHighlighter.fillMap(sAttributes, (TokenSet)numbers, (TextAttributesKey)DefaultLanguageHighlighterColors.NUMBER);
            DbSyntaxHighlighter.fillMap(sAttributes, (TokenSet)operators, (TextAttributesKey)DefaultLanguageHighlighterColors.OPERATION_SIGN);
            DbSyntaxHighlighter.fillMap(sAttributes, (TokenSet)strings, (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
            sAttributes.put(DbTokenTypes.RESOURCE_REFERENCE, DefaultLanguageHighlighterColors.MARKUP_ATTRIBUTE);
            sAttributes.put(DbTokenTypes.IDENTIFIER, DefaultLanguageHighlighterColors.IDENTIFIER);
            sAttributes.put(DbTokenTypes.DOT, DefaultLanguageHighlighterColors.DOT);
            sAttributes.put(DbTokenTypes.COMMA, DefaultLanguageHighlighterColors.COMMA);
        }
    }
}

