/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lang.databinding;

import com.android.tools.idea.lang.databinding.DbFile;
import com.android.tools.idea.lang.databinding.psi.DbTokenTypes;
import com.android.tools.idea.lang.databinding.psi.PsiDbConstantValue;
import com.android.tools.idea.lang.databinding.psi.PsiDbDefaults;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class DbUtil {
    public static String getBindingExprDefault(@NotNull XmlAttribute psiAttribute) {
        if (psiAttribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiAttribute", "com/android/tools/idea/lang/databinding/DbUtil", "getBindingExprDefault"));
        }
        XmlAttributeValue attrValue = psiAttribute.getValueElement();
        if (attrValue instanceof PsiLanguageInjectionHost) {
            PsiDbDefaults defaults;
            final Ref injections = Ref.create();
            InjectedLanguageUtil.enumerate((PsiElement)attrValue, (PsiLanguageInjectionHost.InjectedPsiVisitor)new PsiLanguageInjectionHost.InjectedPsiVisitor(){

                public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                    if (injectedPsi == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedPsi", "com/android/tools/idea/lang/databinding/DbUtil$1", "visit"));
                    }
                    if (places == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "places", "com/android/tools/idea/lang/databinding/DbUtil$1", "visit"));
                    }
                    if (injectedPsi instanceof DbFile) {
                        injections.set((Object)injectedPsi);
                    }
                }
            });
            if (injections.get() != null && (defaults = (PsiDbDefaults)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)injections.get()), PsiDbDefaults.class)) != null) {
                PsiDbConstantValue constantValue = defaults.getConstantValue();
                if (constantValue.getNode().getElementType() == DbTokenTypes.STRING_LITERAL) {
                    String text = constantValue.getText();
                    return text.substring(1, text.length() - 1);
                }
                return constantValue.getText();
            }
        }
        return null;
    }

    public static String getBindingExprDefault(@NotNull String exprn) {
        if (exprn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exprn", "com/android/tools/idea/lang/databinding/DbUtil", "getBindingExprDefault"));
        }
        if (!exprn.contains(DbTokenTypes.DEFAULT_KEYWORD.toString())) {
            return null;
        }
        Pattern defaultCheck = Pattern.compile(",\\s*default\\s*=\\s*");
        int index = 0;
        Matcher matcher = defaultCheck.matcher(exprn);
        while (matcher.find()) {
            index = matcher.end();
        }
        String def = exprn.substring(index, exprn.length() - 1).trim();
        if (def.startsWith("\"") && def.endsWith("\"")) {
            def = def.substring(1, def.length() - 1);
        }
        return def;
    }

    private DbUtil() {
    }
}

