/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profiling.capture;

import com.android.tools.idea.profiling.capture.Capture;
import com.android.tools.idea.profiling.capture.CaptureType;
import com.android.utils.SdkUtils;
import com.intellij.openapi.vfs.VirtualFile;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class FileCaptureType
extends CaptureType {
    @NotNull
    private String myName;
    @NotNull
    private Icon myIcon;
    @NotNull
    private String myFileNamePrefix;
    @NotNull
    private String myFileNameExtension;

    protected FileCaptureType(@NotNull String name, @NotNull Icon icon, @NotNull String fileNamePrefix, @NotNull String fileNameExtension) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/profiling/capture/FileCaptureType", "<init>"));
        }
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/android/tools/idea/profiling/capture/FileCaptureType", "<init>"));
        }
        if (fileNamePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileNamePrefix", "com/android/tools/idea/profiling/capture/FileCaptureType", "<init>"));
        }
        if (fileNameExtension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileNameExtension", "com/android/tools/idea/profiling/capture/FileCaptureType", "<init>"));
        }
        this.myName = name;
        this.myIcon = icon;
        this.myFileNamePrefix = fileNamePrefix;
        this.myFileNameExtension = fileNameExtension;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/profiling/capture/FileCaptureType", "getName"));
        }
        return string;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = this.myIcon;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/profiling/capture/FileCaptureType", "getIcon"));
        }
        return icon;
    }

    @Override
    public boolean isValidCapture(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/profiling/capture/FileCaptureType", "isValidCapture"));
        }
        return this.isValidCapture(file.getPath());
    }

    public boolean isValidCapture(@NotNull String filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/android/tools/idea/profiling/capture/FileCaptureType", "isValidCapture"));
        }
        return SdkUtils.endsWithIgnoreCase((String)filePath, (String)this.myFileNameExtension);
    }

    @Override
    @NotNull
    public String createCaptureFileName() {
        String string = this.myFileNamePrefix + new SimpleDateFormat("yyyy.MM.dd_HH.mm.ss").format(new Date()) + this.myFileNameExtension;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/profiling/capture/FileCaptureType", "createCaptureFileName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected Capture createCapture(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/profiling/capture/FileCaptureType", "createCapture"));
        }
        Capture capture = new Capture(file, this);
        if (capture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/profiling/capture/FileCaptureType", "createCapture"));
        }
        return capture;
    }
}

