/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.LayoutLog;
import com.android.tools.idea.rendering.InconvertibleClassError;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Shorts;
import com.intellij.openapi.util.SystemInfo;
import java.lang.reflect.Method;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;

public class ClassConverter {
    private static final String ORIGINAL_SUFFIX = "_Original";
    private static final String ERROR_METHOD_DESCRIPTION;

    @NotNull
    public static byte[] rewriteClass(@NotNull byte[] classData) {
        if (classData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classData", "com/android/tools/idea/rendering/ClassConverter", "rewriteClass"));
        }
        int current = ClassConverter.getCurrentClassVersion();
        byte[] byArray = ClassConverter.rewriteClass(classData, current, 0);
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/ClassConverter", "rewriteClass"));
        }
        return byArray;
    }

    @NotNull
    public static byte[] rewriteClass(@NotNull byte[] classData, final int maxVersion, final int minVersion) {
        if (classData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classData", "com/android/tools/idea/rendering/ClassConverter", "rewriteClass"));
        }
        assert (maxVersion >= minVersion);
        ClassWriter classWriter = new ClassWriter(0);
        ClassVisitor classVisitor = new ClassVisitor(327680, (ClassVisitor)classWriter){
            private String myClassName;

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                this.myClassName = name;
                if (version > maxVersion) {
                    version = maxVersion;
                }
                if (version < minVersion) {
                    version = minVersion;
                }
                super.visit(version, access, name, signature, superName, interfaces);
            }

            private void wrapMethod(int access, String name, String desc, String signature, String[] exceptions) {
                assert (Type.getReturnType((String)desc) == Type.VOID_TYPE) : "Non void return methods are not supported";
                MethodVisitor mw = super.visitMethod(access, name, desc, signature, exceptions);
                Label tryStart = new Label();
                Label tryEnd = new Label();
                Label tryHandler = new Label();
                mw.visitTryCatchBlock(tryStart, tryEnd, tryHandler, "java/lang/Throwable");
                mw.visitLabel(tryStart);
                mw.visitVarInsn(25, 0);
                Type[] argumentTypes = Type.getMethodType((String)desc).getArgumentTypes();
                int nLocals = 1;
                for (Type argType : argumentTypes) {
                    mw.visitVarInsn(argType.getOpcode(21), nLocals++);
                }
                mw.visitMethodInsn(182, this.myClassName, name + ClassConverter.ORIGINAL_SUFFIX, desc, false);
                mw.visitLabel(tryEnd);
                Label exit = new Label();
                mw.visitJumpInsn(167, exit);
                mw.visitLabel(tryHandler);
                mw.visitFrame(4, 0, null, 1, new Object[]{"java/lang/Throwable"});
                int throwableIndex = nLocals++;
                mw.visitVarInsn(58, throwableIndex);
                mw.visitMethodInsn(184, "com/android/layoutlib/bridge/Bridge", "getLog", "()Lcom/android/ide/common/rendering/api/LayoutLog;", false);
                mw.visitLdcInsn((Object)"broken");
                mw.visitLdcInsn((Object)(name + " error"));
                mw.visitVarInsn(25, throwableIndex);
                mw.visitInsn(1);
                mw.visitMethodInsn(182, "com/android/ide/common/rendering/api/LayoutLog", "error", ERROR_METHOD_DESCRIPTION, false);
                if ("onMeasure".equals(name)) {
                    mw.visitVarInsn(25, 0);
                    mw.visitInsn(3);
                    mw.visitInsn(3);
                    mw.visitMethodInsn(182, this.myClassName, "setMeasuredDimension", desc, false);
                }
                mw.visitLabel(exit);
                mw.visitFrame(3, 0, null, 0, null);
                mw.visitInsn(177);
                mw.visitMaxs(Math.max(argumentTypes.length + 1, 5), nLocals);
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                if (("onLayout".equals(name) && "(ZIIII)V".equals(desc) || "onMeasure".equals(name) && "(II)V".equals(desc) || "onDraw".equals(name) && "(Landroid/graphics/Canvas;)V".equals(desc)) && (access & 5) != 0) {
                    this.wrapMethod(access, name, desc, signature, exceptions);
                    int modifiedAccess = access & 0xFFFFFFFE & 0xFFFFFFFB | 2;
                    return super.visitMethod(modifiedAccess, name + ClassConverter.ORIGINAL_SUFFIX, desc, signature, exceptions);
                }
                return super.visitMethod(access, name, desc, signature, exceptions);
            }
        };
        ClassReader reader = new ClassReader(classData);
        reader.accept(classVisitor, 0);
        byte[] byArray = classWriter.toByteArray();
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/ClassConverter", "rewriteClass"));
        }
        return byArray;
    }

    public static int jdkToClassVersion(@NotNull String version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/android/tools/idea/rendering/ClassConverter", "jdkToClassVersion"));
        }
        int dot = version.indexOf(46);
        if (dot != -1) {
            int major;
            int end = version.length();
            for (int i = ++dot; i < end; ++i) {
                if (Character.isDigit(version.charAt(i))) continue;
                end = i;
                break;
            }
            if (end > dot && (major = Integer.valueOf(version.substring(dot, end)).intValue()) > 0) {
                return major + 44;
            }
        }
        return -1;
    }

    public static String classVersionToJdk(int version) {
        return "1." + Integer.toString(version - 44);
    }

    public static int findHighestMajorVersion(Collection<Throwable> list) {
        int result = 0;
        for (Throwable t : list) {
            if (!(t instanceof InconvertibleClassError)) continue;
            InconvertibleClassError error = (InconvertibleClassError)t;
            result = Math.max(result, error.getMajor());
        }
        return result;
    }

    public static String getCurrentJdkVersion() {
        String version = SystemInfo.JAVA_VERSION;
        int suffix = version.indexOf(95);
        if (suffix != -1) {
            version = version.substring(0, suffix);
        }
        return version;
    }

    public static int getCurrentClassVersion() {
        return ClassConverter.jdkToClassVersion(SystemInfo.JAVA_VERSION);
    }

    public static boolean isValidClassFile(@NotNull byte[] classData) {
        if (classData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classData", "com/android/tools/idea/rendering/ClassConverter", "isValidClassFile"));
        }
        return classData.length >= 7 && ClassConverter.getMagic(classData) == -889275714;
    }

    public static int getMagic(@NotNull byte[] classData) {
        if (classData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classData", "com/android/tools/idea/rendering/ClassConverter", "getMagic"));
        }
        return Ints.fromBytes((byte)classData[0], (byte)classData[1], (byte)classData[2], (byte)classData[3]);
    }

    public static short getMajorVersion(byte[] classData) {
        return Shorts.fromBytes((byte)classData[6], (byte)classData[7]);
    }

    public static short getMinorVersion(byte[] classData) {
        return Shorts.fromBytes((byte)classData[4], (byte)classData[5]);
    }

    static {
        String desc;
        block2: {
            try {
                desc = Type.getMethodDescriptor((Method)LayoutLog.class.getMethod("error", String.class, String.class, Throwable.class, Object.class));
            }
            catch (NoSuchMethodException e) {
                desc = "";
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        ERROR_METHOD_DESCRIPTION = desc;
    }
}

