/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.tools.idea.ddms.DevicePanel;
import com.android.tools.idea.ddms.adb.AdbService;
import com.android.tools.idea.logcat.AndroidLogcatView;
import com.android.tools.idea.monitor.AndroidToolWindowFactory;
import com.android.tools.idea.run.AndroidApplicationLauncher;
import com.android.tools.idea.run.AndroidExecutionState;
import com.android.tools.idea.run.AndroidProcessText;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.AndroidRunningStateListener;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.ApkInstaller;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.DebugLauncher;
import com.android.tools.idea.run.DeviceTarget;
import com.android.tools.idea.run.InstalledApkCache;
import com.android.tools.idea.run.LaunchOptions;
import com.android.tools.idea.run.LaunchUtils;
import com.android.tools.idea.run.ProcessHandlerConsolePrinter;
import com.android.tools.idea.stats.UsageTracker;
import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.DefaultDebugProcessHandler;
import java.awt.Component;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidOutputReceiver;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidRunningState
implements RunProfileState,
AndroidExecutionState {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.run.AndroidRunningState");
    public static final int WAITING_TIME_SECS = 20;
    public static final String DEVICE_COMMAND_PREFIX = "DEVICE SHELL COMMAND: ";
    private final ApkProvider myApkProvider;
    @NotNull
    private final String myPackageName;
    @NotNull
    private final AndroidFacet myFacet;
    @NotNull
    private final AndroidApplicationLauncher myApplicationLauncher;
    @NotNull
    private final ProcessHandlerConsolePrinter myPrinter;
    @NotNull
    private final AndroidRunConfigurationBase myConfiguration;
    @NotNull
    private final LaunchOptions myLaunchOptions;
    private final Object myDebugLock;
    @NotNull
    private final DeviceTarget myDeviceTarget;
    private volatile DebugLauncher myDebugLauncher;
    private final ExecutionEnvironment myEnv;
    private final AtomicBoolean myStopped;
    private volatile ProcessHandler myProcessHandler;
    private final Object myLock;
    private volatile boolean myApplicationDeployed;
    private ConsoleView myConsole;
    private final List<AndroidRunningStateListener> myListeners;
    private static int ourInstallationCount = 0;

    public AndroidRunningState(@NotNull ExecutionEnvironment environment, @NotNull AndroidFacet facet, @NotNull ApkProvider apkProvider, @NotNull DeviceTarget deviceTarget, @NotNull ProcessHandlerConsolePrinter printer, @NotNull AndroidApplicationLauncher applicationLauncher, @NotNull LaunchOptions launchOptions, @NotNull AndroidRunConfigurationBase configuration) throws ExecutionException {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/android/tools/idea/run/AndroidRunningState", "<init>"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/AndroidRunningState", "<init>"));
        }
        if (apkProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "apkProvider", "com/android/tools/idea/run/AndroidRunningState", "<init>"));
        }
        if (deviceTarget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceTarget", "com/android/tools/idea/run/AndroidRunningState", "<init>"));
        }
        if (printer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printer", "com/android/tools/idea/run/AndroidRunningState", "<init>"));
        }
        if (applicationLauncher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applicationLauncher", "com/android/tools/idea/run/AndroidRunningState", "<init>"));
        }
        if (launchOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launchOptions", "com/android/tools/idea/run/AndroidRunningState", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/run/AndroidRunningState", "<init>"));
        }
        this.myDebugLock = new Object();
        this.myStopped = new AtomicBoolean(false);
        this.myLock = new Object();
        this.myApplicationDeployed = false;
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myFacet = facet;
        this.myApkProvider = apkProvider;
        this.myDeviceTarget = deviceTarget;
        this.myPrinter = printer;
        this.myConfiguration = configuration;
        this.myEnv = environment;
        this.myApplicationLauncher = applicationLauncher;
        this.myLaunchOptions = launchOptions;
        try {
            this.myPackageName = this.myApkProvider.getPackageName();
        }
        catch (ApkProvisionException e) {
            throw new ExecutionException("Unable to determine package name", (Throwable)e);
        }
    }

    @Nullable
    public DebugLauncher getDebugLauncher() {
        return this.myDebugLauncher;
    }

    public void setDebugLauncher(@NotNull DebugLauncher debugLauncher) {
        if (debugLauncher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugLauncher", "com/android/tools/idea/run/AndroidRunningState", "setDebugLauncher"));
        }
        this.myDebugLauncher = debugLauncher;
    }

    public boolean isDebugMode() {
        return this.myLaunchOptions.isDebug();
    }

    @Override
    @NotNull
    public AndroidRunConfigurationBase getConfiguration() {
        AndroidRunConfigurationBase androidRunConfigurationBase = this.myConfiguration;
        if (androidRunConfigurationBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidRunningState", "getConfiguration"));
        }
        return androidRunConfigurationBase;
    }

    public ExecutionEnvironment getEnvironment() {
        return this.myEnv;
    }

    public boolean isStopped() {
        return this.myStopped.get();
    }

    public AtomicBoolean getStoppedRef() {
        return this.myStopped;
    }

    public Object getRunningLock() {
        return this.myLock;
    }

    @NotNull
    public String getPackageName() {
        String string = this.myPackageName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidRunningState", "getPackageName"));
        }
        return string;
    }

    public String getTestPackageName() {
        try {
            return this.myApkProvider.getTestPackageName();
        }
        catch (ApkProvisionException e) {
            return null;
        }
    }

    public Module getModule() {
        return this.myFacet.getModule();
    }

    @NotNull
    public AndroidFacet getFacet() {
        AndroidFacet androidFacet = this.myFacet;
        if (androidFacet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidRunningState", "getFacet"));
        }
        return androidFacet;
    }

    @Override
    @Nullable
    public Collection<IDevice> getDevices() {
        return this.myDeviceTarget.getDevicesIfReady();
    }

    @Override
    @Nullable
    public ConsoleView getConsoleView() {
        return this.myConsole;
    }

    @NotNull
    public ConsolePrinter getPrinter() {
        ProcessHandlerConsolePrinter processHandlerConsolePrinter = this.myPrinter;
        if (processHandlerConsolePrinter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidRunningState", "getPrinter"));
        }
        return processHandlerConsolePrinter;
    }

    private void launchDebug(@NotNull Client client) {
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/android/tools/idea/run/AndroidRunningState", "launchDebug"));
        }
        this.myDebugLauncher.launchDebug(client);
        this.myDebugLauncher = null;
    }

    public void setConsole(@NotNull ConsoleView console) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/android/tools/idea/run/AndroidRunningState", "setConsole"));
        }
        this.myConsole = console;
    }

    public ExecutionResult execute(final @NotNull Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/android/tools/idea/run/AndroidRunningState", "execute"));
        }
        if (runner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "com/android/tools/idea/run/AndroidRunningState", "execute"));
        }
        this.myProcessHandler = new DefaultDebugProcessHandler();
        AndroidProcessText.attach(this.myProcessHandler);
        this.myConsole = this.myConfiguration.attachConsole(this, executor);
        this.myPrinter.setProcessHandler(this.myProcessHandler);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                AndroidRunningState.this.start();
            }
        });
        this.getProcessHandler().addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                if (outputType.equals((Object)ProcessOutputTypes.STDERR)) {
                    UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ToolWindowManager.getInstance((Project)AndroidRunningState.this.myFacet.getModule().getProject()).getToolWindow(executor.getToolWindowId()).activate(null, true, false);
                        }
                    });
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void processWillTerminate(ProcessEvent event, boolean willBeDestroyed) {
                for (ListenableFuture<IDevice> deviceFuture : AndroidRunningState.this.myDeviceTarget.getDeviceFutures()) {
                    deviceFuture.cancel(true);
                }
                AndroidRunningState.this.myStopped.set(true);
                Object object = AndroidRunningState.this.myLock;
                synchronized (object) {
                    AndroidRunningState.this.myLock.notifyAll();
                }
                AndroidRunningState.this.getProcessHandler().removeProcessListener((ProcessListener)this);
            }
        });
        return new DefaultExecutionResult((ExecutionConsole)this.myConsole, this.myProcessHandler);
    }

    void start() {
        final AtomicInteger startedCount = new AtomicInteger();
        for (ListenableFuture<IDevice> targetDevice : this.myDeviceTarget.getDeviceFutures()) {
            Futures.addCallback(targetDevice, (FutureCallback)new FutureCallback<IDevice>(){

                public void onSuccess(@Nullable IDevice device) {
                    if (AndroidRunningState.this.myStopped.get() || device == null) {
                        return;
                    }
                    if (AndroidRunningState.this.isDebugMode()) {
                        final MyClientChangeListener listener = new MyClientChangeListener(device);
                        AndroidDebugBridge.addClientChangeListener((AndroidDebugBridge.IClientChangeListener)listener);
                        AndroidRunningState.this.getProcessHandler().addProcessListener((ProcessListener)new ProcessAdapter(){

                            public void processWillTerminate(ProcessEvent event, boolean willBeDestroyed) {
                                AndroidDebugBridge.removeClientChangeListener((AndroidDebugBridge.IClientChangeListener)listener);
                            }
                        });
                    }
                    if (AndroidRunningState.this.prepareAndStartApp(device)) {
                        if (startedCount.incrementAndGet() == AndroidRunningState.this.myDeviceTarget.getDeviceFutures().size() && !AndroidRunningState.this.isDebugMode()) {
                            AndroidRunningState.this.myStopped.set(true);
                            AndroidRunningState.this.getProcessHandler().destroyProcess();
                        }
                        AndroidRunningState.this.fireExecutionStarted(device);
                    } else {
                        AndroidRunningState.this.fireExecutionFailed();
                        AndroidRunningState.this.myStopped.set(true);
                        AndroidRunningState.this.getProcessHandler().destroyProcess();
                    }
                }

                public void onFailure(@NotNull Throwable t) {
                    if (t == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/android/tools/idea/run/AndroidRunningState$3", "onFailure"));
                    }
                    AndroidRunningState.this.myPrinter.stderr(t.getMessage());
                    AndroidRunningState.this.myStopped.set(true);
                    AndroidRunningState.this.getProcessHandler().destroyProcess();
                }
            });
        }
    }

    public synchronized void setProcessHandler(ProcessHandler processHandler) {
        this.myProcessHandler = processHandler;
        this.myPrinter.setProcessHandler(processHandler);
    }

    public synchronized ProcessHandler getProcessHandler() {
        return this.myProcessHandler;
    }

    private void fireExecutionFailed() {
        for (AndroidRunningStateListener listener : this.myListeners) {
            listener.executionFailed();
        }
    }

    private void fireExecutionStarted(@NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/AndroidRunningState", "fireExecutionStarted"));
        }
        for (AndroidRunningStateListener listener : this.myListeners) {
            listener.executionStarted(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean prepareAndStartApp(@NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/AndroidRunningState", "prepareAndStartApp"));
        }
        if (this.isDebugMode() && !LaunchUtils.canDebugAppOnDevice(this.myFacet, device)) {
            this.myPrinter.stderr(AndroidBundle.message("android.cannot.debug.noDebugPermissions", this.getPackageName(), device.getName()));
            return false;
        }
        if (this.myLaunchOptions.isClearLogcatBeforeStart()) {
            AndroidRunningState.clearLogcatAndConsole(this.getModule().getProject(), device);
        }
        this.myPrinter.stdout("Target device: " + device.getName());
        try {
            Client client;
            if (this.myLaunchOptions.isDeploy()) {
                if (!this.installApks(device)) {
                    return false;
                }
                AndroidRunningState.trackInstallation(device);
                this.myApplicationDeployed = true;
            }
            LaunchUtils.initiateDismissKeyguard(device);
            AndroidApplicationLauncher.LaunchResult launchResult = this.myApplicationLauncher.launch(this, device);
            if (launchResult == AndroidApplicationLauncher.LaunchResult.STOP) {
                return false;
            }
            if (launchResult == AndroidApplicationLauncher.LaunchResult.SUCCESS) {
                this.checkDdms();
            }
            String pkgName = this.getPackageName();
            Object object = this.myDebugLock;
            synchronized (object) {
                client = device.getClient(pkgName);
                if (this.myDebugLauncher != null) {
                    if (client != null && this.myApplicationLauncher.isReadyForDebugging(client.getClientData(), this.getProcessHandler())) {
                        this.launchDebug(client);
                    } else {
                        this.myPrinter.stdout("Waiting for process: " + pkgName);
                    }
                }
            }
            if (!this.isDebugMode() && this.myLaunchOptions.isOpenLogcatAutomatically()) {
                this.showLogcatConsole(device, client);
            }
            return true;
        }
        catch (TimeoutException e) {
            LOG.info((Throwable)e);
            this.myPrinter.stderr("Error: Connection to ADB failed with a timeout");
            return false;
        }
        catch (AdbCommandRejectedException e) {
            LOG.info((Throwable)e);
            this.myPrinter.stderr("Error: adb rejected command: " + (Object)((Object)e));
            return false;
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            String message = e.getMessage();
            this.myPrinter.stderr("I/O Error" + (message != null ? ": " + message : ""));
            return false;
        }
    }

    private boolean installApks(@NotNull IDevice device) {
        Collection<ApkInfo> apks;
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/AndroidRunningState", "installApks"));
        }
        try {
            apks = this.myApkProvider.getApks(device);
        }
        catch (ApkProvisionException e) {
            this.myPrinter.stderr(e.getMessage());
            LOG.warn((Throwable)e);
            return false;
        }
        ApkInstaller installer = new ApkInstaller(this.myFacet, this.myLaunchOptions, (InstalledApkCache)ServiceManager.getService(InstalledApkCache.class), this.myPrinter);
        for (ApkInfo apk : apks) {
            if (!apk.getFile().exists()) {
                String message = "The APK file " + apk.getFile().getPath() + " does not exist on disk.";
                this.myPrinter.stderr(message);
                LOG.error(message);
                return false;
            }
            if (installer.uploadAndInstallApk(device, apk.getApplicationId(), apk.getFile(), this.myStopped)) continue;
            return false;
        }
        return true;
    }

    private static void trackInstallation(@NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/AndroidRunningState", "trackInstallation"));
        }
        if (!UsageTracker.getInstance().canTrack()) {
            return;
        }
        if ((ourInstallationCount = (ourInstallationCount + 1) % 10) != 0) {
            return;
        }
        UsageTracker.getInstance().trackEvent("deployment", "apkDeployed", null, null);
        UsageTracker.getInstance().trackEvent("deviceInfo", "ro.serialno.hashed", Hashing.md5().hashString((CharSequence)device.getSerialNumber(), Charsets.UTF_8).toString(), null);
        UsageTracker.getInstance().trackEvent("deviceInfo", "ro.build.tags", device.getProperty("ro.build.tags"), null);
        UsageTracker.getInstance().trackEvent("deviceInfo", "ro.build.type", device.getProperty("ro.build.type"), null);
        UsageTracker.getInstance().trackEvent("deviceInfo", "ro.build.version.release", device.getProperty("ro.build.version.release"), null);
        UsageTracker.getInstance().trackEvent("deviceInfo", "ro.build.version.sdk", device.getProperty("ro.build.version.sdk"), null);
        UsageTracker.getInstance().trackEvent("deviceInfo", "ro.product.manufacturer", device.getProperty("ro.product.manufacturer"), null);
        UsageTracker.getInstance().trackEvent("deviceInfo", "ro.product.model", device.getProperty("ro.product.model"), null);
        UsageTracker.getInstance().trackEvent("deviceInfo", "ro.product.cpu.abi", device.getProperty("ro.product.cpu.abi"), null);
    }

    private static void clearLogcatAndConsole(final @NotNull Project project, final @NotNull IDevice device) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/run/AndroidRunningState", "clearLogcatAndConsole"));
        }
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/AndroidRunningState", "clearLogcatAndConsole"));
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(AndroidToolWindowFactory.TOOL_WINDOW_ID);
                if (toolWindow == null) {
                    return;
                }
                for (Content content : toolWindow.getContentManager().getContents()) {
                    AndroidLogcatView view = (AndroidLogcatView)content.getUserData(AndroidLogcatView.ANDROID_LOGCAT_VIEW_KEY);
                    if (view == null) continue;
                    view.clearLogcat(device);
                }
            }
        });
    }

    private void showLogcatConsole(final @NotNull IDevice device, final @Nullable Client client) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/AndroidRunningState", "showLogcatConsole"));
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                final ToolWindow androidToolWindow = ToolWindowManager.getInstance((Project)AndroidRunningState.this.myEnv.getProject()).getToolWindow(AndroidToolWindowFactory.TOOL_WINDOW_ID);
                androidToolWindow.activate(new Runnable(){

                    @Override
                    public void run() {
                        int count = androidToolWindow.getContentManager().getContentCount();
                        for (int i = 0; i < count; ++i) {
                            DevicePanel devicePanel;
                            Content content = androidToolWindow.getContentManager().getContent(i);
                            DevicePanel devicePanel2 = devicePanel = content == null ? null : (DevicePanel)content.getUserData(AndroidToolWindowFactory.DEVICES_PANEL_KEY);
                            if (devicePanel == null) continue;
                            devicePanel.selectDevice(device);
                            devicePanel.selectClient(client);
                            break;
                        }
                    }
                }, false);
            }
        });
    }

    private boolean checkDdms() {
        AndroidDebugBridge bridge = AndroidDebugBridge.getBridge();
        if (this.isDebugMode() && bridge != null && AdbService.canDdmsBeCorrupted(bridge)) {
            JComponent component;
            this.myPrinter.stderr(AndroidBundle.message("ddms.corrupted.error", new Object[0]));
            JComponent jComponent = component = this.myConsole == null ? null : this.myConsole.getComponent();
            if (component != null) {
                final ExecutionEnvironment environment = (ExecutionEnvironment)LangDataKeys.EXECUTION_ENVIRONMENT.getData(DataManager.getInstance().getDataContext((Component)component));
                if (environment == null) {
                    return false;
                }
                this.myConsole.printHyperlink(AndroidBundle.message("restart.adb.fix.text", new Object[0]), new HyperlinkInfo(){

                    public void navigate(Project project) {
                        AdbService.getInstance().restartDdmlib(project);
                        ProcessHandler processHandler = AndroidRunningState.this.getProcessHandler();
                        if (!processHandler.isProcessTerminated()) {
                            processHandler.destroyProcess();
                        }
                        ExecutionUtil.restart((ExecutionEnvironment)environment);
                    }
                });
                this.myConsole.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
            }
            return false;
        }
        return true;
    }

    public void executeDeviceCommandAndWriteToConsole(@NotNull IDevice device, @NotNull String command, @NotNull AndroidOutputReceiver receiver) throws IOException, TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/AndroidRunningState", "executeDeviceCommandAndWriteToConsole"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/android/tools/idea/run/AndroidRunningState", "executeDeviceCommandAndWriteToConsole"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "com/android/tools/idea/run/AndroidRunningState", "executeDeviceCommandAndWriteToConsole"));
        }
        this.myPrinter.stdout(DEVICE_COMMAND_PREFIX + command);
        AndroidUtils.executeCommandOnDevice(device, command, receiver, false);
    }

    public void addListener(@NotNull AndroidRunningStateListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/run/AndroidRunningState", "addListener"));
        }
        this.myListeners.add(listener);
    }

    private class MyClientChangeListener
    implements AndroidDebugBridge.IClientChangeListener {
        @NotNull
        private final IDevice myDevice;

        MyClientChangeListener(IDevice device) {
            if (device == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/AndroidRunningState$MyClientChangeListener", "<init>"));
            }
            this.myDevice = device;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clientChanged(Client client, int changeMask) {
            Object object = AndroidRunningState.this.myDebugLock;
            synchronized (object) {
                ClientData data;
                if (AndroidRunningState.this.myDebugLauncher == null) {
                    return;
                }
                if (AndroidRunningState.this.myLaunchOptions.isDeploy() && !AndroidRunningState.this.myApplicationDeployed) {
                    return;
                }
                IDevice device = client.getDevice();
                if (this.myDevice.equals(device) && device.isOnline() && this.isToLaunchDebug(data = client.getClientData())) {
                    AndroidRunningState.this.launchDebug(client);
                }
            }
        }

        private boolean isToLaunchDebug(@NotNull ClientData data) {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/idea/run/AndroidRunningState$MyClientChangeListener", "isToLaunchDebug"));
            }
            if (AndroidRunningState.this.myApplicationLauncher.isReadyForDebugging(data, AndroidRunningState.this.getProcessHandler())) {
                return true;
            }
            String description = data.getClientDescription();
            if (description == null) {
                return false;
            }
            return description.equals(AndroidRunningState.this.getPackageName());
        }
    }
}

