/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceStateCache<T>
implements AndroidDebugBridge.IDeviceChangeListener,
Disposable {
    private final Table<String, String, T> myCache;

    public DeviceStateCache(@NotNull Disposable parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/run/DeviceStateCache", "<init>"));
        }
        this.myCache = HashBasedTable.create();
        Disposer.register((Disposable)parent, (Disposable)this);
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
    }

    public void dispose() {
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
    }

    @Nullable
    public T get(@NotNull IDevice device, @NotNull String pkgName) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/DeviceStateCache", "get"));
        }
        if (pkgName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pkgName", "com/android/tools/idea/run/DeviceStateCache", "get"));
        }
        return (T)this.myCache.get((Object)device.getSerialNumber(), (Object)pkgName);
    }

    @Nullable
    public T put(@NotNull IDevice device, @NotNull String pkgName, @NotNull T data) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/DeviceStateCache", "put"));
        }
        if (pkgName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pkgName", "com/android/tools/idea/run/DeviceStateCache", "put"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/idea/run/DeviceStateCache", "put"));
        }
        return (T)this.myCache.put((Object)device.getSerialNumber(), (Object)pkgName, data);
    }

    public void deviceConnected(IDevice device) {
    }

    public void deviceDisconnected(IDevice device) {
        this.myCache.row((Object)device.getSerialNumber()).clear();
    }

    public void deviceChanged(IDevice device, int changeMask) {
    }
}

