/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.ide.common.repository.SdkMavenRepository;
import com.android.sdklib.SdkManager;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.tools.idea.sdk.remote.RemotePkgInfo;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallableComponent;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidSdk
extends InstallableComponent {
    public static final long SIZE = 265L * Storage.Unit.MiB.getNumberOfBytes();

    public AndroidSdk(@NotNull ScopedStateStore store) {
        if (store == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "store", "com/android/tools/idea/welcome/install/AndroidSdk", "<init>"));
        }
        super(store, "Android SDK", SIZE, "The collection of Android platform APIs, tools and utilities that enables you to debug, profile, and compile your apps.\n\nThe setup wizard will update your current Android SDK installation (if necessary) or install a new version.");
    }

    @Nullable
    private static FullRevision getLatestCompatibleBuildToolsRevision(@NotNull Multimap<PkgType, RemotePkgInfo> packages) {
        if (packages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packages", "com/android/tools/idea/welcome/install/AndroidSdk", "getLatestCompatibleBuildToolsRevision"));
        }
        FullRevision revision = null;
        Collection tools = packages.get((Object)PkgType.PKG_BUILD_TOOLS);
        for (RemotePkgInfo tool : tools) {
            FullRevision fullRevision = tool.getPkgDesc().getFullRevision();
            if (fullRevision == null || fullRevision.isPreview() || revision != null && fullRevision.compareTo(revision) <= 0) continue;
            revision = fullRevision;
        }
        return revision;
    }

    @Override
    @NotNull
    public Collection<IPkgDesc> getRequiredSdkPackages(@Nullable Multimap<PkgType, RemotePkgInfo> remotePackages) {
        FullRevision revision;
        ArrayList result = Lists.newArrayList();
        result.add(PkgDesc.Builder.newTool((FullRevision)FullRevision.NOT_SPECIFIED, (FullRevision)FullRevision.NOT_SPECIFIED).create());
        result.add(PkgDesc.Builder.newPlatformTool((FullRevision)FullRevision.NOT_SPECIFIED).create());
        if (remotePackages != null && (revision = AndroidSdk.getLatestCompatibleBuildToolsRevision(remotePackages)) != null) {
            result.add(PkgDesc.Builder.newBuildTool((FullRevision)revision).create());
        }
        for (SdkMavenRepository repository : SdkMavenRepository.values()) {
            result.add(repository.getPackageDescription());
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/install/AndroidSdk", "getRequiredSdkPackages"));
        }
        return arrayList;
    }

    @Override
    public void configure(@NotNull InstallContext installContext, @NotNull File sdk) {
        if (installContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "installContext", "com/android/tools/idea/welcome/install/AndroidSdk", "configure"));
        }
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/android/tools/idea/welcome/install/AndroidSdk", "configure"));
        }
    }

    @Override
    protected boolean isOptionalForSdkLocation(@Nullable SdkManager manager) {
        return false;
    }
}

