/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.propertyTable;

import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.propertyTable.IXmlAttributeLocator;
import com.intellij.designer.model.MetaModel;
import com.intellij.designer.model.PropertiesContainer;
import com.intellij.designer.model.Property;
import com.intellij.designer.propertyTable.IPropertyDecorator;
import com.intellij.designer.propertyTable.PropertyEditor;
import com.intellij.designer.propertyTable.PropertyRenderer;
import com.intellij.designer.propertyTable.renderers.LabelPropertyRenderer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlAttribute;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompoundProperty
extends Property<RadViewComponent>
implements IPropertyDecorator,
IXmlAttributeLocator {
    private final List<Property<RadViewComponent>> myChildren;
    private PropertyRenderer myRenderer;

    public CompoundProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/android/designer/propertyTable/CompoundProperty", "<init>"));
        }
        super(null, name);
        this.myChildren = new ArrayList<Property<RadViewComponent>>();
    }

    public Property<RadViewComponent> createForNewPresentation(@Nullable Property parent, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/android/designer/propertyTable/CompoundProperty", "createForNewPresentation"));
        }
        CompoundProperty property = this.createForNewPresentation(name);
        List<Property<RadViewComponent>> children = property.getChildren((RadViewComponent)null);
        for (Property<RadViewComponent> childProperty : this.myChildren) {
            children.add((Property<RadViewComponent>)childProperty.createForNewPresentation((Property)property, childProperty.getName()));
        }
        return property;
    }

    public void decorate(@NotNull MetaModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/android/designer/propertyTable/CompoundProperty", "decorate"));
        }
        String name = this.getName();
        model.decorate0((Property)this, name);
        for (Property<RadViewComponent> childProperty : this.myChildren) {
            model.decorate(childProperty, name + "." + childProperty.getName());
        }
    }

    @NotNull
    public List<Property<RadViewComponent>> getChildren(@Nullable RadViewComponent component) {
        List<Property<RadViewComponent>> list = this.myChildren;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/propertyTable/CompoundProperty", "getChildren"));
        }
        return list;
    }

    protected CompoundProperty createForNewPresentation(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/android/designer/propertyTable/CompoundProperty", "createForNewPresentation"));
        }
        return new CompoundProperty(name);
    }

    public Object getValue(@NotNull RadViewComponent component) throws Exception {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/android/designer/propertyTable/CompoundProperty", "getValue"));
        }
        StringBuilder value = new StringBuilder();
        int index = 0;
        int empty = 0;
        for (Property<RadViewComponent> childProperty : this.myChildren) {
            String childValue;
            if (index++ > 0) {
                value.append(", ");
            }
            if (StringUtil.isEmpty((String)(childValue = (String)childProperty.getValue((PropertiesContainer)component)))) {
                ++empty;
                value.append("?");
                continue;
            }
            value.append(childValue);
        }
        if (empty == this.myChildren.size()) {
            return "";
        }
        return value.toString();
    }

    public void setDefaultValue(@NotNull RadViewComponent component) throws Exception {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/android/designer/propertyTable/CompoundProperty", "setDefaultValue"));
        }
        for (Property<RadViewComponent> childProperty : this.myChildren) {
            childProperty.setDefaultValue((PropertiesContainer)component);
        }
    }

    @NotNull
    public PropertyRenderer getRenderer() {
        if (this.myRenderer == null) {
            this.myRenderer = new LabelPropertyRenderer(null);
        }
        PropertyRenderer propertyRenderer = this.myRenderer;
        if (propertyRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/propertyTable/CompoundProperty", "getRenderer"));
        }
        return propertyRenderer;
    }

    public PropertyEditor getEditor() {
        return null;
    }

    public String getJavadocText() {
        return this.myChildren.isEmpty() ? null : this.myChildren.get(0).getJavadocText();
    }

    @Override
    public boolean checkAttribute(RadViewComponent component, XmlAttribute attribute) {
        for (Property<RadViewComponent> childProperty : this.myChildren) {
            if (!((IXmlAttributeLocator)childProperty).checkAttribute(component, attribute)) continue;
            return true;
        }
        return false;
    }
}

