/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.converter;

import com.intellij.conversion.ModuleSettings;
import java.util.Collection;
import org.jdom.Element;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetType;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AndroidConversionUtil {
    @NonNls
    static final String OPTION_VALUE_ATTRIBUTE = "value";

    private AndroidConversionUtil() {
    }

    @Nullable
    public static String getOptionValue(@NotNull Element e, @NotNull String optionName) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/android/converter/AndroidConversionUtil", "getOptionValue"));
        }
        if (optionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionName", "org/jetbrains/android/converter/AndroidConversionUtil", "getOptionValue"));
        }
        Element element = AndroidConversionUtil.getOptionElement(e, optionName);
        return element != null ? element.getAttributeValue(OPTION_VALUE_ATTRIBUTE) : null;
    }

    @Nullable
    public static Element getOptionElement(@NotNull Element e, @NotNull String optionName) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/android/converter/AndroidConversionUtil", "getOptionElement"));
        }
        if (optionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionName", "org/jetbrains/android/converter/AndroidConversionUtil", "getOptionElement"));
        }
        for (Element optionElement : e.getChildren("option")) {
            if (!optionName.equals(optionElement.getAttributeValue("name"))) continue;
            return optionElement;
        }
        return null;
    }

    @Nullable
    public static Element findAndroidFacetConfigurationElement(@Nullable ModuleSettings moduleSettings) {
        Collection facetElements;
        AndroidFacetType facetType;
        if (moduleSettings != null && (facetType = AndroidFacet.getFacetType()) != null && !(facetElements = moduleSettings.getFacetElements(facetType.getStringId())).isEmpty()) {
            return ((Element)facetElements.iterator().next()).getChild("configuration");
        }
        return null;
    }
}

