/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.project.Project;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.project.MavenEmbeddersManager;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsBatchProcessorBasicTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.ResolveContext;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;

public class MavenProjectsProcessorResolvingTask
extends MavenProjectsBatchProcessorBasicTask {
    @NotNull
    private final MavenGeneralSettings myGeneralSettings;
    @Nullable
    private final Runnable myOnCompletion;
    @NotNull
    private final ResolveContext myContext;

    public MavenProjectsProcessorResolvingTask(@NotNull Collection<MavenProject> projects, @NotNull MavenProjectsTree tree, @NotNull MavenGeneralSettings generalSettings, @Nullable Runnable onCompletion, @NotNull ResolveContext context) {
        if (projects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projects", "org/jetbrains/idea/maven/project/MavenProjectsProcessorResolvingTask", "<init>"));
        }
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/idea/maven/project/MavenProjectsProcessorResolvingTask", "<init>"));
        }
        if (generalSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generalSettings", "org/jetbrains/idea/maven/project/MavenProjectsProcessorResolvingTask", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/idea/maven/project/MavenProjectsProcessorResolvingTask", "<init>"));
        }
        super(projects, tree);
        this.myGeneralSettings = generalSettings;
        this.myOnCompletion = onCompletion;
        this.myContext = context;
    }

    @Override
    public void perform(Project project, MavenEmbeddersManager embeddersManager, MavenConsole console, MavenProgressIndicator indicator) throws MavenProcessCanceledException {
        this.myTree.resolve(project, this.myMavenProjects, this.myGeneralSettings, embeddersManager, console, this.myContext, indicator);
        if (this.myOnCompletion != null) {
            this.myOnCompletion.run();
        }
    }
}

