/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.importWizard;

import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectImportBuilder;
import com.intellij.projectImport.ProjectOpenProcessorBase;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.eclipse.EclipseProjectFinder;
import org.jetbrains.idea.eclipse.importWizard.EclipseImportBuilder;

public class EclipseProjectOpenProcessor
extends ProjectOpenProcessorBase<EclipseImportBuilder> {
    public EclipseProjectOpenProcessor(@NotNull EclipseImportBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/idea/eclipse/importWizard/EclipseProjectOpenProcessor", "<init>"));
        }
        super((ProjectImportBuilder)builder);
    }

    @Nullable
    public String[] getSupportedExtensions() {
        return new String[]{".classpath", ".project"};
    }

    public boolean doQuickImport(VirtualFile file, WizardContext wizardContext) {
        ((EclipseImportBuilder)this.getBuilder()).setRootDirectory(file.getParent().getPath());
        List<String> projects = ((EclipseImportBuilder)this.getBuilder()).getList();
        if (projects == null || projects.size() != 1) {
            return false;
        }
        ((EclipseImportBuilder)this.getBuilder()).setList(projects);
        wizardContext.setProjectName(EclipseProjectFinder.findProjectName((String)projects.get(0)));
        return true;
    }
}

