/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.util;

import com.android.jarutils.SignedJarBuilder;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;

public class SafeSignedJarBuilder
extends SignedJarBuilder {
    private final String myOutFilePath;

    public SafeSignedJarBuilder(FileOutputStream outputStream, PrivateKey key, X509Certificate certificate, String outFilePath) throws IOException, NoSuchAlgorithmException {
        super((OutputStream)outputStream, key, certificate);
        this.myOutFilePath = FileUtil.toSystemDependentName((String)outFilePath);
    }

    public void writeFile(File inputFile, String jarPath) throws IOException {
        if (FileUtil.pathsEqual((String)inputFile.getPath(), (String)this.myOutFilePath)) {
            throw new IOException("Cannot pack file " + this.myOutFilePath + " into itself");
        }
        super.writeFile(inputFile, jarPath);
    }
}

